/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.flowgraph;

import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeMultiFilter;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.ISearchableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.TreeNodeSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ISortableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractBaseTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.flowgraph.SingleFlowGraphBasicBlockTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.flowgraph.SingleFlowGraphRootTreeNode;
import com.google.security.zynamics.bindiff.project.matches.IMatchesChangeListener;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SingleFlowGraphBaseTreeNode
extends AbstractBaseTreeNode {
    private static final Icon MATCHED_IDENTICAL_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/matched-functions.png");
    private static final Icon MATCHED_INSTRUCTIONCHANGED_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/instructions-changed-function.png");
    private static final Icon MATCHED_STRUCTURALCHANGED_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/structural-changed-function.png");
    private static final Icon PRIMARY_UNMATCHED_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/primary-unmatched-functions.png");
    private static final Icon SECONDRAY_UNMATCHED_FUNCNTION_ICON = ImageUtils.getImageIcon("data/treeicons/secondary-unmatched-functions.png");
    private final IMatchesChangeListener matchesChangeListener = new InternalMatchesChangeListener();
    private final List<SingleFlowGraphBasicBlockTreeNode> basicBlockTreeNodes = new ArrayList<SingleFlowGraphBasicBlockTreeNode>();
    private SingleDiffNode lastSelectedTreeNode;

    public SingleFlowGraphBaseTreeNode(SingleFlowGraphRootTreeNode singleFlowGraphRootTreeNode) {
        super(singleFlowGraphRootTreeNode);
        this.createChildren();
        this.getDiff().getMatches().addListener(this.matchesChangeListener);
    }

    private void replaceBasicblockTreeNode(IAddress iAddress) {
        SingleDiffNode singleDiffNode = null;
        for (Object object : this.getRootNode().getGraph().getNodes()) {
            if (!iAddress.equals(((SingleDiffNode)object).getRawNode().getAddress())) continue;
            singleDiffNode = object;
            break;
        }
        if (singleDiffNode != null) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                Object object;
                object = (SingleFlowGraphBasicBlockTreeNode)this.getChildAt(i2);
                RawBasicBlock rawBasicBlock = ((SingleFlowGraphBasicBlockTreeNode)object).getBasicblock();
                if (!iAddress.equals(rawBasicBlock.getAddress())) continue;
                SingleFlowGraphBasicBlockTreeNode singleFlowGraphBasicBlockTreeNode = new SingleFlowGraphBasicBlockTreeNode(this.getRootNode(), singleDiffNode);
                this.insert(singleFlowGraphBasicBlockTreeNode, i2);
                int n2 = this.basicBlockTreeNodes.indexOf(object);
                this.basicBlockTreeNodes.set(n2, singleFlowGraphBasicBlockTreeNode);
                break;
            }
            this.updateTreeNodes(true);
        }
    }

    @Override
    protected void delete() {
        this.getDiff().getMatches().removeListener(this.matchesChangeListener);
        super.delete();
    }

    @Override
    protected void updateTreeNodes(boolean bl2) {
        TreeNodeSearcher treeNodeSearcher = this.getSearcher();
        GraphNodeMultiFilter graphNodeMultiFilter = this.getFilter();
        ArrayList<SingleFlowGraphBasicBlockTreeNode> arrayList = new ArrayList<SingleFlowGraphBasicBlockTreeNode>();
        if (treeNodeSearcher.getUseTemporaryResults() && !"".equals(treeNodeSearcher.getSearchString())) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                arrayList.add((SingleFlowGraphBasicBlockTreeNode)this.getChildAt(i2));
            }
        } else {
            arrayList.addAll(this.basicBlockTreeNodes);
        }
        this.removeAllChildren();
        List<Object> list = new ArrayList();
        if (bl2) {
            if (!"".equals(treeNodeSearcher.getSearchString())) {
                list = treeNodeSearcher.search(arrayList);
                arrayList.clear();
                for (ISearchableTreeNode iterator2 : list) {
                    arrayList.add((SingleFlowGraphBasicBlockTreeNode)iterator2);
                }
            } else {
                treeNodeSearcher.search((List<? extends ISearchableTreeNode>)null);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (SingleFlowGraphBasicBlockTreeNode singleFlowGraphBasicBlockTreeNode : arrayList) {
            if (!graphNodeMultiFilter.filterRawBasicblock(singleFlowGraphBasicBlockTreeNode.getBasicblock())) continue;
            if (!bl2 && !"".equals(treeNodeSearcher.getSearchString())) {
                if (!treeNodeSearcher.isSearchHit(singleFlowGraphBasicBlockTreeNode.getSingleDiffNode())) continue;
                arrayList2.add(singleFlowGraphBasicBlockTreeNode);
                continue;
            }
            arrayList2.add(singleFlowGraphBasicBlockTreeNode);
        }
        for (Comparator<ISortableTreeNode> comparator : this.getRootNode().getSorter().getSingleBasicBlockTreeNodeComparatorList()) {
            Collections.sort(arrayList2, comparator);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            SingleFlowGraphBasicBlockTreeNode singleFlowGraphBasicBlockTreeNode = (SingleFlowGraphBasicBlockTreeNode)iterator.next();
            this.add(singleFlowGraphBasicBlockTreeNode);
        }
        this.getTree().getModel().nodeStructureChanged(this);
        this.getTree().updateUI();
    }

    @Override
    public void createChildren() {
        this.basicBlockTreeNodes.clear();
        SingleFlowGraphRootTreeNode singleFlowGraphRootTreeNode = this.getRootNode();
        for (SingleDiffNode singleDiffNode : this.getRootNode().getGraph().getNodes()) {
            this.basicBlockTreeNodes.add(new SingleFlowGraphBasicBlockTreeNode(singleFlowGraphRootTreeNode, singleDiffNode));
        }
        this.updateTreeNodes(false);
    }

    @Override
    public Icon getIcon() {
        FlowGraphViewData flowGraphViewData = this.getRootNode().getView();
        ESide eSide = this.getRootNode().getSide();
        RawFlowGraph rawFlowGraph = flowGraphViewData.getRawGraph(eSide);
        IAddress iAddress = rawFlowGraph.getAddress();
        RawFunction rawFunction = this.getDiff().getCallGraph(eSide).getFunction(iAddress);
        EMatchState eMatchState = rawFunction.getMatchState();
        if (eMatchState == EMatchState.MATCHED) {
            IAddress iAddress2 = rawFunction.getMatchedFunctionAddress();
            RawFunction rawFunction2 = rawFunction.getSide() == ESide.PRIMARY ? rawFunction : this.getDiff().getFunction(iAddress2, ESide.PRIMARY);
            if (rawFunction2.isIdenticalMatch()) {
                return MATCHED_IDENTICAL_FUNCTION_ICON;
            }
            if (rawFunction2.isChangedInstructionsOnlyMatch()) {
                return MATCHED_INSTRUCTIONCHANGED_FUNCTION_ICON;
            }
            if (rawFunction2.isChangedStructuralMatch()) {
                return MATCHED_STRUCTURALCHANGED_FUNCTION_ICON;
            }
        } else if (eMatchState == EMatchState.PRIMARY_UNMATCHED) {
            return PRIMARY_UNMATCHED_FUNCTION_ICON;
        }
        return SECONDRAY_UNMATCHED_FUNCNTION_ICON;
    }

    public SingleDiffNode getLastSelectedGraphNode() {
        return this.lastSelectedTreeNode;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final ESide eSide = this.getRootNode().getSide();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Function Address"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)SingleFlowGraphBaseTreeNode.this.getView();
                ClipboardHelpers.copyToClipboard(flowGraphViewData.getAddress(eSide).toHexString());
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Copy Function Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)SingleFlowGraphBaseTreeNode.this.getView();
                ClipboardHelpers.copyToClipboard(flowGraphViewData.getFunctionName(eSide));
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        return jPopupMenu;
    }

    @Override
    public SingleFlowGraphRootTreeNode getRootNode() {
        return (SingleFlowGraphRootTreeNode)this.getAbstractRootNode();
    }

    @Override
    public String getTooltipText() {
        return null;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void setLastSelectedGraphNode(SingleDiffNode singleDiffNode) {
        this.lastSelectedTreeNode = singleDiffNode;
    }

    @Override
    public String toString() {
        FlowGraphViewData flowGraphViewData = this.getRootNode().getView();
        ESide eSide = this.getRootNode().getSide();
        RawFlowGraph rawFlowGraph = flowGraphViewData.getRawGraph(eSide);
        return String.format("%s (%d / %d)", rawFlowGraph.getName(), this.getChildCount(), this.basicBlockTreeNodes.size());
    }

    private class InternalMatchesChangeListener
    implements IMatchesChangeListener {
        private InternalMatchesChangeListener() {
        }

        private void updateTree(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            IAddress iAddress5 = SingleFlowGraphBaseTreeNode.this.getRootNode().getView().getAddress(ESide.PRIMARY);
            IAddress iAddress6 = SingleFlowGraphBaseTreeNode.this.getRootNode().getView().getAddress(ESide.SECONDARY);
            if (iAddress5.equals(iAddress) && iAddress6.equals(iAddress2)) {
                IAddress iAddress7 = iAddress3;
                if (SingleFlowGraphBaseTreeNode.this.getRootNode().getGraph().getSide() == ESide.SECONDARY) {
                    iAddress7 = iAddress4;
                }
                SingleFlowGraphBaseTreeNode.this.replaceBasicblockTreeNode(iAddress7);
            }
        }

        @Override
        public void addedBasicBlockMatch(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            this.updateTree(iAddress, iAddress2, iAddress3, iAddress4);
        }

        @Override
        public void removedBasicBlockMatch(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            this.updateTree(iAddress, iAddress2, iAddress3, iAddress4);
        }
    }
}

