/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.callgraph;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeMultiFilter;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.ISearchableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.TreeNodeSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ISortableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractBaseTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.callgraph.SingleCallGraphFunctionTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.callgraph.SingleCallGraphRootTreeNode;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SingleCallGraphBaseTreeNode
extends AbstractBaseTreeNode {
    private static final Icon CALLGRAPH_ICON = ImageUtils.getImageIcon("data/treeicons/callgraph.png");
    private List<SingleCallGraphFunctionTreeNode> functionNodes = new ArrayList<SingleCallGraphFunctionTreeNode>();
    private SingleDiffNode lastSelectedTreeNode;

    public SingleCallGraphBaseTreeNode(SingleCallGraphRootTreeNode singleCallGraphRootTreeNode) {
        super(singleCallGraphRootTreeNode);
        this.createChildren();
    }

    @Override
    protected void delete() {
        super.delete();
        this.functionNodes.clear();
        this.functionNodes = null;
        this.lastSelectedTreeNode = null;
    }

    @Override
    protected void updateTreeNodes(boolean bl2) {
        TreeNodeSearcher treeNodeSearcher = this.getSearcher();
        GraphNodeMultiFilter graphNodeMultiFilter = this.getFilter();
        ArrayList<SingleCallGraphFunctionTreeNode> arrayList = new ArrayList<SingleCallGraphFunctionTreeNode>();
        if (treeNodeSearcher.getUseTemporaryResults() && !"".equals(treeNodeSearcher.getSearchString())) {
            for (int i2 = 1; i2 < this.getChildCount(); ++i2) {
                arrayList.add((SingleCallGraphFunctionTreeNode)this.getChildAt(i2));
            }
        } else {
            arrayList.addAll(this.functionNodes);
        }
        this.removeAllChildren();
        List<Object> list = new ArrayList();
        if (bl2) {
            if (!"".equals(treeNodeSearcher.getSearchString())) {
                list = treeNodeSearcher.search(arrayList);
                arrayList.clear();
                for (ISearchableTreeNode iterator2 : list) {
                    arrayList.add((SingleCallGraphFunctionTreeNode)iterator2);
                }
            } else {
                treeNodeSearcher.search((List<? extends ISearchableTreeNode>)null);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (SingleCallGraphFunctionTreeNode singleCallGraphFunctionTreeNode : arrayList) {
            if (!graphNodeMultiFilter.filterRawFunction(singleCallGraphFunctionTreeNode.getFunction())) continue;
            if (!bl2 && !"".equals(treeNodeSearcher.getSearchString())) {
                if (!treeNodeSearcher.isSearchHit(singleCallGraphFunctionTreeNode.getSingleDiffNode())) continue;
                arrayList2.add(singleCallGraphFunctionTreeNode);
                continue;
            }
            arrayList2.add(singleCallGraphFunctionTreeNode);
        }
        for (Comparator<ISortableTreeNode> comparator : this.getRootNode().getSorter().getSingleFunctionTreeNodeComparatorList()) {
            Collections.sort(arrayList2, comparator);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            SingleCallGraphFunctionTreeNode singleCallGraphFunctionTreeNode = (SingleCallGraphFunctionTreeNode)iterator.next();
            this.add(singleCallGraphFunctionTreeNode);
        }
        this.getTree().getModel().nodeStructureChanged(this);
        this.getTree().updateUI();
    }

    @Override
    public void createChildren() {
        this.functionNodes.clear();
        for (SingleDiffNode singleDiffNode : this.getRootNode().getGraph().getNodes()) {
            this.functionNodes.add(new SingleCallGraphFunctionTreeNode(this.getRootNode(), singleDiffNode));
        }
        this.updateTreeNodes(false);
    }

    @Override
    public Icon getIcon() {
        return CALLGRAPH_ICON;
    }

    public SingleDiffNode getLastSelectedGraphNode() {
        return this.lastSelectedTreeNode;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final ESide eSide = this.getRootNode().getSide();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Image Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SingleCallGraphBaseTreeNode.this.getDiff().getMetadata().getImageName(eSide);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Copy Image Hash"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SingleCallGraphBaseTreeNode.this.getDiff().getMetadata().getImageName(eSide);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(new AbstractAction("Copy IDB Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SingleCallGraphBaseTreeNode.this.getDiff().getMetadata().getIdbName(eSide);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    @Override
    public SingleCallGraphRootTreeNode getRootNode() {
        return (SingleCallGraphRootTreeNode)this.getAbstractRootNode();
    }

    @Override
    public String getTooltipText() {
        return null;
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(this.getTree(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void setLastSelectedGraphNode(SingleDiffNode singleDiffNode) {
        this.lastSelectedTreeNode = singleDiffNode;
    }

    @Override
    public String toString() {
        return String.format("Call Graph (%d / %d)", this.getChildCount(), this.functionNodes.size());
    }
}

