/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.combined.flowgraph;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeMultiFilter;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.ISearchableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.TreeNodeSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ISortableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractBaseTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.combined.flowgraph.CombinedFlowGraphBasicBlockTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.combined.flowgraph.CombinedFlowGraphRootTreeNode;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.matches.IMatchesChangeListener;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;

public class CombinedFlowGraphBaseTreeNode
extends AbstractBaseTreeNode {
    private static final Icon MATCHED_IDENTICAL_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/matched-functions.png");
    private static final Icon MATCHED_INSTRUCTIONCHANGED_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/instructions-changed-function.png");
    private static final Icon MATCHED_STRUCTURALCHANGED_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/structural-changed-function.png");
    private static final Icon PRIMARY_UNMATCHED_FUNCTION_ICON = ImageUtils.getImageIcon("data/treeicons/primary-unmatched-functions.png");
    private static final Icon SECONDRAY_UNMATCHED_FUNCNTION_ICON = ImageUtils.getImageIcon("data/treeicons/primary-unmatched-functions.png");
    private final IMatchesChangeListener matchesChangeListener = new InternalMatchesChangeListener();
    private final List<CombinedFlowGraphBasicBlockTreeNode> basicblockTreeNodes = new ArrayList<CombinedFlowGraphBasicBlockTreeNode>();
    private CombinedDiffNode lastSelectedTreeNode;

    public CombinedFlowGraphBaseTreeNode(CombinedFlowGraphRootTreeNode combinedFlowGraphRootTreeNode) {
        super(combinedFlowGraphRootTreeNode);
        this.createChildren();
        this.getDiff().getMatches().addListener(this.matchesChangeListener);
    }

    @Override
    protected void delete() {
        this.getDiff().getMatches().removeListener(this.matchesChangeListener);
        super.delete();
    }

    @Override
    protected void updateTreeNodes(boolean bl2) {
        TreeNodeSearcher treeNodeSearcher = this.getSearcher();
        GraphNodeMultiFilter graphNodeMultiFilter = this.getFilter();
        ArrayList<CombinedFlowGraphBasicBlockTreeNode> arrayList = new ArrayList<CombinedFlowGraphBasicBlockTreeNode>();
        if (treeNodeSearcher.getUseTemporaryResults() && !"".equals(treeNodeSearcher.getSearchString())) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                arrayList.add((CombinedFlowGraphBasicBlockTreeNode)this.getChildAt(i2));
            }
        } else {
            arrayList.addAll(this.basicblockTreeNodes);
        }
        this.removeAllChildren();
        List<Object> list = new ArrayList();
        if (bl2) {
            if (!"".equals(treeNodeSearcher.getSearchString())) {
                list = treeNodeSearcher.search(arrayList);
                arrayList.clear();
                for (ISearchableTreeNode iterator2 : list) {
                    arrayList.add((CombinedFlowGraphBasicBlockTreeNode)iterator2);
                }
            } else {
                treeNodeSearcher.search((List<? extends ISearchableTreeNode>)null);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (CombinedFlowGraphBasicBlockTreeNode combinedFlowGraphBasicBlockTreeNode : arrayList) {
            if (!graphNodeMultiFilter.filterRawCombinedBasicblock(combinedFlowGraphBasicBlockTreeNode.getCombinedBasicblock())) continue;
            if (!bl2 && !"".equals(treeNodeSearcher.getSearchString())) {
                if (!treeNodeSearcher.isSearchHit(combinedFlowGraphBasicBlockTreeNode.getCombinedDiffNode())) continue;
                arrayList2.add(combinedFlowGraphBasicBlockTreeNode);
                continue;
            }
            arrayList2.add(combinedFlowGraphBasicBlockTreeNode);
        }
        for (Comparator<ISortableTreeNode> comparator : this.getRootNode().getSorter().getCombinedBasicBlockTreeNodeComparatorList()) {
            Collections.sort(arrayList2, comparator);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            CombinedFlowGraphBasicBlockTreeNode combinedFlowGraphBasicBlockTreeNode = (CombinedFlowGraphBasicBlockTreeNode)iterator.next();
            this.add(combinedFlowGraphBasicBlockTreeNode);
        }
        this.getTree().getModel().nodeStructureChanged(this);
        this.getTree().updateUI();
    }

    @Override
    public void createChildren() {
        CombinedFlowGraphRootTreeNode combinedFlowGraphRootTreeNode = this.getRootNode();
        this.basicblockTreeNodes.clear();
        for (CombinedDiffNode combinedDiffNode : combinedFlowGraphRootTreeNode.getGraph().getNodes()) {
            this.basicblockTreeNodes.add(new CombinedFlowGraphBasicBlockTreeNode(combinedFlowGraphRootTreeNode, combinedDiffNode));
        }
        this.updateTreeNodes(false);
    }

    @Override
    public Icon getIcon() {
        CombinedFlowGraphRootTreeNode combinedFlowGraphRootTreeNode = this.getRootNode();
        FlowGraphViewData flowGraphViewData = combinedFlowGraphRootTreeNode.getView();
        RawFlowGraph rawFlowGraph = flowGraphViewData.getRawGraph(ESide.PRIMARY);
        RawFlowGraph rawFlowGraph2 = flowGraphViewData.getRawGraph(ESide.SECONDARY);
        RawFunction rawFunction = GraphGetter.getFunction(this.getDiff(), rawFlowGraph);
        RawFunction rawFunction2 = GraphGetter.getFunction(this.getDiff(), rawFlowGraph2);
        if (rawFunction2 == null) {
            return PRIMARY_UNMATCHED_FUNCTION_ICON;
        }
        if (rawFunction == null) {
            return SECONDRAY_UNMATCHED_FUNCNTION_ICON;
        }
        if (rawFunction.isChangedInstructionsOnlyMatch()) {
            return MATCHED_INSTRUCTIONCHANGED_FUNCTION_ICON;
        }
        if (rawFunction.isChangedStructuralMatch()) {
            return MATCHED_STRUCTURALCHANGED_FUNCTION_ICON;
        }
        return MATCHED_IDENTICAL_FUNCTION_ICON;
    }

    public CombinedDiffNode getLastSelectedGraphNode() {
        return this.lastSelectedTreeNode;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Primary Function Address"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)CombinedFlowGraphBaseTreeNode.this.getView();
                ClipboardHelpers.copyToClipboard(flowGraphViewData.getAddress(ESide.PRIMARY).toHexString());
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Copy Primary Function Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)CombinedFlowGraphBaseTreeNode.this.getView();
                ClipboardHelpers.copyToClipboard(flowGraphViewData.getFunctionName(ESide.PRIMARY));
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(new AbstractAction("Copy Secondary Function Address"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)CombinedFlowGraphBaseTreeNode.this.getView();
                ClipboardHelpers.copyToClipboard(flowGraphViewData.getAddress(ESide.SECONDARY).toHexString());
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(new AbstractAction("Copy Secondary Function Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)CombinedFlowGraphBaseTreeNode.this.getView();
                ClipboardHelpers.copyToClipboard(flowGraphViewData.getFunctionName(ESide.SECONDARY));
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        return jPopupMenu;
    }

    @Override
    public CombinedFlowGraphRootTreeNode getRootNode() {
        return (CombinedFlowGraphRootTreeNode)this.getAbstractRootNode();
    }

    @Override
    public String getTooltipText() {
        return null;
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(this.getTree(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void setLastSelectedGraphNode(CombinedDiffNode combinedDiffNode) {
        this.lastSelectedTreeNode = combinedDiffNode;
    }

    @Override
    public String toString() {
        FlowGraphViewData flowGraphViewData = this.getRootNode().getView();
        RawFlowGraph rawFlowGraph = flowGraphViewData.getRawGraph(ESide.PRIMARY);
        RawFlowGraph rawFlowGraph2 = flowGraphViewData.getRawGraph(ESide.SECONDARY);
        String string = "missing";
        String string2 = "missing";
        if (rawFlowGraph != null) {
            string = rawFlowGraph.getName();
        }
        if (rawFlowGraph2 != null) {
            string2 = rawFlowGraph2.getName();
        }
        return String.format("%s \u2194 %s (%d / %d)", string, string2, this.getChildCount(), this.basicblockTreeNodes.size());
    }

    private class InternalMatchesChangeListener
    implements IMatchesChangeListener {
        private InternalMatchesChangeListener() {
        }

        private boolean isAffected(IAddress iAddress, IAddress iAddress2) {
            IAddress iAddress3 = CombinedFlowGraphBaseTreeNode.this.getRootNode().getView().getAddress(ESide.PRIMARY);
            IAddress iAddress4 = CombinedFlowGraphBaseTreeNode.this.getRootNode().getView().getAddress(ESide.SECONDARY);
            return iAddress.equals(iAddress3) && iAddress2.equals(iAddress4);
        }

        @Override
        public void addedBasicBlockMatch(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            if (this.isAffected(iAddress, iAddress2)) {
                Object object;
                Object object2;
                CombinedDiffNode combinedDiffNode = null;
                for (CombinedDiffNode combinedDiffNode2 : CombinedFlowGraphBaseTreeNode.this.getRootNode().getGraph().getNodes()) {
                    object2 = combinedDiffNode2.getPrimaryRawNode() == null ? null : combinedDiffNode2.getPrimaryRawNode().getAddress();
                    Object object3 = object = combinedDiffNode2.getSecondaryRawNode() == null ? null : combinedDiffNode2.getSecondaryRawNode().getAddress();
                    if (!iAddress3.equals(object2) || !iAddress4.equals(object)) continue;
                    combinedDiffNode = combinedDiffNode2;
                    break;
                }
                if (combinedDiffNode != null) {
                    boolean bl2 = false;
                    for (int i2 = 1; i2 < CombinedFlowGraphBaseTreeNode.this.getChildCount(); ++i2) {
                        object2 = (CombinedFlowGraphBasicBlockTreeNode)CombinedFlowGraphBaseTreeNode.this.getChildAt(i2);
                        object = ((CombinedFlowGraphBasicBlockTreeNode)object2).getCombinedBasicblock();
                        if (iAddress3.equals(((RawCombinedBasicBlock)object).getAddress(ESide.PRIMARY))) {
                            CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.remove(object2);
                            CombinedFlowGraphBaseTreeNode.this.remove((MutableTreeNode)object2);
                            if (bl2) {
                                CombinedFlowGraphBasicBlockTreeNode combinedFlowGraphBasicBlockTreeNode = new CombinedFlowGraphBasicBlockTreeNode(CombinedFlowGraphBaseTreeNode.this.getRootNode(), combinedDiffNode);
                                CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.add(combinedFlowGraphBasicBlockTreeNode);
                                CombinedFlowGraphBaseTreeNode.this.add(combinedFlowGraphBasicBlockTreeNode);
                                break;
                            }
                            bl2 = true;
                            continue;
                        }
                        if (!iAddress4.equals(((RawCombinedBasicBlock)object).getAddress(ESide.SECONDARY))) continue;
                        CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.remove(object2);
                        CombinedFlowGraphBaseTreeNode.this.remove((MutableTreeNode)object2);
                        if (bl2) {
                            CombinedFlowGraphBasicBlockTreeNode combinedFlowGraphBasicBlockTreeNode = new CombinedFlowGraphBasicBlockTreeNode(CombinedFlowGraphBaseTreeNode.this.getRootNode(), combinedDiffNode);
                            CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.add(combinedFlowGraphBasicBlockTreeNode);
                            CombinedFlowGraphBaseTreeNode.this.add(combinedFlowGraphBasicBlockTreeNode);
                            break;
                        }
                        bl2 = true;
                    }
                    CombinedFlowGraphBaseTreeNode.this.updateTreeNodes(true);
                }
            }
        }

        @Override
        public void removedBasicBlockMatch(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            if (this.isAffected(iAddress, iAddress2)) {
                Object object;
                Object object2;
                Object object3 = null;
                Object object4 = null;
                for (Object object5 : CombinedFlowGraphBaseTreeNode.this.getRootNode().getGraph().getNodes()) {
                    object2 = ((CombinedDiffNode)object5).getPrimaryRawNode() == null ? null : ((CombinedDiffNode)object5).getPrimaryRawNode().getAddress();
                    Object object6 = object = ((CombinedDiffNode)object5).getSecondaryRawNode() == null ? null : ((CombinedDiffNode)object5).getSecondaryRawNode().getAddress();
                    if (iAddress3.equals(object2) && object == null && (object3 = object5) != null && object4 != null) break;
                    if (!iAddress4.equals(object) || object2 != null) continue;
                    object4 = object5;
                    if (object3 == null || object4 == null) continue;
                    break;
                }
                if (object3 != null && object4 != null) {
                    for (int i2 = 0; i2 < CombinedFlowGraphBaseTreeNode.this.getChildCount(); ++i2) {
                        Object object5;
                        object5 = (CombinedFlowGraphBasicBlockTreeNode)CombinedFlowGraphBaseTreeNode.this.getChildAt(i2);
                        object2 = ((CombinedFlowGraphBasicBlockTreeNode)object5).getCombinedBasicblock();
                        if (!iAddress3.equals(((RawCombinedBasicBlock)object2).getAddress(ESide.PRIMARY)) || !iAddress4.equals(((RawCombinedBasicBlock)object2).getAddress(ESide.SECONDARY))) continue;
                        object = new CombinedFlowGraphBasicBlockTreeNode(CombinedFlowGraphBaseTreeNode.this.getRootNode(), (CombinedDiffNode)object3);
                        CombinedFlowGraphBasicBlockTreeNode combinedFlowGraphBasicBlockTreeNode = new CombinedFlowGraphBasicBlockTreeNode(CombinedFlowGraphBaseTreeNode.this.getRootNode(), (CombinedDiffNode)object4);
                        CombinedFlowGraphBaseTreeNode.this.insert((MutableTreeNode)object, i2);
                        int n2 = CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.indexOf(object5);
                        CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.set(n2, object);
                        CombinedFlowGraphBaseTreeNode.this.basicblockTreeNodes.add(combinedFlowGraphBasicBlockTreeNode);
                        break;
                    }
                    CombinedFlowGraphBaseTreeNode.this.updateTreeNodes(true);
                }
            }
        }
    }
}

