/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.combined.callgraph;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeMultiFilter;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.ISearchableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.TreeNodeSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ISortableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractBaseTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.combined.callgraph.CombinedCallGraphFunctionTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.combined.callgraph.CombinedCallGraphRootTreeNode;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class CombinedCallGraphBaseTreeNode
extends AbstractBaseTreeNode {
    private static final Icon CALLGRAPH_ICON = ImageUtils.getImageIcon("data/treeicons/callgraph.png");
    private List<CombinedCallGraphFunctionTreeNode> functionNodes = new ArrayList<CombinedCallGraphFunctionTreeNode>();
    private CombinedDiffNode lastSelectedTreeNode;

    public CombinedCallGraphBaseTreeNode(CombinedCallGraphRootTreeNode combinedCallGraphRootTreeNode) {
        super(combinedCallGraphRootTreeNode);
        this.createChildren();
    }

    @Override
    protected void delete() {
        super.delete();
        this.functionNodes.clear();
        this.functionNodes = null;
        this.lastSelectedTreeNode = null;
    }

    @Override
    protected void updateTreeNodes(boolean bl2) {
        TreeNodeSearcher treeNodeSearcher = this.getSearcher();
        GraphNodeMultiFilter graphNodeMultiFilter = this.getFilter();
        ArrayList<CombinedCallGraphFunctionTreeNode> arrayList = new ArrayList<CombinedCallGraphFunctionTreeNode>();
        if (treeNodeSearcher.getUseTemporaryResults() && !"".equals(treeNodeSearcher.getSearchString())) {
            for (int i2 = 1; i2 < this.getChildCount(); ++i2) {
                arrayList.add((CombinedCallGraphFunctionTreeNode)this.getChildAt(i2));
            }
        } else {
            arrayList.addAll(this.functionNodes);
        }
        this.removeAllChildren();
        List<Object> list = new ArrayList();
        if (bl2) {
            if (!"".equals(treeNodeSearcher.getSearchString())) {
                list = treeNodeSearcher.search(arrayList);
                arrayList.clear();
                for (ISearchableTreeNode iterator2 : list) {
                    arrayList.add((CombinedCallGraphFunctionTreeNode)iterator2);
                }
            } else {
                treeNodeSearcher.search((List<? extends ISearchableTreeNode>)null);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (CombinedCallGraphFunctionTreeNode combinedCallGraphFunctionTreeNode : arrayList) {
            if (!graphNodeMultiFilter.filterRawCombinedFunction(combinedCallGraphFunctionTreeNode.getCombinedFunction())) continue;
            if (!bl2 && !"".equals(treeNodeSearcher.getSearchString())) {
                if (!treeNodeSearcher.isSearchHit(combinedCallGraphFunctionTreeNode.getCombinedDiffNode())) continue;
                arrayList2.add(combinedCallGraphFunctionTreeNode);
                continue;
            }
            arrayList2.add(combinedCallGraphFunctionTreeNode);
        }
        for (Comparator<ISortableTreeNode> comparator : this.getRootNode().getSorter().getCombinedFunctionTreeNodeComparatorList()) {
            Collections.sort(arrayList2, comparator);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            CombinedCallGraphFunctionTreeNode combinedCallGraphFunctionTreeNode = (CombinedCallGraphFunctionTreeNode)iterator.next();
            this.add(combinedCallGraphFunctionTreeNode);
        }
        this.getTree().getModel().nodeStructureChanged(this);
        this.getTree().updateUI();
    }

    @Override
    public void createChildren() {
        this.functionNodes.clear();
        for (CombinedDiffNode combinedDiffNode : this.getRootNode().getGraph().getNodes()) {
            this.functionNodes.add(new CombinedCallGraphFunctionTreeNode(this.getRootNode(), combinedDiffNode));
        }
        this.updateTreeNodes(false);
    }

    @Override
    public Icon getIcon() {
        return CALLGRAPH_ICON;
    }

    public CombinedDiffNode getLastSelectedGraphNode() {
        return this.lastSelectedTreeNode;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Primary Image Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CombinedCallGraphBaseTreeNode.this.getDiff().getMetadata().getImageName(ESide.PRIMARY);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Copy Secondary Image Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CombinedCallGraphBaseTreeNode.this.getDiff().getMetadata().getImageName(ESide.SECONDARY);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(new AbstractAction("Copy Primary Image Hash"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CombinedCallGraphBaseTreeNode.this.getDiff().getMetadata().getImageHash(ESide.PRIMARY);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(new AbstractAction("Copy Secondary Image Hash"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CombinedCallGraphBaseTreeNode.this.getDiff().getMetadata().getImageHash(ESide.SECONDARY);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem(new AbstractAction("Copy Primary IDB Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CombinedCallGraphBaseTreeNode.this.getDiff().getMetadata().getIdbName(ESide.PRIMARY);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        JMenuItem jMenuItem6 = new JMenuItem(new AbstractAction("Copy Secondary IDB Name"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CombinedCallGraphBaseTreeNode.this.getDiff().getMetadata().getIdbName(ESide.SECONDARY);
                ClipboardHelpers.copyToClipboard(string);
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.add(jMenuItem6);
        return jPopupMenu;
    }

    @Override
    public CombinedCallGraphRootTreeNode getRootNode() {
        return (CombinedCallGraphRootTreeNode)this.getAbstractRootNode();
    }

    public void setLastSelectedGraphNode(CombinedDiffNode combinedDiffNode) {
        this.lastSelectedTreeNode = combinedDiffNode;
    }

    @Override
    public String toString() {
        return String.format("Combined Call Graph (%d / %d)", this.getChildCount(), this.functionNodes.size());
    }
}

