/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes;

import com.google.security.zynamics.bindiff.enums.ESortByCriterion;
import com.google.security.zynamics.bindiff.enums.ESortOrder;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeMultiFilter;
import com.google.security.zynamics.bindiff.graph.filter.IGraphNodeMultiFilterListener;
import com.google.security.zynamics.bindiff.graph.filter.enums.EVisibilityFilter;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.ITreeNodeSearcherListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.TreeNodeSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ITreeNodeSorterListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.TreeNodeMultiSorter;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractRootTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphVisibilityListener;
import java.util.Iterator;

public abstract class AbstractBaseTreeNode
extends AbstractTreeNode {
    private InternalTreeNodeSearcherListener searchListener = new InternalTreeNodeSearcherListener();
    private InternalGraphFilterListener filterListener = new InternalGraphFilterListener();
    private InternalTreeNodeSorterListener sorterListener = new InternalTreeNodeSorterListener();
    private InternalGraphVisibilityListener visibilityListener = new InternalGraphVisibilityListener();

    public AbstractBaseTreeNode(AbstractRootTreeNode abstractRootTreeNode) {
        super(abstractRootTreeNode);
        this.getSearcher().addListener(this.searchListener);
        this.getFilter().addListener(this.filterListener);
        this.getSorter().addListener(this.sorterListener);
        this.getGraph().getCombinedGraph().getIntermediateListeners().addIntermediateListener(this.visibilityListener);
    }

    @Override
    protected void delete() {
        this.getSearcher().removeListener(this.searchListener);
        this.getFilter().removeListener(this.filterListener);
        this.getSorter().removeListener(this.sorterListener);
        this.getGraph().getCombinedGraph().getIntermediateListeners().removeIntermediateListener(this.visibilityListener);
        this.filterListener = null;
        this.searchListener = null;
        this.sorterListener = null;
        this.visibilityListener = null;
        super.delete();
    }

    protected abstract void updateTreeNodes(boolean var1);

    private class InternalTreeNodeSorterListener
    implements ITreeNodeSorterListener {
        private InternalTreeNodeSorterListener() {
        }

        @Override
        public void sortingChanged(TreeNodeMultiSorter treeNodeMultiSorter) {
            AbstractBaseTreeNode.this.updateTreeNodes(false);
        }
    }

    private class InternalTreeNodeSearcherListener
    implements ITreeNodeSearcherListener {
        private InternalTreeNodeSearcherListener() {
        }

        @Override
        public void searchStringChanged(TreeNodeSearcher treeNodeSearcher) {
            AbstractBaseTreeNode.this.updateTreeNodes(true);
        }
    }

    private class InternalGraphVisibilityListener
    implements IZyGraphVisibilityListener {
        private InternalGraphVisibilityListener() {
        }

        private void handleNotificationAndUpdateTreeNodes() {
            boolean bl2;
            boolean bl3 = bl2 = AbstractBaseTreeNode.this.getFilter().getVisibilityFilterValue() != EVisibilityFilter.NONE;
            if (!bl2) {
                Pair<ESortByCriterion, ESortOrder> pair;
                Iterator<Pair<ESortByCriterion, ESortOrder>> iterator = AbstractBaseTreeNode.this.getSorter().iterator();
                while (iterator.hasNext() && !(bl2 = (pair = iterator.next()).first() == ESortByCriterion.VISIBILITY)) {
                }
            }
            if (bl2) {
                AbstractBaseTreeNode.this.updateTreeNodes(false);
            }
        }

        @Override
        public void nodeDeleted() {
            this.handleNotificationAndUpdateTreeNodes();
        }

        @Override
        public void visibilityChanged() {
            this.handleNotificationAndUpdateTreeNodes();
        }
    }

    private class InternalGraphFilterListener
    implements IGraphNodeMultiFilterListener {
        private InternalGraphFilterListener() {
        }

        @Override
        public void filterChanged(GraphNodeMultiFilter graphNodeMultiFilter) {
            AbstractBaseTreeNode.this.updateTreeNodes(false);
        }
    }
}

