/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.ESortByCriterion;
import com.google.security.zynamics.bindiff.enums.ESortOrder;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.BasicBlockTreeNodeMatchStateComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.CombinedTreeNodeAdressComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.CombinedTreeNodeSideComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.FunctionTreeNodeMatchStateComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.FunctionTreeNodeNameComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.FunctionTreeNodeTypeComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.SingleTreeNodeAdressComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.TreeNodeSelectionComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.comparators.TreeNodeVisibilityComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ISortableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ITreeNodeSorterListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class TreeNodeMultiSorter
implements Iterable<Pair<ESortByCriterion, ESortOrder>> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    public static final int MAX_DEPTH = 5;
    private final ListenerProvider<ITreeNodeSorterListener> listeners = new ListenerProvider();
    private final List<Pair<ESortByCriterion, ESortOrder>> criteria = new ArrayList<Pair<ESortByCriterion, ESortOrder>>();

    public TreeNodeMultiSorter() {
        this.criteria.add(new Pair<ESortByCriterion, ESortOrder>(ESortByCriterion.NONE, ESortOrder.ASCENDING));
        this.criteria.add(new Pair<ESortByCriterion, ESortOrder>(ESortByCriterion.NONE, ESortOrder.ASCENDING));
        this.criteria.add(new Pair<ESortByCriterion, ESortOrder>(ESortByCriterion.NONE, ESortOrder.ASCENDING));
        this.criteria.add(new Pair<ESortByCriterion, ESortOrder>(ESortByCriterion.NONE, ESortOrder.ASCENDING));
        this.criteria.add(new Pair<ESortByCriterion, ESortOrder>(ESortByCriterion.NONE, ESortOrder.ASCENDING));
        this.criteria.add(new Pair<ESortByCriterion, ESortOrder>(ESortByCriterion.NONE, ESortOrder.ASCENDING));
    }

    public void addListener(ITreeNodeSorterListener iTreeNodeSorterListener) {
        this.listeners.addListener(iTreeNodeSorterListener);
    }

    public List<Comparator<ISortableTreeNode>> getCombinedBasicBlockTreeNodeComparatorList() {
        ArrayList<Comparator<ISortableTreeNode>> arrayList = new ArrayList<Comparator<ISortableTreeNode>>();
        for (Pair<ESortByCriterion, ESortOrder> pair : this.criteria) {
            switch (pair.first()) {
                case ADDRESS: {
                    arrayList.add(new CombinedTreeNodeAdressComparator(pair.second()));
                    break;
                }
                case MATCH_STATE: {
                    arrayList.add(new BasicBlockTreeNodeMatchStateComparator(pair.second()));
                    break;
                }
                case VISIBILITY: {
                    arrayList.add(new TreeNodeVisibilityComparator(pair.second()));
                    break;
                }
                case SELECTION: {
                    arrayList.add(new TreeNodeSelectionComparator(pair.second()));
                    break;
                }
                case SIDE: {
                    arrayList.add(new CombinedTreeNodeSideComparator(pair.second()));
                    break;
                }
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public List<Comparator<ISortableTreeNode>> getCombinedFunctionTreeNodeComparatorList() {
        ArrayList<Comparator<ISortableTreeNode>> arrayList = new ArrayList<Comparator<ISortableTreeNode>>();
        for (Pair<ESortByCriterion, ESortOrder> pair : this.criteria) {
            switch (pair.first()) {
                case ADDRESS: {
                    arrayList.add(new CombinedTreeNodeAdressComparator(pair.second()));
                    break;
                }
                case MATCH_STATE: {
                    arrayList.add(new FunctionTreeNodeMatchStateComparator(pair.second()));
                    break;
                }
                case VISIBILITY: {
                    arrayList.add(new TreeNodeVisibilityComparator(pair.second()));
                    break;
                }
                case SELECTION: {
                    arrayList.add(new TreeNodeSelectionComparator(pair.second()));
                    break;
                }
                case SIDE: {
                    arrayList.add(new CombinedTreeNodeSideComparator(pair.second()));
                    break;
                }
                case FUNCTION_TYPE: {
                    arrayList.add(new FunctionTreeNodeTypeComparator(pair.second()));
                    break;
                }
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public List<Comparator<ISortableTreeNode>> getSingleBasicBlockTreeNodeComparatorList() {
        ArrayList<Comparator<ISortableTreeNode>> arrayList = new ArrayList<Comparator<ISortableTreeNode>>();
        for (Pair<ESortByCriterion, ESortOrder> pair : this.criteria) {
            switch (pair.first()) {
                case ADDRESS: {
                    arrayList.add(new SingleTreeNodeAdressComparator(pair.second()));
                    break;
                }
                case MATCH_STATE: {
                    arrayList.add(new BasicBlockTreeNodeMatchStateComparator(pair.second()));
                    break;
                }
                case VISIBILITY: {
                    arrayList.add(new TreeNodeVisibilityComparator(pair.second()));
                    break;
                }
                case SELECTION: {
                    arrayList.add(new TreeNodeSelectionComparator(pair.second()));
                    break;
                }
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public List<Comparator<ISortableTreeNode>> getSingleFunctionTreeNodeComparatorList() {
        ArrayList<Comparator<ISortableTreeNode>> arrayList = new ArrayList<Comparator<ISortableTreeNode>>();
        for (Pair<ESortByCriterion, ESortOrder> pair : this.criteria) {
            switch (pair.first()) {
                case ADDRESS: {
                    arrayList.add(new CombinedTreeNodeAdressComparator(pair.second()));
                    break;
                }
                case MATCH_STATE: {
                    arrayList.add(new FunctionTreeNodeMatchStateComparator(pair.second()));
                    break;
                }
                case VISIBILITY: {
                    arrayList.add(new TreeNodeVisibilityComparator(pair.second()));
                    break;
                }
                case SELECTION: {
                    arrayList.add(new TreeNodeSelectionComparator(pair.second()));
                    break;
                }
                case FUNCTION_TYPE: {
                    arrayList.add(new FunctionTreeNodeTypeComparator(pair.second()));
                    break;
                }
                case FUNCTION_NAME: {
                    arrayList.add(new FunctionTreeNodeNameComparator(pair.second()));
                    break;
                }
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    @Override
    public Iterator<Pair<ESortByCriterion, ESortOrder>> iterator() {
        return this.criteria.iterator();
    }

    public void notifyListeners() {
        for (ITreeNodeSorterListener iTreeNodeSorterListener : this.listeners) {
            iTreeNodeSorterListener.sortingChanged(this);
        }
    }

    public void removeListener(ITreeNodeSorterListener iTreeNodeSorterListener) {
        this.listeners.removeListener(iTreeNodeSorterListener);
    }

    public void setCriterion(ESortByCriterion eSortByCriterion, ESortOrder eSortOrder, int n2, boolean bl2) {
        if (n2 < 0 || n2 > 5) {
            logger.at(Level.SEVERE).log("Criterion depth is out of range");
            return;
        }
        if (this.criteria.get(n2).first() != eSortByCriterion || this.criteria.get(n2).second() != eSortOrder) {
            this.criteria.remove(n2);
            this.criteria.add(n2, new Pair<ESortByCriterion, ESortOrder>(eSortByCriterion, eSortOrder));
            if (bl2) {
                this.notifyListeners();
            }
        }
    }
}

