/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.enums.EGraphLayout;
import com.google.security.zynamics.bindiff.enums.EGraphSynchronization;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.builders.ViewCallGraphBuilder;
import com.google.security.zynamics.bindiff.graph.builders.ViewFlowGraphBuilder;
import com.google.security.zynamics.bindiff.graph.edges.SingleViewEdge;
import com.google.security.zynamics.bindiff.graph.eventhandlers.GraphLayoutEventHandler;
import com.google.security.zynamics.bindiff.graph.helpers.BasicBlockMatchAdder;
import com.google.security.zynamics.bindiff.graph.helpers.BasicBlockMatchRemover;
import com.google.security.zynamics.bindiff.graph.helpers.GraphColorizer;
import com.google.security.zynamics.bindiff.graph.helpers.GraphSelector;
import com.google.security.zynamics.bindiff.graph.helpers.GraphViewFitter;
import com.google.security.zynamics.bindiff.graph.helpers.GraphZoomer;
import com.google.security.zynamics.bindiff.graph.listeners.GraphViewsListenerManager;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.dialogs.ExportViewDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.ProgressDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.SaveFunctionDiffViewDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.CriteriaDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.CriteriaFactory;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionExecutor;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.GraphSettingsDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.printing.PrintGraphPreviewDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ISavableListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.subpanels.GraphPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.subpanels.ViewToolbarPanel;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.io.CommentsWriter;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.FunctionDiffViewSaver;
import com.google.security.zynamics.bindiff.project.diff.IDiffListener;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CColorChooser;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.CDefaultLabelEventHandler;
import com.google.security.zynamics.zylib.gui.zygraph.ILabelEditableContentListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.GraphExporters;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ViewTabPanelFunctions
extends TabPanelFunctions {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ListenerProvider<ISavableListener> listenerProvider = new ListenerProvider();
    private final InternalEditableContentListener labelEditModeListener = new InternalEditableContentListener();
    private final GraphsContainer graphs;
    private final GraphSettings settings;
    private final GraphViewsListenerManager graphListenerManager;
    private ViewTabPanel viewTabPanel;
    private Color currentColor = null;
    private CriteriaDialog selectByCriteriaDlg = null;
    private GraphSettingsDialog settingsDialog = null;
    private boolean hasChangedMatches = false;
    private boolean hasChangedComments = false;

    public ViewTabPanelFunctions(MainWindow mainWindow, Workspace workspace, ViewTabPanel viewTabPanel, ViewData viewData) {
        super(mainWindow, workspace);
        this.viewTabPanel = Preconditions.checkNotNull(viewTabPanel);
        Preconditions.checkNotNull(viewData);
        this.graphs = viewData.getGraphs();
        this.settings = this.graphs.getSettings();
        this.graphListenerManager = new GraphViewsListenerManager(this.graphs, this);
        this.graphs.getCombinedGraph().getEditMode().getLabelEventHandler().addEditModeListener(this.labelEditModeListener);
        this.graphs.getPrimaryGraph().getEditMode().getLabelEventHandler().addEditModeListener(this.labelEditModeListener);
        this.graphs.getSecondaryGraph().getEditMode().getLabelEventHandler().addEditModeListener(this.labelEditModeListener);
    }

    public static boolean isNodeSelectionMatchAddable(BinDiffGraph<?, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        return BasicBlockMatchAdder.getAffectedCombinedNodes(binDiffGraph, zyGraphNode) != null;
    }

    public static boolean isNodeSelectionMatchDeletable(BinDiffGraph<?, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        return BasicBlockMatchRemover.getAffectedCombinedNodes(binDiffGraph, zyGraphNode) != null;
    }

    private void notifySavableListener() {
        for (ISavableListener iSavableListener : this.listenerProvider) {
            iSavableListener.isSavable(this.hasChanged());
        }
    }

    private void setCommentsChanged(boolean bl2) {
        this.hasChangedComments = bl2;
        this.notifySavableListener();
    }

    private void setMatchesChanged(boolean bl2) {
        this.hasChangedMatches = bl2;
        this.notifySavableListener();
    }

    private boolean showColorChooserDialog() {
        List<Color> list = GraphColorizer.getRecentColors();
        this.currentColor = CColorChooser.showDialog((Component)this.viewTabPanel, "Color Nodes", Color.WHITE, list.toArray(new Color[0]));
        if (this.currentColor != null) {
            list.add(this.currentColor);
            GraphColorizer.setRecentColors(list);
            return true;
        }
        return false;
    }

    private void updateFunctionMatchCounts() {
        ViewData viewData = this.viewTabPanel.getView();
        if (viewData.isFlowGraphView() || viewData.isSingleFunctionDiffView()) {
            Diff diff = viewData.getGraphs().getDiff();
            IAddress iAddress = viewData.getAddress(ESide.PRIMARY);
            FunctionMatchData functionMatchData = diff.getMatches().getFunctionMatch(iAddress, ESide.PRIMARY);
            RawFlowGraph rawFlowGraph = (RawFlowGraph)viewData.getRawGraph(ESide.PRIMARY);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (RawBasicBlock rawBasicBlock : rawFlowGraph.getNodes()) {
                SingleViewEdge<? extends SingleViewNode> singleViewEdge2;
                if (rawBasicBlock.getMatchState() != EMatchState.MATCHED) continue;
                ++n2;
                for (SingleViewEdge<? extends SingleViewNode> singleViewEdge2 : rawBasicBlock.getOutgoingEdges()) {
                    RawJump rawJump = (RawJump)singleViewEdge2;
                    if (rawJump.getSource().getMatchState() != EMatchState.MATCHED || rawJump.getTarget().getMatchState() != EMatchState.MATCHED) continue;
                    ++n3;
                }
                IAddress iAddress2 = rawBasicBlock.getAddress();
                singleViewEdge2 = functionMatchData.getBasicBlockMatch(iAddress2, ESide.PRIMARY);
                n4 += ((BasicBlockMatchData)((Object)singleViewEdge2)).getSizeOfMatchedInstructions();
            }
            functionMatchData.setSizeOfMatchedBasicblocks(n2);
            functionMatchData.setSizeOfMatchedJumps(n3);
            functionMatchData.setSizeOfMatchedInstructions(n4);
        }
    }

    public void addListener(ISavableListener iSavableListener) {
        this.listenerProvider.addListener(iSavableListener);
    }

    public void addNodeMatch(CombinedDiffNode combinedDiffNode, CombinedDiffNode combinedDiffNode2) {
        if (combinedDiffNode == null || combinedDiffNode2 == null) {
            return;
        }
        if (this.viewTabPanel.getView().isFlowGraphView()) {
            try {
                BasicBlockMatchAdder.addBasicblockMatch(this.graphs, combinedDiffNode, combinedDiffNode2);
                this.setMatchesChanged(true);
            }
            catch (GraphLayoutException graphLayoutException) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
                CMessageBox.showError(this.viewTabPanel, graphLayoutException.getMessage());
            }
        }
    }

    public boolean closeView(boolean bl2) {
        ViewData viewData = this.viewTabPanel.getView();
        if (bl2 && this.hasChanged() && !this.saveView()) {
            return false;
        }
        Diff diff = this.viewTabPanel.getDiff();
        diff.getViewManager().removeView(viewData);
        this.getMainWindow().getController().getTabPanelManager().removeTab(this.viewTabPanel);
        this.viewTabPanel.dispose();
        this.dispose();
        this.graphs.dispose();
        this.viewTabPanel = null;
        if (viewData.isCallGraphView()) {
            diff.getCallGraph(ESide.PRIMARY).resetVisibilityAndSelection();
            diff.getCallGraph(ESide.SECONDARY).resetVisibilityAndSelection();
        }
        for (IDiffListener iDiffListener : diff.getListener()) {
            iDiffListener.closedView(diff);
        }
        return true;
    }

    public void colorInvisibleNodes() {
        if (this.showColorChooserDialog()) {
            Color color = this.currentColor;
            if (this.settings.isSync()) {
                GraphColorizer.colorizeInvisibleNodes(this.graphs.getCombinedGraph(), color);
                GraphColorizer.colorizeInvisibleNodes(this.graphs.getPrimaryGraph(), color);
                GraphColorizer.colorizeInvisibleNodes(this.graphs.getSecondaryGraph(), color);
            } else {
                switch (this.settings.getDiffViewMode()) {
                    case NORMAL_VIEW: {
                        if (this.settings.getFocus() == ESide.PRIMARY) {
                            GraphColorizer.colorizeInvisibleNodes(this.graphs.getPrimaryGraph(), color);
                            break;
                        }
                        GraphColorizer.colorizeInvisibleNodes(this.graphs.getSecondaryGraph(), color);
                        break;
                    }
                    case COMBINED_VIEW: {
                        GraphColorizer.colorizeInvisibleNodes(this.graphs.getCombinedGraph(), color);
                        break;
                    }
                }
            }
        }
    }

    public void colorSelectedNodes() {
        if (this.showColorChooserDialog()) {
            Color color = this.currentColor;
            if (this.settings.isSync()) {
                GraphColorizer.colorizeSelectedNodes(this.graphs.getCombinedGraph(), color);
                GraphColorizer.colorizeSelectedNodes(this.graphs.getPrimaryGraph(), color);
                GraphColorizer.colorizeSelectedNodes(this.graphs.getSecondaryGraph(), color);
            } else {
                switch (this.settings.getDiffViewMode()) {
                    case NORMAL_VIEW: {
                        if (this.settings.getFocus() == ESide.PRIMARY) {
                            GraphColorizer.colorizeSelectedNodes(this.graphs.getPrimaryGraph(), color);
                            break;
                        }
                        GraphColorizer.colorizeSelectedNodes(this.graphs.getSecondaryGraph(), color);
                        break;
                    }
                    case COMBINED_VIEW: {
                        GraphColorizer.colorizeSelectedNodes(this.graphs.getCombinedGraph(), color);
                        break;
                    }
                }
            }
        }
    }

    public void colorUnselectedNodes() {
        if (this.showColorChooserDialog()) {
            Color color = this.currentColor;
            if (this.settings.isSync()) {
                GraphColorizer.colorizeUnselectedNodes(this.graphs.getCombinedGraph(), color);
                GraphColorizer.colorizeUnselectedNodes(this.graphs.getPrimaryGraph(), color);
                GraphColorizer.colorizeUnselectedNodes(this.graphs.getSecondaryGraph(), color);
            } else {
                switch (this.settings.getDiffViewMode()) {
                    case NORMAL_VIEW: {
                        if (this.settings.getFocus() == ESide.PRIMARY) {
                            GraphColorizer.colorizeUnselectedNodes(this.graphs.getPrimaryGraph(), color);
                            break;
                        }
                        GraphColorizer.colorizeUnselectedNodes(this.graphs.getSecondaryGraph(), color);
                        break;
                    }
                    case COMBINED_VIEW: {
                        GraphColorizer.colorizeUnselectedNodes(this.graphs.getCombinedGraph(), color);
                        break;
                    }
                }
            }
        }
    }

    public void deselectLeafs() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.deselectLeafs(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.deselectLeafs(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.deselectLeafs(this.graphs.getCombinedGraph());
        }
    }

    public void deselectPeriphery() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.deselectPeriphery(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.deselectPeriphery(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.deselectPeriphery(this.graphs.getCombinedGraph());
        }
    }

    public void deselectRoots() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.deselectRoots(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.deselectRoots(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.deselectRoots(this.graphs.getCombinedGraph());
        }
    }

    public void dispose() {
        this.graphListenerManager.dispose();
        CDefaultLabelEventHandler cDefaultLabelEventHandler = this.graphs.getPrimaryGraph().getEditMode().getLabelEventHandler();
        CDefaultLabelEventHandler cDefaultLabelEventHandler2 = this.graphs.getSecondaryGraph().getEditMode().getLabelEventHandler();
        CDefaultLabelEventHandler cDefaultLabelEventHandler3 = this.graphs.getCombinedGraph().getEditMode().getLabelEventHandler();
        if (cDefaultLabelEventHandler3 != null) {
            cDefaultLabelEventHandler3.removeEditModeListener(this.labelEditModeListener);
        }
        if (cDefaultLabelEventHandler != null) {
            cDefaultLabelEventHandler.removeEditModeListener(this.labelEditModeListener);
        }
        if (cDefaultLabelEventHandler2 != null) {
            cDefaultLabelEventHandler2.removeEditModeListener(this.labelEditModeListener);
        }
        if (this.selectByCriteriaDlg != null) {
            this.selectByCriteriaDlg.dispose();
            this.selectByCriteriaDlg = null;
        }
    }

    public void doLayout(EGraphLayout eGraphLayout) {
        BinDiffGraph binDiffGraph = this.graphs.getCombinedGraph();
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            binDiffGraph = this.settings.getFocus() == ESide.PRIMARY ? this.graphs.getPrimaryGraph() : this.graphs.getSecondaryGraph();
        }
        if (binDiffGraph != null) {
            switch (eGraphLayout) {
                case CIRCULAR: {
                    binDiffGraph.getSettings().getLayoutSettings().setDefaultGraphLayout(EGraphLayout.CIRCULAR);
                    break;
                }
                case HIERARCHICAL: {
                    binDiffGraph.getSettings().getLayoutSettings().setDefaultGraphLayout(EGraphLayout.HIERARCHICAL);
                    break;
                }
                case ORTHOGONAL: {
                    binDiffGraph.getSettings().getLayoutSettings().setDefaultGraphLayout(EGraphLayout.ORTHOGONAL);
                }
            }
            this.graphListenerManager.suppressUpdating(true);
            GraphLayoutEventHandler.handleDoLayoutButtonEvent(binDiffGraph, true);
            this.graphListenerManager.suppressUpdating(false);
        }
    }

    public void exportViewAsImage() {
        MainWindow mainWindow = this.getMainWindow();
        ExportViewDialog exportViewDialog = new ExportViewDialog(mainWindow, "Export View as Image", "", new File(this.graphs.getDiff().getDiffFolder()), this.viewTabPanel.getView().getViewName().toString());
        exportViewDialog.setVisible(true);
        if (exportViewDialog.isOkPressed()) {
            try {
                if (exportViewDialog.isCapturePart()) {
                    if (exportViewDialog.isPNG()) {
                        GraphExporters.exportPartAsPNG(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                        GraphExporters.exportPartAsPNG(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                        GraphExporters.exportPartAsPNG(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                    } else if (exportViewDialog.isJPEG()) {
                        GraphExporters.exportPartAsJPEG(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                        GraphExporters.exportPartAsJPEG(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                        GraphExporters.exportPartAsJPEG(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                    } else if (exportViewDialog.isGIF()) {
                        GraphExporters.exportPartAsGIF(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                        GraphExporters.exportPartAsGIF(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                        GraphExporters.exportPartAsGIF(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                    } else if (exportViewDialog.isSVG()) {
                        GraphExporters.exportPartAsSVG(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                        GraphExporters.exportPartAsSVG(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                        GraphExporters.exportPartAsSVG(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                    }
                } else if (exportViewDialog.isPNG()) {
                    GraphExporters.exportAllAsPNG(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                    GraphExporters.exportAllAsPNG(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                    GraphExporters.exportAllAsPNG(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                } else if (exportViewDialog.isJPEG()) {
                    GraphExporters.exportAllAsJPEG(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                    GraphExporters.exportAllAsJPEG(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                    GraphExporters.exportAllAsJPEG(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                } else if (exportViewDialog.isGIF()) {
                    GraphExporters.exportAllAsGIF(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                    GraphExporters.exportAllAsGIF(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                    GraphExporters.exportAllAsGIF(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                } else if (exportViewDialog.isSVG()) {
                    GraphExporters.exportAllAsSVG(this.getGraphs().getPrimaryGraph(), exportViewDialog.getPrimaryImageFile().getPath());
                    GraphExporters.exportAllAsSVG(this.getGraphs().getSecondaryGraph(), exportViewDialog.getSecondaryImageFile().getPath());
                    GraphExporters.exportAllAsSVG(this.getGraphs().getCombinedGraph(), exportViewDialog.getCombinedImageFile().getPath());
                }
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Couldn't save exported view images");
                CMessageBox.showError(mainWindow, "Couldn't save exported view images.");
            }
        }
    }

    public void fitGraphContentToView() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
            GraphZoomer.fitContent(this.graphs.getCombinedGraph());
        } else if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            GraphZoomer.fitContent(this.graphs.getSuperGraph());
        }
    }

    public void fitGraphs() {
        Dimension dimension = this.viewTabPanel.getNormalViewPanel().getSize();
        long l2 = Math.round((double)dimension.width * (1.0 - GraphPanel.COMBINED_MAIN_DIVIDER_WIDTH - 0.06));
        long l3 = Math.round(dimension.getHeight());
        this.graphs.getCombinedGraph().getView().setSize((int)l2, (int)l3);
        GraphViewFitter.fitSingleViewToSuperViewContent(this.graphs.getSuperGraph());
        this.graphs.getCombinedGraph().getGraph().Bv();
        this.graphs.getCombinedGraph().getView().setZoom(this.graphs.getCombinedGraph().getView().getZoom() * 0.9);
        this.graphs.getCombinedGraph().getGraph().updateViews();
        this.graphs.getPrimaryGraph().getGraph().updateViews();
        this.graphs.getSecondaryGraph().getGraph().updateViews();
    }

    public JPanel getCurrentViewPanel() {
        switch (this.settings.getDiffViewMode()) {
            case NORMAL_VIEW: {
                return this.viewTabPanel.getNormalViewPanel();
            }
            case COMBINED_VIEW: {
                return this.viewTabPanel.getCombinedViewPanel();
            }
        }
        throw new IllegalStateException("Unknown view mode.");
    }

    public GraphViewsListenerManager getGraphListenerManager() {
        return this.graphListenerManager;
    }

    public GraphsContainer getGraphs() {
        return this.graphs;
    }

    public GraphSettings getGraphSettings() {
        return this.settings;
    }

    public TabPanelManager getTabPanelManager() {
        return this.viewTabPanel.getTabPanelManager();
    }

    public ViewTabPanel getViewTabPanel() {
        return this.viewTabPanel;
    }

    public boolean hasChanged() {
        return this.hasChangedMatches || this.hasChangedComments;
    }

    public void invertSelection() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.invertSelection(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.invertSelection(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.invertSelection(this.graphs.getCombinedGraph());
        }
    }

    public void openFlowgraphsViews(ZyGraphNode<?> zyGraphNode) {
        IAddress iAddress;
        IAddress iAddress2;
        WorkspaceTabPanel workspaceTabPanel = this.viewTabPanel.getTabPanelManager().getWorkspaceTabPanel();
        WorkspaceTabPanelFunctions workspaceTabPanelFunctions = workspaceTabPanel.getController();
        Diff diff = this.getGraphs().getDiff();
        if (zyGraphNode instanceof SingleDiffNode) {
            RawFunction rawFunction = (RawFunction)zyGraphNode.getRawNode();
            if (rawFunction.getSide() == ESide.PRIMARY) {
                RawFunction rawFunction2 = rawFunction.getMatchedFunction();
                iAddress2 = rawFunction.getAddress();
                iAddress = rawFunction2 == null ? null : rawFunction2.getAddress();
            } else {
                RawFunction rawFunction3 = rawFunction.getMatchedFunction();
                iAddress2 = rawFunction3 == null ? null : rawFunction3.getAddress();
                iAddress = rawFunction.getAddress();
            }
        } else if (zyGraphNode instanceof CombinedDiffNode) {
            RawCombinedFunction rawCombinedFunction = (RawCombinedFunction)zyGraphNode.getRawNode();
            iAddress2 = rawCombinedFunction.getAddress(ESide.PRIMARY);
            iAddress = rawCombinedFunction.getAddress(ESide.SECONDARY);
        } else {
            return;
        }
        workspaceTabPanelFunctions.openFlowGraphView(this.getMainWindow(), diff, iAddress2, iAddress);
    }

    public void printView(BinDiffGraph<?, ?> binDiffGraph) {
        new PrintGraphPreviewDialog(this.getMainWindow(), binDiffGraph.getView());
    }

    public void redoSelection() {
        this.graphs.getPrimaryGraph().getSelectionHistory().setEnabled(false);
        this.graphs.getSecondaryGraph().getSelectionHistory().setEnabled(false);
        this.graphs.getCombinedGraph().getSelectionHistory().setEnabled(false);
        this.graphs.getPrimaryGraph().getSelectionHistory().redo();
        this.graphs.getSecondaryGraph().getSelectionHistory().redo();
        this.graphs.getCombinedGraph().getSelectionHistory().redo();
        this.graphs.getPrimaryGraph().getSelectionHistory().setEnabled(true);
        this.graphs.getSecondaryGraph().getSelectionHistory().setEnabled(true);
        this.graphs.getCombinedGraph().getSelectionHistory().setEnabled(true);
    }

    public void removeListener(ISavableListener iSavableListener) {
        this.listenerProvider.removeListener(iSavableListener);
    }

    public void removeNodeMatch(List<CombinedDiffNode> list) {
        if (list == null) {
            return;
        }
        if (this.viewTabPanel.getView().isFlowGraphView()) {
            try {
                for (CombinedDiffNode combinedDiffNode : list) {
                    BasicBlockMatchRemover.removeBasicBlockMatch(this.graphs, combinedDiffNode);
                    this.setMatchesChanged(true);
                }
            }
            catch (GraphLayoutException graphLayoutException) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(graphLayoutException)).log(graphLayoutException.getMessage());
                CMessageBox.showError(this.viewTabPanel, graphLayoutException.getMessage());
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log(exception.getMessage());
                CMessageBox.showError(this.viewTabPanel, exception.getMessage());
            }
        }
    }

    public void resetDefaultPerspective() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            this.viewTabPanel.getNormalViewPanel().resetDefaultPerspective();
        } else if (this.settings.getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
            this.viewTabPanel.getCombinedViewPanel().resetDefaultPerspective();
        }
    }

    public boolean saveView() {
        Diff diff = this.graphs.getDiff();
        if (diff.isFunctionDiff()) {
            try {
                SaveFunctionDiffViewDialog saveFunctionDiffViewDialog = new SaveFunctionDiffViewDialog(this.getMainWindow(), "Save Function Diff View", this.getWorkspace(), diff);
                saveFunctionDiffViewDialog.setVisible(true);
                if (!saveFunctionDiffViewDialog.isOkPressed()) {
                    return false;
                }
                this.updateFunctionMatchCounts();
                FunctionDiffViewSaver functionDiffViewSaver = new FunctionDiffViewSaver(this, saveFunctionDiffViewDialog.getExportBinaryTargetFile(ESide.PRIMARY), saveFunctionDiffViewDialog.getExportBinaryTargetFile(ESide.SECONDARY), saveFunctionDiffViewDialog.getMatchesDatabaseTargetFile(), saveFunctionDiffViewDialog.isOverrideExportBinary(ESide.PRIMARY), saveFunctionDiffViewDialog.isOverrideExportBinary(ESide.SECONDARY));
                ProgressDialog.show((Window)this.getMainWindow(), "Saving View...", functionDiffViewSaver);
                TabPanelManager tabPanelManager = this.viewTabPanel.getTabPanelManager();
                tabPanelManager.updateSelectedTabTitel(saveFunctionDiffViewDialog.getFunctionDiffName());
                tabPanelManager.udpateSelectedTabIcon();
                this.getMainWindow().updateTitle(this.getWorkspace(), this.viewTabPanel);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Save function diff view failed");
                CMessageBox.showError(this.getMainWindow(), "Save function diff view failed.");
                return false;
            }
        } else {
            this.updateFunctionMatchCounts();
            this.writeComments();
            this.writeFlowgraphMatches();
        }
        this.setMatchesChanged(false);
        this.setCommentsChanged(false);
        return true;
    }

    public void selectAncestors() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.selectAncestorsOfSelection(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.selectAncestorsOfSelection(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.selectAncestorsOfSelection(this.graphs.getCombinedGraph());
        }
    }

    public void selectByCriteria() {
        Object object;
        if (this.selectByCriteriaDlg == null) {
            object = new CriteriaFactory(this.graphs);
            this.selectByCriteriaDlg = new CriteriaDialog(SwingUtilities.getWindowAncestor(this.viewTabPanel), (CriteriaFactory)object);
        }
        this.selectByCriteriaDlg.setVisible(true);
        this.selectByCriteriaDlg.setVisible(false);
        object = new HashSet();
        CriterionTree criterionTree = this.selectByCriteriaDlg.getCriterionTree();
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            if (this.settings.isSync()) {
                ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
                ArrayList<CombinedDiffNode> arrayList2 = new ArrayList<CombinedDiffNode>();
                ArrayList<SuperDiffNode> arrayList3 = new ArrayList<SuperDiffNode>();
                ArrayList<SuperDiffNode> arrayList4 = new ArrayList<SuperDiffNode>();
                ArrayList<SingleDiffNode> arrayList5 = new ArrayList<SingleDiffNode>();
                ArrayList<SingleDiffNode> arrayList6 = new ArrayList<SingleDiffNode>();
                ArrayList<SingleDiffNode> arrayList7 = new ArrayList<SingleDiffNode>();
                ArrayList<SingleDiffNode> arrayList8 = new ArrayList<SingleDiffNode>();
                if (this.selectByCriteriaDlg.doSelectNodes()) {
                    object.addAll(CriterionExecutor.execute(criterionTree, this.graphs.getPrimaryGraph()));
                    object.addAll(CriterionExecutor.execute(criterionTree, this.graphs.getSecondaryGraph()));
                    for (SuperDiffNode superDiffNode : this.graphs.getSuperGraph().getNodes()) {
                        boolean bl2;
                        SingleDiffNode singleDiffNode = superDiffNode.getPrimaryDiffNode();
                        SingleDiffNode singleDiffNode2 = superDiffNode.getSecondaryDiffNode();
                        CombinedDiffNode combinedDiffNode = superDiffNode.getCombinedDiffNode();
                        boolean bl3 = bl2 = singleDiffNode != null && object.contains(singleDiffNode) || singleDiffNode2 != null && object.contains(singleDiffNode2);
                        if (bl2) {
                            if (singleDiffNode != null) {
                                arrayList5.add(singleDiffNode);
                            }
                            if (singleDiffNode2 != null) {
                                arrayList7.add(singleDiffNode2);
                            }
                            arrayList.add(combinedDiffNode);
                            arrayList3.add(superDiffNode);
                            continue;
                        }
                        if (singleDiffNode != null) {
                            arrayList6.add(singleDiffNode);
                        }
                        if (singleDiffNode2 != null) {
                            arrayList8.add(singleDiffNode2);
                        }
                        arrayList2.add(combinedDiffNode);
                        arrayList4.add(superDiffNode);
                    }
                    boolean bl4 = this.settings.getLayoutSettings().getAutomaticLayouting();
                    this.settings.getLayoutSettings().setAutomaticLayouting(false);
                    this.graphs.getPrimaryGraph().selectNodes(arrayList5, arrayList6);
                    this.graphs.getSecondaryGraph().selectNodes(arrayList7, arrayList8);
                    this.graphs.getCombinedGraph().selectNodes(arrayList, arrayList2);
                    this.graphs.getSuperGraph().selectNodes(arrayList3, arrayList4);
                    this.settings.getLayoutSettings().setAutomaticLayouting(bl4);
                }
            } else if (this.settings.getFocus() == ESide.PRIMARY) {
                if (this.selectByCriteriaDlg.doSelectNodes()) {
                    object.addAll(CriterionExecutor.execute(criterionTree, this.graphs.getPrimaryGraph()));
                }
            } else if (this.selectByCriteriaDlg.doSelectNodes()) {
                object.addAll(CriterionExecutor.execute(criterionTree, this.graphs.getSecondaryGraph()));
            }
        } else if (this.settings.getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
            if (this.selectByCriteriaDlg.doSelectNodes()) {
                object.addAll(CriterionExecutor.execute(criterionTree, this.graphs.getCombinedGraph()));
            }
            ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
            ArrayList<CombinedDiffNode> arrayList9 = new ArrayList<CombinedDiffNode>();
            for (SuperDiffNode superDiffNode : this.graphs.getSuperGraph().getNodes()) {
                CombinedDiffNode combinedDiffNode = superDiffNode.getCombinedDiffNode();
                if (object.contains(combinedDiffNode)) {
                    arrayList.add(combinedDiffNode);
                    continue;
                }
                arrayList9.add(combinedDiffNode);
            }
            this.graphs.getCombinedGraph().selectNodes(arrayList, arrayList9);
        }
    }

    public void selectChildren() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.selectChildrenOfSelection(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.selectChildrenOfSelection(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.selectChildrenOfSelection(this.graphs.getCombinedGraph());
        }
    }

    public void selectNeighbours() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.selectNeighboursOfSelection(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.selectNeighboursOfSelection(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.selectNeighboursOfSelection(this.graphs.getCombinedGraph());
        }
    }

    public void selectParents() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.selectParentsOfSelection(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.selectParentsOfSelection(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.selectParentsOfSelection(this.graphs.getCombinedGraph());
        }
    }

    public void selectSuccessors() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW && !this.settings.isSync()) {
            if (this.settings.getFocus() == ESide.PRIMARY) {
                GraphSelector.selectSuccessorsOfSelection(this.graphs.getPrimaryGraph());
            } else {
                GraphSelector.selectSuccessorsOfSelection(this.graphs.getSecondaryGraph());
            }
        } else {
            GraphSelector.selectSuccessorsOfSelection(this.graphs.getCombinedGraph());
        }
    }

    public void setCaretIntoJumpToAddressField(ESide eSide) {
        this.viewTabPanel.getToolbar().setCaretIntoJumpToAddressField(eSide);
    }

    public void setCaretIntoSearchField() {
        this.viewTabPanel.getToolbar().setCaretIntoSearchField();
    }

    public void setDefaultNodeColors() {
        Diff diff = this.graphs.getDiff();
        CombinedGraph combinedGraph = this.graphs.getCombinedGraph();
        if (combinedGraph.getGraphType() == EGraphType.CALLGRAPH) {
            for (CombinedDiffNode combinedDiffNode : combinedGraph.getNodes()) {
                ViewCallGraphBuilder.colorizeFunctions((RawCombinedFunction)combinedDiffNode.getRawNode());
            }
        } else {
            for (CombinedDiffNode combinedDiffNode : combinedGraph.getNodes()) {
                RawCombinedBasicBlock rawCombinedBasicBlock = (RawCombinedBasicBlock)combinedDiffNode.getRawNode();
                IAddress iAddress = rawCombinedBasicBlock.getPrimaryFunctionAddress();
                FunctionMatchData functionMatchData = diff.getMatches().getFunctionMatch(iAddress, ESide.PRIMARY);
                ViewFlowGraphBuilder.colorizeBasicBlocks(functionMatchData, rawCombinedBasicBlock);
            }
        }
    }

    public void setViewFocus(ESide eSide) {
        this.settings.setFocusSide(eSide);
    }

    public void showGraphSettingDialog() {
        if (this.settingsDialog == null) {
            this.settingsDialog = new GraphSettingsDialog((Window)this.getMainWindow(), this.getGraphSettings());
        }
        this.settingsDialog.setVisible(true);
    }

    public void showSearchResultsDialog() {
        ViewToolbarPanel viewToolbarPanel = this.viewTabPanel.getToolbar();
        viewToolbarPanel.getSearchResultsDialog().setVisible(true);
    }

    public void switchViewPanel(EDiffViewMode eDiffViewMode) {
        JPanel jPanel = this.getCurrentViewPanel();
        this.viewTabPanel.remove(jPanel);
        this.settings.setDiffViewMode(eDiffViewMode);
        this.viewTabPanel.add((Component)this.getCurrentViewPanel(), "Center");
        this.viewTabPanel.updateUI();
    }

    public void toggleAutoamticLayout() {
        this.settings.getLayoutSettings().setAutomaticLayouting(!this.settings.getLayoutSettings().getAutomaticLayouting());
    }

    public void toggleGraphsPerspective() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            this.viewTabPanel.getNormalViewPanel().toggleGraphsPerspective();
        } else if (this.settings.getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
            this.viewTabPanel.getCombinedViewPanel().toggleGraphsPerspective();
        }
    }

    public void toggleGraphSynchronization() {
        if (EGraphSynchronization.SYNC == this.settings.getGraphSyncMode()) {
            this.settings.setGraphSyncMode(EGraphSynchronization.ASYNC);
        } else {
            this.settings.setGraphSyncMode(EGraphSynchronization.SYNC);
            GraphLayoutEventHandler.handleReactivateViewSynchronization(this.graphs.getCombinedGraph());
        }
    }

    public void togglePrimaryPerspective() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            this.viewTabPanel.getNormalViewPanel().togglePrimaryPerspective();
        }
    }

    public void toggleProximityBrowsing() {
        BinDiffGraph binDiffGraph = this.graphs.getCombinedGraph();
        if (this.settings.isAsync() && this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            BinDiffGraph binDiffGraph2 = binDiffGraph = this.settings.getFocus() == ESide.PRIMARY ? this.graphs.getPrimaryGraph() : this.graphs.getSecondaryGraph();
        }
        if (!this.settings.getProximitySettings().getProximityBrowsing()) {
            GraphLayoutEventHandler.handleProximityBrowsingActivatedEvent(binDiffGraph);
        } else {
            GraphLayoutEventHandler.handleProximityBrowsingDeactivatedEvent(binDiffGraph);
        }
    }

    public void toggleProximityBrowsingFrozen() {
        GraphProximityBrowsingSettings graphProximityBrowsingSettings;
        graphProximityBrowsingSettings.setProximityBrowsingFrozen(!(graphProximityBrowsingSettings = this.settings.getProximitySettings()).getProximityBrowsingFrozen());
        if (graphProximityBrowsingSettings.getProximityBrowsing() && !graphProximityBrowsingSettings.getProximityBrowsingFrozen()) {
            BinDiffGraph binDiffGraph = this.graphs.getCombinedGraph();
            if (this.settings.isAsync() && this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
                binDiffGraph = this.settings.getFocus() == ESide.PRIMARY ? this.graphs.getPrimaryGraph() : this.graphs.getSecondaryGraph();
            }
            GraphLayoutEventHandler.handleSelectionChangedEvent(binDiffGraph, true);
        }
    }

    public void toggleSecondaryPerspective() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            this.viewTabPanel.getNormalViewPanel().toggleSecondaryPerspective();
        }
    }

    public void undoSelection() {
        this.graphs.getPrimaryGraph().getSelectionHistory().setEnabled(false);
        this.graphs.getSecondaryGraph().getSelectionHistory().setEnabled(false);
        this.graphs.getCombinedGraph().getSelectionHistory().setEnabled(false);
        this.graphs.getPrimaryGraph().getSelectionHistory().undo();
        this.graphs.getSecondaryGraph().getSelectionHistory().undo();
        this.graphs.getCombinedGraph().getSelectionHistory().undo();
        this.graphs.getPrimaryGraph().getSelectionHistory().setEnabled(true);
        this.graphs.getSecondaryGraph().getSelectionHistory().setEnabled(true);
        this.graphs.getCombinedGraph().getSelectionHistory().setEnabled(true);
    }

    public void writeComments() {
        if (!this.hasChangedComments) {
            return;
        }
        try {
            Workspace workspace = this.getWorkspace();
            DiffMetadata diffMetadata = this.graphs.getDiff().getMetadata();
            ViewData viewData = this.viewTabPanel.getView();
            String string = diffMetadata.getImageHash(ESide.PRIMARY);
            String string2 = diffMetadata.getImageHash(ESide.SECONDARY);
            CommentsWriter.writeComments(workspace, string, string2, viewData);
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Couldn't save view comments");
            CMessageBox.showError(this.getMainWindow(), "Couldn't save view comments: " + sQLException.getMessage());
        }
    }

    public void writeFlowgraphMatches() {
        if (!this.hasChangedMatches) {
            return;
        }
        Diff diff = this.graphs.getDiff();
        FlowGraphViewData flowGraphViewData = (FlowGraphViewData)this.viewTabPanel.getView();
        FunctionMatchData functionMatchData = diff.getMatches().getFunctionMatch(flowGraphViewData.getAddress(ESide.PRIMARY), ESide.PRIMARY);
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(diff.getMatchesDatabase());){
            matchesDatabase.updateFunctionMatch(functionMatchData.getAddress(ESide.PRIMARY), functionMatchData.getAddress(ESide.SECONDARY), functionMatchData);
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Couldn't save changed basic block matches");
            CMessageBox.showError(this.getMainWindow(), "Couldn't save changed basic block matches." + sQLException.getMessage());
        }
    }

    public void zoom(boolean bl2) {
        BinDiffGraph binDiffGraph = this.graphs.getCombinedGraph();
        if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            binDiffGraph = this.graphs.getPrimaryGraph();
            if (!this.settings.isSync() && this.settings.getFocus() == ESide.SECONDARY) {
                binDiffGraph = this.graphs.getSecondaryGraph();
            }
        }
        if (bl2) {
            binDiffGraph.zoomIn();
        } else {
            binDiffGraph.zoomOut();
        }
    }

    public void zoomToSelectedNodes() {
        if (this.settings.getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
            GraphZoomer.zoomToNodes(this.graphs.getCombinedGraph(), this.graphs.getCombinedGraph().getSelectedNodes());
        } else if (this.settings.getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
            GraphZoomer.zoomToNodes(this.graphs.getSuperGraph(), this.graphs.getSuperGraph().getSelectedNodes());
        }
    }

    private class InternalEditableContentListener
    implements ILabelEditableContentListener {
        private InternalEditableContentListener() {
        }

        @Override
        public void editableContentChanged(ZyLabelContent zyLabelContent) {
            ViewTabPanelFunctions.this.setCommentsChanged(true);
        }
    }
}

