/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.comparators.RawFunctionTypeComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers.comparators.PercentageTwoBarCellDataComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.IUnmatchedFunctionsViewsTableListener;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.HexStringComparator;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UnmatchedFunctionViewsTableModel
extends AbstractTableModel {
    public static final int ADDRESS = 0;
    public static final int FUNCTION_NAME = 1;
    public static final int TYPE = 2;
    public static final int BASICBLOCKS = 3;
    public static final int JUMPS = 4;
    public static final int INSTRUCTIONS = 5;
    public static final int CALLERS = 6;
    public static final int CALLEES = 7;
    private static final String[] COLUMNS = new String[]{"Address", "Name", "Type", "Basic Blocks", "Jumps", "Instructions", "Callers", "Callees"};
    private final ListenerProvider<IUnmatchedFunctionsViewsTableListener> listeners = new ListenerProvider();
    private final List<Pair<Integer, Comparator<?>>> sorters = new ArrayList();
    private final ESide side;
    private final List<RawFunction> unmatchedFunctions = new ArrayList<RawFunction>();

    public UnmatchedFunctionViewsTableModel(Diff diff, ESide eSide, boolean bl2) {
        super(diff);
        this.side = eSide;
        if (bl2) {
            HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
            hashSet.addAll(GraphGetter.getUnmatchedFunctions(diff.getCallGraph(eSide)));
            this.setUnmatchedFunctions(hashSet);
        }
        this.initSorters();
    }

    private void initSorters() {
        this.sorters.add(new Pair<Integer, HexStringComparator>(0, new HexStringComparator()));
        this.sorters.add(new Pair<Integer, LexicalComparator>(1, new LexicalComparator()));
        this.sorters.add(new Pair<Integer, RawFunctionTypeComparator>(2, new RawFunctionTypeComparator()));
        this.sorters.add(new Pair<Integer, IntComparator>(3, new IntComparator()));
        this.sorters.add(new Pair<Integer, IntComparator>(4, new IntComparator()));
        this.sorters.add(new Pair<Integer, IntComparator>(5, new IntComparator()));
        this.sorters.add(new Pair<Integer, IntComparator>(6, new IntComparator()));
        this.sorters.add(new Pair<Integer, PercentageTwoBarCellDataComparator>(7, new PercentageTwoBarCellDataComparator()));
    }

    public void addListener(IUnmatchedFunctionsViewsTableListener iUnmatchedFunctionsViewsTableListener) {
        this.listeners.addListener(iUnmatchedFunctionsViewsTableListener);
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n2) {
        return COLUMNS[n2];
    }

    @Override
    public int getRowCount() {
        return this.unmatchedFunctions.size();
    }

    public ESide getSide() {
        return this.side;
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        return this.sorters;
    }

    public RawFunction getUnmatchedFunctionAt(int n2) {
        return this.unmatchedFunctions.get(n2);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (this.getRowCount() == 0) {
            return null;
        }
        RawFunction rawFunction = this.unmatchedFunctions.get(n2);
        IAddress iAddress = rawFunction.getAddress();
        switch (n3) {
            case 0: {
                return iAddress.toHexString();
            }
            case 1: {
                return rawFunction.getName();
            }
            case 2: {
                return rawFunction.getFunctionType();
            }
            case 3: {
                return rawFunction.getSizeOfBasicBlocks();
            }
            case 4: {
                return rawFunction.getSizeOfJumps();
            }
            case 5: {
                return rawFunction.getSizeOfInstructions();
            }
            case 6: {
                return rawFunction.getCallers().size();
            }
            case 7: {
                return rawFunction.getCallees().size();
            }
        }
        return null;
    }

    public void removeListener(IUnmatchedFunctionsViewsTableListener iUnmatchedFunctionsViewsTableListener) {
        this.listeners.removeListener(iUnmatchedFunctionsViewsTableListener);
    }

    public void setUnmatchedFunctions(Set<RawFunction> set) {
        this.unmatchedFunctions.clear();
        this.unmatchedFunctions.addAll(set);
        this.fireTableDataChanged();
        for (IUnmatchedFunctionsViewsTableListener iUnmatchedFunctionsViewsTableListener : this.listeners) {
            iUnmatchedFunctionsViewsTableListener.tableDataChanged(this);
        }
    }
}

