/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.comparators.RawFunctionTypeComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers.PercentageThreeBarCellData;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers.comparators.IconComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers.comparators.PercentageThreeBarCellDataComparator;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.IMatchedFunctionsViewsTableListener;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.helpers.MatchesGetter;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.DoubleComparator;
import com.google.security.zynamics.zylib.general.comparators.HexStringComparator;
import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class MatchedFunctionsViewsTableModel
extends AbstractTableModel {
    public static final Icon IDENTICAL_MATCHED_ICON = ImageUtils.getImageIcon("data/tablecellicons/flowgraphs-identical-matched-tab.png");
    public static final Icon INSTRUCTIONS_CHANGED_ICON = ImageUtils.getImageIcon("data/tablecellicons/flowgraphs-changed-instructions-only-tab.png");
    public static final Icon STRUCTURAL_CHANGED_ICON = ImageUtils.getImageIcon("data/tablecellicons/flowgraphs_structural-changed-tab.png");
    public static final int ICON = 0;
    public static final int SIMILARITY = 1;
    public static final int CONFIDENCE = 2;
    public static final int PRIMARY_ADDRESS = 3;
    public static final int PRIMARY_NAME = 4;
    public static final int PRIMARY_TYPE = 5;
    public static final int SECONDARY_ADDRESS = 6;
    public static final int SECONDARY_NAME = 7;
    public static final int SECONDARY_TYPE = 8;
    public static final int BASICBLOCK_MATCHES = 9;
    public static final int JUMP_MATCHES = 10;
    private static final String[] COLUMNS = new String[]{"", "Similarity", "Confidence", "Address", "Primary Name", "Type", "Address", "Secondary Name", "Type", "Basic Blocks", "Jumps"};
    private final ListenerProvider<IMatchedFunctionsViewsTableListener> listeners = new ListenerProvider();
    private final List<Pair<Integer, Comparator<?>>> sorters = new ArrayList();
    private final List<Pair<RawFunction, RawFunction>> matchedFunctionPairs = new ArrayList<Pair<RawFunction, RawFunction>>();

    public MatchedFunctionsViewsTableModel(Diff diff, boolean bl2) {
        super(diff);
        if (bl2) {
            RawCallGraph rawCallGraph = diff.getCallGraph(ESide.PRIMARY);
            RawCallGraph rawCallGraph2 = diff.getCallGraph(ESide.SECONDARY);
            this.setMatchedFunctionPairs(GraphGetter.getChangedFunctionPairs(rawCallGraph, rawCallGraph2));
        }
        this.initSorters();
    }

    private Icon getIcon(RawFunction rawFunction, RawFunction rawFunction2) {
        if (MatchesGetter.isIdenticalFunctionPair(rawFunction, rawFunction2)) {
            return IDENTICAL_MATCHED_ICON;
        }
        if (MatchesGetter.isStructuralChangedFunctionPair(rawFunction, rawFunction2)) {
            return STRUCTURAL_CHANGED_ICON;
        }
        if (MatchesGetter.isInstructionsOnlyChangedFunctionPair(rawFunction, rawFunction2)) {
            return INSTRUCTIONS_CHANGED_ICON;
        }
        return null;
    }

    private void initSorters() {
        this.sorters.add(new Pair<Integer, IconComparator>(0, new IconComparator()));
        this.sorters.add(new Pair<Integer, HexStringComparator>(3, new HexStringComparator()));
        this.sorters.add(new Pair<Integer, LexicalComparator>(4, new LexicalComparator()));
        this.sorters.add(new Pair<Integer, RawFunctionTypeComparator>(5, new RawFunctionTypeComparator()));
        this.sorters.add(new Pair<Integer, PercentageThreeBarCellDataComparator>(9, new PercentageThreeBarCellDataComparator()));
        this.sorters.add(new Pair<Integer, DoubleComparator>(1, new DoubleComparator()));
        this.sorters.add(new Pair<Integer, DoubleComparator>(2, new DoubleComparator()));
        this.sorters.add(new Pair<Integer, PercentageThreeBarCellDataComparator>(10, new PercentageThreeBarCellDataComparator()));
        this.sorters.add(new Pair<Integer, RawFunctionTypeComparator>(8, new RawFunctionTypeComparator()));
        this.sorters.add(new Pair<Integer, LexicalComparator>(7, new LexicalComparator()));
        this.sorters.add(new Pair<Integer, HexStringComparator>(6, new HexStringComparator()));
    }

    public void addListener(IMatchedFunctionsViewsTableListener iMatchedFunctionsViewsTableListener) {
        this.listeners.addListener(iMatchedFunctionsViewsTableListener);
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n2) {
        return COLUMNS[n2];
    }

    public Pair<RawFunction, RawFunction> getMatchedFunctionPairAt(int n2) {
        return this.matchedFunctionPairs.get(n2);
    }

    @Override
    public int getRowCount() {
        return this.matchedFunctionPairs.size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        return this.sorters;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        RawFunction rawFunction = this.matchedFunctionPairs.get(n2).first();
        RawFunction rawFunction2 = this.matchedFunctionPairs.get(n2).second();
        IAddress iAddress = rawFunction.getAddress();
        IAddress iAddress2 = rawFunction2.getAddress();
        int n4 = rawFunction.getSizeOfMatchedBasicBlocks();
        int n5 = rawFunction.getSizeOfBasicBlocks() - n4;
        int n6 = rawFunction2.getSizeOfBasicBlocks() - n4;
        int n7 = rawFunction.getSizeOfMatchedJumps();
        int n8 = rawFunction.getSizeOfJumps() - n7;
        int n9 = rawFunction2.getSizeOfJumps() - n7;
        PercentageThreeBarCellData percentageThreeBarCellData = new PercentageThreeBarCellData(n5, n4, n6, this.getColumnSortRelevance(n3));
        PercentageThreeBarCellData percentageThreeBarCellData2 = new PercentageThreeBarCellData(n8, n7, n9, this.getColumnSortRelevance(n3));
        switch (n3) {
            case 0: {
                return this.getIcon(rawFunction, rawFunction2);
            }
            case 3: {
                return iAddress.toHexString();
            }
            case 4: {
                return rawFunction.getName();
            }
            case 5: {
                return rawFunction.getFunctionType();
            }
            case 9: {
                return percentageThreeBarCellData;
            }
            case 1: {
                return MatchesGetter.getFunctionMatch(this.getDiff(), rawFunction).getSimilarity();
            }
            case 2: {
                return MatchesGetter.getFunctionMatch(this.getDiff(), rawFunction).getConfidence();
            }
            case 10: {
                return percentageThreeBarCellData2;
            }
            case 8: {
                return rawFunction2.getFunctionType();
            }
            case 7: {
                return rawFunction2.getName();
            }
            case 6: {
                return iAddress2.toHexString();
            }
        }
        return null;
    }

    public void removeListener(IMatchedFunctionsViewsTableListener iMatchedFunctionsViewsTableListener) {
        this.listeners.removeListener(iMatchedFunctionsViewsTableListener);
    }

    public void setMatchedFunctionPairs(Set<Pair<RawFunction, RawFunction>> set) {
        this.matchedFunctionPairs.clear();
        this.matchedFunctionPairs.addAll(set);
        this.fireTableDataChanged();
        for (IMatchedFunctionsViewsTableListener iMatchedFunctionsViewsTableListener : this.listeners) {
            iMatchedFunctionsViewsTableListener.tableDataChanged(this);
        }
    }
}

