/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.misc.EPercentageBarSortType;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class AbstractTableModel
extends javax.swing.table.AbstractTableModel {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final Diff diff;
    private final Map<Integer, EPercentageBarSortType> sortRelevance = new HashMap<Integer, EPercentageBarSortType>();

    public AbstractTableModel() {
        this.diff = null;
    }

    public AbstractTableModel(Diff diff) {
        Preconditions.checkNotNull(diff);
        this.diff = diff;
    }

    protected EPercentageBarSortType getColumnSortRelevance(int n2) {
        return this.sortRelevance.get(n2);
    }

    public void dispose() {
    }

    @Override
    public abstract String getColumnName(int var1);

    public Diff getDiff() {
        return this.diff;
    }

    public abstract List<Pair<Integer, Comparator<?>>> getSorters();

    public void setColumnSortRelevance(int n2, EPercentageBarSortType ePercentageBarSortType) {
        if (n2 >= this.getColumnCount()) {
            logger.at(Level.WARNING).log("Column is not in table");
            return;
        }
        this.sortRelevance.put(n2, ePercentageBarSortType);
    }
}

