/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractFunctionDiffViewsTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.ExtendedMatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsContainerTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsContainerTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.IViewsTableListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.UnmatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.tables.CTableSorter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractTable
extends JTable {
    private final AbstractTableModel model;
    private final WorkspaceTabPanelFunctions controller;
    private final CTableSorter tableSorter;
    private final ListenerProvider<IViewsTableListener> listeners = new ListenerProvider();
    private final InternalMouseListener mouseListener = new InternalMouseListener();
    private final InternalSelectionListener selectionListener = new InternalSelectionListener();

    public AbstractTable(AbstractTableModel abstractTableModel, WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.model = Preconditions.checkNotNull(abstractTableModel);
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.tableSorter = new CTableSorter(abstractTableModel);
        this.setModel(this.tableSorter);
        this.tableSorter.setTableHeader(this.getTableHeader());
        for (Pair<Integer, Comparator<?>> pair : abstractTableModel.getSorters()) {
            this.tableSorter.setColumnComparator(pair.first(), pair.second());
        }
        this.getModel().getTableHeader().setToolTipText("Press CTRL to add secondary sort.");
        this.addMouseListener(this.mouseListener);
        this.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    public static Diff getRowDiff(AbstractTable abstractTable, int n2) {
        int n3 = abstractTable.getModel().modelIndex(n2);
        if (abstractTable.getTableModel() instanceof FunctionDiffViewsContainerTableModel) {
            FunctionDiffViewsContainerTableModel functionDiffViewsContainerTableModel = (FunctionDiffViewsContainerTableModel)abstractTable.getTableModel();
            return functionDiffViewsContainerTableModel.getDiffAt(n3);
        }
        if (abstractTable.getTableModel() instanceof FunctionDiffViewsTableModel) {
            FunctionDiffViewsTableModel functionDiffViewsTableModel = (FunctionDiffViewsTableModel)abstractTable.getTableModel();
            return functionDiffViewsTableModel.getDiffAt(n3);
        }
        return abstractTable.getDiff();
    }

    public static Pair<IAddress, IAddress> getViewAddressPair(AbstractTable abstractTable, int n2) {
        IAddress iAddress = null;
        IAddress iAddress2 = null;
        if (abstractTable instanceof MatchedFunctionViewsTable) {
            iAddress = new CAddress(abstractTable.getValueAt(n2, 3).toString(), 16);
            iAddress2 = new CAddress(abstractTable.getValueAt(n2, 6).toString(), 16);
        } else if (abstractTable instanceof ExtendedMatchedFunctionViewsTable) {
            String string;
            String string2 = abstractTable.getValueAt(n2, 3).toString();
            if (!string2.isEmpty()) {
                iAddress = new CAddress(string2, 16);
            }
            if (!(string = abstractTable.getValueAt(n2, 6).toString()).isEmpty()) {
                iAddress2 = new CAddress(string, 16);
            }
        } else if (abstractTable instanceof FunctionDiffViewsContainerTable || abstractTable instanceof FunctionDiffViewsTable) {
            Diff diff = abstractTable.getDiff();
            if (diff == null) {
                AbstractFunctionDiffViewsTableModel abstractFunctionDiffViewsTableModel = (AbstractFunctionDiffViewsTableModel)abstractTable.getTableModel();
                int n3 = abstractTable.getModel().modelIndex(n2);
                diff = abstractFunctionDiffViewsTableModel.getDiffAt(n3);
            }
            if (!diff.isLoaded()) {
                return null;
            }
            iAddress = ((RawFunction)diff.getCallGraph(ESide.PRIMARY).getNodes().get(0)).getAddress();
            iAddress2 = ((RawFunction)diff.getCallGraph(ESide.SECONDARY).getNodes().get(0)).getAddress();
        } else if (abstractTable instanceof UnmatchedFunctionViewsTable) {
            CAddress cAddress = new CAddress(abstractTable.getValueAt(n2, 0).toString(), 16);
            if (((UnmatchedFunctionViewsTable)abstractTable).getSide() == ESide.PRIMARY) {
                iAddress = cAddress;
            } else {
                iAddress2 = cAddress;
            }
        }
        return Pair.make(iAddress, iAddress2);
    }

    private void displayPopupMenu(MouseEvent mouseEvent) {
        int n2;
        int n3 = this.getSelectionIndex(mouseEvent);
        if (n3 == -1) {
            return;
        }
        int n4 = this.rowAtPoint(mouseEvent.getPoint());
        JPopupMenu jPopupMenu = this.getPopupMenu(n4, n2 = this.columnAtPoint(mouseEvent.getPoint()));
        if (jPopupMenu != null) {
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private int getSelectionIndex(MouseEvent mouseEvent) {
        return this.tableSorter.modelIndex(this.rowAtPoint(mouseEvent.getPoint()));
    }

    protected abstract JPopupMenu getPopupMenu(int var1, int var2);

    protected int[] getSortSelectedRows() {
        int[] nArray = this.getSelectedRows();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.tableSorter.modelIndex(nArray[i2]);
        }
        return nArray;
    }

    protected abstract void handleDoubleClick(int var1);

    public void addListener(IViewsTableListener iViewsTableListener) {
        this.listeners.addListener(iViewsTableListener);
    }

    public void dispose() {
        this.removeMouseListener(this.mouseListener);
        this.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.model.dispose();
    }

    public WorkspaceTabPanelFunctions getController() {
        return this.controller;
    }

    public Diff getDiff() {
        return this.model.getDiff();
    }

    @Override
    public CTableSorter getModel() {
        return this.tableSorter;
    }

    public AbstractTableModel getTableModel() {
        return this.model;
    }

    public String getToolTipForRow(Diff diff, int n2) {
        return null;
    }

    public boolean hasSelection() {
        return this.getSelectedRowCount() > 0;
    }

    public void removeListener(IViewsTableListener iViewsTableListener) {
        this.listeners.removeListener(iViewsTableListener);
    }

    public void sortColumn(int n2, int n3) {
        this.tableSorter.setSortingStatus(n2, n3);
    }

    private class InternalSelectionListener
    implements ListSelectionListener {
        private InternalSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            for (IViewsTableListener iViewsTableListener : AbstractTable.this.listeners) {
                iViewsTableListener.rowSelectionChanged(AbstractTable.this);
            }
        }
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                AbstractTable.this.handleDoubleClick(AbstractTable.this.getSelectionIndex(mouseEvent));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3 && !mouseEvent.isControlDown()) {
                int n2 = AbstractTable.this.rowAtPoint(mouseEvent.getPoint());
                if (!((DefaultListSelectionModel)AbstractTable.this.getSelectionModel()).isSelectedIndex(n2)) {
                    AbstractTable.this.getSelectionModel().clearSelection();
                }
                ((DefaultListSelectionModel)AbstractTable.this.getSelectionModel()).addSelectionInterval(n2, n2);
            }
            if (mouseEvent.isPopupTrigger()) {
                AbstractTable.this.displayPopupMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractTable.this.displayPopupMenu(mouseEvent);
            }
        }
    }
}

