/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTableModel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffListenerAdapter;
import com.google.security.zynamics.bindiff.project.diff.IDiffListener;
import java.util.List;

public abstract class AbstractFunctionDiffViewsTableModel
extends AbstractTableModel {
    private final IDiffListener diffListener = new InternalDiffListener();
    List<Diff> functionDiffViewList;

    public AbstractFunctionDiffViewsTableModel(List<Diff> list) {
        Preconditions.checkNotNull(list);
        this.functionDiffViewList = list;
        this.addDiffListener();
    }

    private void addDiffListener() {
        for (Diff diff : this.functionDiffViewList) {
            diff.addListener(this.diffListener);
        }
    }

    private void removeDiffListener() {
        for (Diff diff : this.functionDiffViewList) {
            diff.removeListener(this.diffListener);
        }
    }

    public void addRow(Diff diff) {
        if (this.functionDiffViewList.add(diff)) {
            diff.addListener(this.diffListener);
            this.fireTableDataChanged();
        }
    }

    @Override
    public void dispose() {
        this.removeDiffListener();
    }

    public Diff getDiffAt(int n2) {
        return this.functionDiffViewList.get(n2);
    }

    @Override
    public int getRowCount() {
        return this.functionDiffViewList.size();
    }

    public void removeRow(Diff diff) {
        if (this.functionDiffViewList.remove(diff)) {
            diff.removeListener(this.diffListener);
            this.fireTableDataChanged();
        }
    }

    public void setFunctionDiffList(List<Diff> list) {
        this.removeDiffListener();
        this.functionDiffViewList = list;
        this.addDiffListener();
        this.fireTableDataChanged();
    }

    private class InternalDiffListener
    extends DiffListenerAdapter {
        private InternalDiffListener() {
        }

        private Diff isExisting(String string) {
            for (Diff diff : AbstractFunctionDiffViewsTableModel.this.functionDiffViewList) {
                if (!diff.getMatchesDatabase().getPath().equals(string)) continue;
                return diff;
            }
            return null;
        }

        @Override
        public void willOverwriteDiff(String string) {
            Diff diff = this.isExisting(string);
            if (diff != null) {
                AbstractFunctionDiffViewsTableModel.this.removeRow(diff);
            }
        }
    }
}

