/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels.UnmatchedFunctionViewsFilterPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.IUnmatchedFunctionsViewsTableListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.UnmatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.UnmatchedFunctionViewsTableModel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class UnmatchedFunctionViewsPanel
extends JPanel {
    private final Diff diff;
    private final ESide side;
    private final UnmatchedFunctionViewsTable unmatchedFunctionsTable;
    private final UnmatchedFunctionViewsFilterPanel filterPanel;
    private final InternalViewsTableListener tableListener = new InternalViewsTableListener();
    private final UnmatchedFunctionViewsTableModel unmatchedFunctionsTableModel;

    public UnmatchedFunctionViewsPanel(Diff diff, WorkspaceTabPanelFunctions workspaceTabPanelFunctions, ESide eSide) {
        super(new BorderLayout());
        this.diff = Preconditions.checkNotNull(diff);
        this.side = Preconditions.checkNotNull(eSide);
        this.unmatchedFunctionsTableModel = new UnmatchedFunctionViewsTableModel(diff, eSide, true);
        this.unmatchedFunctionsTable = new UnmatchedFunctionViewsTable(this.unmatchedFunctionsTableModel, Preconditions.checkNotNull(workspaceTabPanelFunctions));
        this.filterPanel = new UnmatchedFunctionViewsFilterPanel(this.unmatchedFunctionsTable, eSide);
        this.unmatchedFunctionsTable.addListener(this.tableListener);
        this.unmatchedFunctionsTableModel.addListener(this.tableListener);
        this.init();
    }

    private void init() {
        this.setBorder(new TitledBorder(""));
        this.updateBorderTitle();
        JScrollPane jScrollPane = new JScrollPane(this.unmatchedFunctionsTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.filterPanel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
    }

    private void updateBorderTitle() {
        ((TitledBorder)this.getBorder()).setTitle(String.format("%d / %d %s Unmatched Functions", this.unmatchedFunctionsTableModel.getRowCount(), this.diff.getMatches().getSizeOfUnmatchedFunctions(this.side), this.side == ESide.PRIMARY ? "Primary" : "Secondary"));
        this.updateUI();
    }

    public List<AbstractTable> getTables() {
        ArrayList<AbstractTable> arrayList = new ArrayList<AbstractTable>();
        arrayList.add(this.unmatchedFunctionsTable);
        return arrayList;
    }

    private class InternalViewsTableListener
    implements IUnmatchedFunctionsViewsTableListener {
        private InternalViewsTableListener() {
        }

        @Override
        public void rowSelectionChanged(UnmatchedFunctionViewsTable unmatchedFunctionViewsTable) {
        }

        @Override
        public void tableDataChanged(UnmatchedFunctionViewsTableModel unmatchedFunctionViewsTableModel) {
            UnmatchedFunctionViewsPanel.this.updateBorderTitle();
        }
    }
}

