/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.viewsearchfield.IViewSearchFieldListener;
import com.google.security.zynamics.bindiff.gui.components.viewsearchfield.TableTextSearchComboBox;
import com.google.security.zynamics.bindiff.gui.dialogs.ViewSearchOptionsDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.UnmatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.UnmatchedFunctionViewsTableModel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.tables.CTableSorter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class UnmatchedFunctionViewsFilterPanel
extends JPanel {
    private static final ImageIcon ICON_OPTIONS = ImageUtils.getImageIcon("data/buttonicons/options.png");
    private static final ImageIcon ICON_CLEAR = ImageUtils.getImageIcon("data/buttonicons/clear.png");
    private static final ImageIcon ICON_CLEAR_GRAY = ImageUtils.getImageIcon("data/buttonicons/clear-gray.png");
    private final InternalClearButtonLister clearButtonListener = new InternalClearButtonLister();
    private final InternalOptionButtonListener optionsButtonListener = new InternalOptionButtonListener();
    private final InternalSearchResultListener searchResultListener = new InternalSearchResultListener();
    private final TableTextSearchComboBox searchCombobox;
    private final JButton optionsButton = new JButton(ICON_OPTIONS);
    private final JButton clearButton = new JButton(ICON_CLEAR_GRAY);
    private final UnmatchedFunctionViewsTable unmatchedFunctionsViewTable;
    private final ESide side;

    public UnmatchedFunctionViewsFilterPanel(UnmatchedFunctionViewsTable unmatchedFunctionViewsTable, ESide eSide) {
        super(new BorderLayout());
        this.unmatchedFunctionsViewTable = Preconditions.checkNotNull(unmatchedFunctionViewsTable);
        this.side = Preconditions.checkNotNull(eSide);
        this.searchCombobox = new TableTextSearchComboBox(unmatchedFunctionViewsTable, UnmatchedFunctionViewsFilterPanel.getColumnIndices(eSide));
        this.searchCombobox.addListener(this.searchResultListener);
        this.clearButton.addActionListener(this.clearButtonListener);
        this.optionsButton.addActionListener(this.optionsButtonListener);
        this.clearButton.setToolTipText("Clear Search Results");
        this.optionsButton.setToolTipText("Search Settings");
        this.add((Component)this.createPanel(), "West");
    }

    private static List<Pair<Integer, ESide>> getColumnIndices(ESide eSide) {
        ArrayList<Pair<Integer, ESide>> arrayList = new ArrayList<Pair<Integer, ESide>>();
        arrayList.add(new Pair<Integer, ESide>(0, eSide));
        arrayList.add(new Pair<Integer, ESide>(1, eSide));
        arrayList.add(new Pair<Integer, ESide>(2, eSide));
        return arrayList;
    }

    private JPanel createPanel() {
        this.searchCombobox.setBackground(Color.WHITE);
        this.searchCombobox.setMinimumSize(new Dimension(30, 0));
        this.searchCombobox.setMaximumSize(new Dimension(400, 0));
        Dimension dimension = new Dimension(400, this.searchCombobox.getPreferredSize().height - 4);
        this.searchCombobox.setPreferredSize(dimension);
        this.searchCombobox.setSize(dimension);
        this.clearButton.setBackground(Color.WHITE);
        this.clearButton.setFocusable(false);
        this.clearButton.setPreferredSize(new Dimension(32, 23));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.searchCombobox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.clearButton, "Center");
        this.optionsButton.setPreferredSize(new Dimension(32, 23));
        this.optionsButton.setBackground(Color.WHITE);
        this.optionsButton.setFocusable(false);
        this.clearButton.setPreferredSize(new Dimension(32, 23));
        this.clearButton.setBackground(Color.WHITE);
        this.clearButton.setFocusable(false);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 1, 1));
        jPanel3.setBorder(new EmptyBorder(0, 1, 0, 5));
        jPanel3.add(this.clearButton);
        jPanel3.add(this.optionsButton);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setMaximumSize(new Dimension(467, 23));
        jPanel4.setMinimumSize(new Dimension(467, 23));
        jPanel4.setSize(new Dimension(467, 23));
        jPanel4.add((Component)jPanel, "West");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel5.add((Component)jPanel4, "West");
        return jPanel5;
    }

    public void dispose() {
        this.searchCombobox.removeListener(this.searchResultListener);
        this.clearButton.removeActionListener(this.clearButtonListener);
    }

    public TableTextSearchComboBox getSearchCombobox() {
        return this.searchCombobox;
    }

    private class InternalSearchResultListener
    implements IViewSearchFieldListener {
        private InternalSearchResultListener() {
        }

        @Override
        public void reset() {
            UnmatchedFunctionViewsTableModel unmatchedFunctionViewsTableModel = (UnmatchedFunctionViewsTableModel)UnmatchedFunctionViewsFilterPanel.this.unmatchedFunctionsViewTable.getTableModel();
            Diff diff = unmatchedFunctionViewsTableModel.getDiff();
            HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
            hashSet.addAll(GraphGetter.getUnmatchedFunctions(diff.getCallGraph(UnmatchedFunctionViewsFilterPanel.this.side)));
            unmatchedFunctionViewsTableModel.setUnmatchedFunctions(hashSet);
            unmatchedFunctionViewsTableModel.fireTableDataChanged();
            UnmatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
            UnmatchedFunctionViewsFilterPanel.this.updateUI();
        }

        @Override
        public void searched(List<Integer> list, boolean bl2) {
            HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
            UnmatchedFunctionViewsTableModel unmatchedFunctionViewsTableModel = (UnmatchedFunctionViewsTableModel)UnmatchedFunctionViewsFilterPanel.this.unmatchedFunctionsViewTable.getTableModel();
            CTableSorter cTableSorter = UnmatchedFunctionViewsFilterPanel.this.unmatchedFunctionsViewTable.getModel();
            ListSelectionModel listSelectionModel = UnmatchedFunctionViewsFilterPanel.this.unmatchedFunctionsViewTable.getSelectionModel();
            for (Integer n2 : list) {
                int n3 = cTableSorter.modelIndex(n2);
                if (bl2) {
                    listSelectionModel.addSelectionInterval(n2, n2);
                    continue;
                }
                hashSet.add(unmatchedFunctionViewsTableModel.getUnmatchedFunctionAt(n3));
            }
            if (!bl2) {
                unmatchedFunctionViewsTableModel.setUnmatchedFunctions(hashSet);
                unmatchedFunctionViewsTableModel.fireTableDataChanged();
            }
            if (list.size() > 0) {
                UnmatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR);
            } else {
                UnmatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
            }
            UnmatchedFunctionViewsFilterPanel.this.updateUI();
        }
    }

    private class InternalOptionButtonListener
    implements ActionListener {
        private InternalOptionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl2 = UnmatchedFunctionViewsFilterPanel.this.searchCombobox.isRegEx();
            boolean bl3 = UnmatchedFunctionViewsFilterPanel.this.searchCombobox.isCaseSensitive();
            boolean bl4 = ESide.PRIMARY == UnmatchedFunctionViewsFilterPanel.this.side;
            boolean bl5 = ESide.SECONDARY == UnmatchedFunctionViewsFilterPanel.this.side;
            boolean bl6 = UnmatchedFunctionViewsFilterPanel.this.searchCombobox.isTemporaryTableUse();
            ViewSearchOptionsDialog viewSearchOptionsDialog = new ViewSearchOptionsDialog(SwingUtilities.getWindowAncestor(UnmatchedFunctionViewsFilterPanel.this), "Filter Options", bl2, bl3, bl4, bl5, bl6);
            viewSearchOptionsDialog.disableSideCheckboxes();
            viewSearchOptionsDialog.setVisible(true);
            if (viewSearchOptionsDialog.getOkButtonPressed() && (bl2 != viewSearchOptionsDialog.getRegExSelected() || bl3 != viewSearchOptionsDialog.getCaseSensitiveSelected() || bl4 != viewSearchOptionsDialog.getPrimarySideSearch() || bl5 != viewSearchOptionsDialog.getSecondarySideSearch() || bl6 != viewSearchOptionsDialog.getTemporaryTableUse())) {
                UnmatchedFunctionViewsFilterPanel.this.searchCombobox.setSearchOptions(viewSearchOptionsDialog.getRegExSelected(), viewSearchOptionsDialog.getCaseSensitiveSelected(), viewSearchOptionsDialog.getPrimarySideSearch(), viewSearchOptionsDialog.getSecondarySideSearch(), viewSearchOptionsDialog.getTemporaryTableUse());
                UnmatchedFunctionViewsFilterPanel.this.searchCombobox.updateResults();
            }
        }
    }

    private class InternalClearButtonLister
    implements ActionListener {
        private InternalClearButtonLister() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnmatchedFunctionViewsFilterPanel.this.searchCombobox.reset();
            UnmatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
        }
    }
}

