/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.viewsearchfield.IViewSearchFieldListener;
import com.google.security.zynamics.bindiff.gui.components.viewsearchfield.TableTextSearchComboBox;
import com.google.security.zynamics.bindiff.gui.dialogs.ViewSearchOptionsDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels.IViewsFilterCheckboxListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionsViewsTableModel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.tables.CTableSorter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class MatchedFunctionViewsFilterPanel
extends JPanel {
    private static final ImageIcon ICON_OPTIONS = ImageUtils.getImageIcon("data/buttonicons/options.png");
    private static final ImageIcon ICON_CLEAR = ImageUtils.getImageIcon("data/buttonicons/clear.png");
    private static final ImageIcon ICON_CLEAR_GRAY = ImageUtils.getImageIcon("data/buttonicons/clear-gray.png");
    private final ListenerProvider<IViewsFilterCheckboxListener> checkBoxFilterListeners = new ListenerProvider();
    private final InternalSearchResultListener searchResultListener;
    private final InternalFilterCheckboxListener filterCheckboxListener;
    private final InternalClearButtonLister clearButtonListener = new InternalClearButtonLister();
    private final InternalOptionButtonListener optionsButtonListener;
    private final JButton optionsButton = new JButton(ICON_OPTIONS);
    private final JButton clearButton = new JButton(ICON_CLEAR_GRAY);
    private final JCheckBox showStructuralChangedFunctions = new JCheckBox("Show structural changes", true);
    private final JCheckBox showInstructionChangedOnlyFunctions = new JCheckBox("Show only instructions changed", true);
    private final JCheckBox showIdenticalFunctions = new JCheckBox("Show identical", true);
    private final TableTextSearchComboBox searchCombobox;
    private final MatchedFunctionViewsTable matchedFunctionsViewTable;

    public MatchedFunctionViewsFilterPanel(MatchedFunctionViewsTable matchedFunctionViewsTable) {
        super(new BorderLayout());
        Preconditions.checkNotNull(matchedFunctionViewsTable);
        this.searchResultListener = new InternalSearchResultListener();
        this.filterCheckboxListener = new InternalFilterCheckboxListener();
        this.optionsButtonListener = new InternalOptionButtonListener();
        this.matchedFunctionsViewTable = matchedFunctionViewsTable;
        this.searchCombobox = new TableTextSearchComboBox(matchedFunctionViewsTable, MatchedFunctionViewsFilterPanel.getColumnIndices());
        this.searchCombobox.addListener(this.searchResultListener);
        this.clearButton.addActionListener(this.clearButtonListener);
        this.optionsButton.addActionListener(this.optionsButtonListener);
        this.clearButton.setToolTipText("Clear Search Results");
        this.optionsButton.setToolTipText("Search Settings");
        this.showStructuralChangedFunctions.addItemListener(this.filterCheckboxListener);
        this.showInstructionChangedOnlyFunctions.addItemListener(this.filterCheckboxListener);
        this.showIdenticalFunctions.addItemListener(this.filterCheckboxListener);
        this.searchCombobox.setSearchOptions(false, false, true, true, false);
        this.add((Component)this.createPanel(), "Center");
    }

    private static List<Pair<Integer, ESide>> getColumnIndices() {
        ArrayList<Pair<Integer, ESide>> arrayList = new ArrayList<Pair<Integer, ESide>>();
        arrayList.add(new Pair<Integer, ESide>(3, ESide.PRIMARY));
        arrayList.add(new Pair<Integer, ESide>(4, ESide.PRIMARY));
        arrayList.add(new Pair<Integer, ESide>(5, ESide.PRIMARY));
        arrayList.add(new Pair<Integer, ESide>(6, ESide.SECONDARY));
        arrayList.add(new Pair<Integer, ESide>(7, ESide.SECONDARY));
        arrayList.add(new Pair<Integer, ESide>(8, ESide.SECONDARY));
        return arrayList;
    }

    private JPanel createChangesFilterPanel() {
        this.showStructuralChangedFunctions.setMinimumSize(new Dimension(0, 0));
        this.showInstructionChangedOnlyFunctions.setMinimumSize(new Dimension(0, 0));
        this.showIdenticalFunctions.setMinimumSize(new Dimension(0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.showStructuralChangedFunctions, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.showInstructionChangedOnlyFunctions, "West");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.showIdenticalFunctions, "West");
        jPanel2.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createPanel() {
        this.searchCombobox.setBackground(Color.WHITE);
        this.searchCombobox.setMinimumSize(new Dimension(30, 0));
        Dimension dimension = new Dimension(this.searchCombobox.getPreferredSize().width, this.searchCombobox.getPreferredSize().height - 4);
        this.searchCombobox.setPreferredSize(dimension);
        this.searchCombobox.setSize(dimension);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.searchCombobox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.createTextFilterPanel(), "West");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.createChangesFilterPanel(), "West");
        jPanel3.setBorder(new EmptyBorder(0, 5, 0, 1));
        jPanel.add((Component)jPanel2, "East");
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel4.add(jPanel);
        return jPanel4;
    }

    private JPanel createTextFilterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Dimension dimension = this.searchCombobox.getPreferredSize();
        this.optionsButton.setPreferredSize(new Dimension(32, dimension.height));
        this.optionsButton.setBackground(Color.WHITE);
        this.optionsButton.setFocusable(false);
        this.clearButton.setPreferredSize(new Dimension(32, dimension.height));
        this.clearButton.setBackground(Color.WHITE);
        this.clearButton.setFocusable(false);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 1, 1));
        jPanel2.setBorder(new EmptyBorder(0, 1, 0, 0));
        jPanel2.add(this.clearButton);
        jPanel2.add(this.optionsButton);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public void addListener(IViewsFilterCheckboxListener iViewsFilterCheckboxListener) {
        this.checkBoxFilterListeners.addListener(iViewsFilterCheckboxListener);
    }

    public void dispose() {
        this.searchCombobox.removeListener(this.searchResultListener);
        this.clearButton.removeActionListener(this.clearButtonListener);
        this.optionsButton.removeActionListener(this.optionsButtonListener);
        this.showStructuralChangedFunctions.removeItemListener(this.filterCheckboxListener);
        this.showInstructionChangedOnlyFunctions.removeItemListener(this.filterCheckboxListener);
        this.showIdenticalFunctions.removeItemListener(this.filterCheckboxListener);
    }

    public void removeListener(IViewsFilterCheckboxListener iViewsFilterCheckboxListener) {
        this.checkBoxFilterListeners.removeListener(iViewsFilterCheckboxListener);
    }

    private class InternalSearchResultListener
    implements IViewSearchFieldListener {
        private InternalSearchResultListener() {
        }

        @Override
        public void reset() {
            MatchedFunctionsViewsTableModel matchedFunctionsViewsTableModel = (MatchedFunctionsViewsTableModel)MatchedFunctionViewsFilterPanel.this.matchedFunctionsViewTable.getTableModel();
            Diff diff = matchedFunctionsViewsTableModel.getDiff();
            RawCallGraph rawCallGraph = diff.getCallGraph(ESide.PRIMARY);
            RawCallGraph rawCallGraph2 = diff.getCallGraph(ESide.SECONDARY);
            HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
            if (MatchedFunctionViewsFilterPanel.this.showStructuralChangedFunctions.isSelected() && MatchedFunctionViewsFilterPanel.this.showInstructionChangedOnlyFunctions.isSelected() && MatchedFunctionViewsFilterPanel.this.showIdenticalFunctions.isSelected()) {
                hashSet.addAll(GraphGetter.getMatchedFunctionPairs(rawCallGraph, rawCallGraph2));
            } else {
                if (MatchedFunctionViewsFilterPanel.this.showStructuralChangedFunctions.isSelected()) {
                    hashSet.addAll(GraphGetter.getStructuralChangedFunctionPairs(rawCallGraph, rawCallGraph2));
                }
                if (MatchedFunctionViewsFilterPanel.this.showInstructionChangedOnlyFunctions.isSelected()) {
                    hashSet.addAll(GraphGetter.getInstructionOnlyChangedFunctionPairs(rawCallGraph, rawCallGraph2));
                }
                if (MatchedFunctionViewsFilterPanel.this.showIdenticalFunctions.isSelected()) {
                    hashSet.addAll(GraphGetter.getIdenticalFunctionPairs(rawCallGraph, rawCallGraph2));
                }
            }
            matchedFunctionsViewsTableModel.setMatchedFunctionPairs(hashSet);
            matchedFunctionsViewsTableModel.fireTableDataChanged();
            MatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
            MatchedFunctionViewsFilterPanel.this.updateUI();
        }

        @Override
        public void searched(List<Integer> list, boolean bl2) {
            HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
            MatchedFunctionsViewsTableModel matchedFunctionsViewsTableModel = (MatchedFunctionsViewsTableModel)MatchedFunctionViewsFilterPanel.this.matchedFunctionsViewTable.getTableModel();
            CTableSorter cTableSorter = MatchedFunctionViewsFilterPanel.this.matchedFunctionsViewTable.getModel();
            ListSelectionModel listSelectionModel = MatchedFunctionViewsFilterPanel.this.matchedFunctionsViewTable.getSelectionModel();
            for (Integer n2 : list) {
                int n3 = cTableSorter.modelIndex(n2);
                if (bl2) {
                    listSelectionModel.addSelectionInterval(n2, n2);
                    continue;
                }
                hashSet.add(matchedFunctionsViewsTableModel.getMatchedFunctionPairAt(n3));
            }
            if (!bl2) {
                matchedFunctionsViewsTableModel.setMatchedFunctionPairs(hashSet);
                matchedFunctionsViewsTableModel.fireTableDataChanged();
            }
            if (list.size() > 0) {
                MatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR);
            } else {
                MatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
            }
            MatchedFunctionViewsFilterPanel.this.updateUI();
        }
    }

    private class InternalOptionButtonListener
    implements ActionListener {
        private InternalOptionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl2 = MatchedFunctionViewsFilterPanel.this.searchCombobox.isRegEx();
            boolean bl3 = MatchedFunctionViewsFilterPanel.this.searchCombobox.isCaseSensitive();
            boolean bl4 = MatchedFunctionViewsFilterPanel.this.searchCombobox.isPrimarySideSearch();
            boolean bl5 = MatchedFunctionViewsFilterPanel.this.searchCombobox.isSecondarySideSearch();
            boolean bl6 = MatchedFunctionViewsFilterPanel.this.searchCombobox.isTemporaryTableUse();
            ViewSearchOptionsDialog viewSearchOptionsDialog = new ViewSearchOptionsDialog(SwingUtilities.getWindowAncestor(MatchedFunctionViewsFilterPanel.this), "Filter Options", bl2, bl3, bl4, bl5, bl6);
            viewSearchOptionsDialog.setVisible(true);
            if (viewSearchOptionsDialog.getOkButtonPressed() && (bl2 != viewSearchOptionsDialog.getRegExSelected() || bl3 != viewSearchOptionsDialog.getCaseSensitiveSelected() || bl4 != viewSearchOptionsDialog.getPrimarySideSearch() || bl5 != viewSearchOptionsDialog.getSecondarySideSearch() || bl6 != viewSearchOptionsDialog.getTemporaryTableUse())) {
                MatchedFunctionViewsFilterPanel.this.searchCombobox.setSearchOptions(viewSearchOptionsDialog.getRegExSelected(), viewSearchOptionsDialog.getCaseSensitiveSelected(), viewSearchOptionsDialog.getPrimarySideSearch(), viewSearchOptionsDialog.getSecondarySideSearch(), viewSearchOptionsDialog.getTemporaryTableUse());
                MatchedFunctionViewsFilterPanel.this.searchCombobox.updateResults();
            }
        }
    }

    private class InternalFilterCheckboxListener
    implements ItemListener {
        private InternalFilterCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl2 = MatchedFunctionViewsFilterPanel.this.showStructuralChangedFunctions.isSelected();
            boolean bl3 = MatchedFunctionViewsFilterPanel.this.showInstructionChangedOnlyFunctions.isSelected();
            boolean bl4 = MatchedFunctionViewsFilterPanel.this.showIdenticalFunctions.isSelected();
            for (IViewsFilterCheckboxListener iViewsFilterCheckboxListener : MatchedFunctionViewsFilterPanel.this.checkBoxFilterListeners) {
                iViewsFilterCheckboxListener.functionViewsFilterChanged(bl2, bl3, bl4);
            }
            MatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
            MatchedFunctionViewsFilterPanel.this.updateUI();
        }
    }

    private class InternalClearButtonLister
    implements ActionListener {
        private InternalClearButtonLister() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MatchedFunctionViewsFilterPanel.this.searchCombobox.reset();
            MatchedFunctionViewsFilterPanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
        }
    }
}

