/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.security.zynamics.bindiff.enums.ECallDirection;
import com.google.security.zynamics.bindiff.enums.EExistence;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.edges.SingleViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.ExtendedMatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.ExtendedMatchedFunctionViewsTableModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.IMatchedFunctionsViewsTableListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionsViewsTableModel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Triple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class AddedAndRemovedCalledFunctionsPanel
extends JPanel {
    private static final String INCOMING_CALLS_BORDER_TEXT = "+%d / -%d Added and removed Parent Functions calling the selected Functions";
    private static final String OUTGOING_CALLS_BORDER_TEXT = "+%d / -%d Added and removed Child Functions called from the selected Functions";
    private final TitledBorder incomingBorder = new TitledBorder(String.format("+%d / -%d Added and removed Parent Functions calling the selected Functions", 0, 0));
    private final TitledBorder outgoingBorder = new TitledBorder(String.format("+%d / -%d Added and removed Child Functions called from the selected Functions", 0, 0));
    private final ExtendedMatchedFunctionViewsTable incomingFunctionsCalledTable;
    private final ExtendedMatchedFunctionViewsTable outgoingFunctionsCalledTable;
    private final Diff diff;
    private final MatchedFunctionViewsTable matchedfunctionViewsTable;
    private final InternalMatchedFunctionViewsTableListener matchedFunctionViewsSelectionListener = new InternalMatchedFunctionViewsTableListener();

    public AddedAndRemovedCalledFunctionsPanel(Diff diff, WorkspaceTabPanelFunctions workspaceTabPanelFunctions, MatchedFunctionViewsTable matchedFunctionViewsTable) {
        super(new BorderLayout());
        Preconditions.checkNotNull(diff);
        Preconditions.checkNotNull(workspaceTabPanelFunctions);
        Preconditions.checkNotNull(matchedFunctionViewsTable);
        this.diff = diff;
        this.matchedfunctionViewsTable = matchedFunctionViewsTable;
        this.incomingFunctionsCalledTable = new ExtendedMatchedFunctionViewsTable(new ExtendedMatchedFunctionViewsTableModel(diff), workspaceTabPanelFunctions);
        this.outgoingFunctionsCalledTable = new ExtendedMatchedFunctionViewsTable(new ExtendedMatchedFunctionViewsTableModel(diff), workspaceTabPanelFunctions);
        this.matchedfunctionViewsTable.addListener(this.matchedFunctionViewsSelectionListener);
        this.add((Component)this.createFunctionsCalledPanel(), "Center");
    }

    private JPanel createFunctionsCalledPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(0, true);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setRightComponent(this.createOutgoingFunctionsCalledTable());
        jSplitPane.setLeftComponent(this.createIncomingFunctionsCalledPanel());
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(0.5);
        jPanel.add((Component)jSplitPane, "Center");
        return jPanel;
    }

    private JPanel createIncomingFunctionsCalledPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.incomingBorder);
        jPanel.add((Component)this.createTablePanel(this.incomingFunctionsCalledTable), "Center");
        return jPanel;
    }

    private JPanel createOutgoingFunctionsCalledTable() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.outgoingBorder);
        jPanel.add((Component)this.createTablePanel(this.outgoingFunctionsCalledTable), "Center");
        return jPanel;
    }

    private JPanel createTablePanel(AbstractTable abstractTable) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(abstractTable);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private Multiset<RawFunction> getFunctions(RawFunction rawFunction, ECallDirection eCallDirection) {
        HashMultiset<RawFunction> hashMultiset = HashMultiset.create();
        List<SingleViewEdge<? extends SingleViewNode>> list = eCallDirection == ECallDirection.INCOMING ? rawFunction.getIncomingEdges() : rawFunction.getOutgoingEdges();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : list) {
            hashMultiset.add(eCallDirection == ECallDirection.INCOMING ? (RawFunction)singleViewEdge.getSource() : (RawFunction)singleViewEdge.getTarget());
        }
        return hashMultiset;
    }

    private void getSecondaryFunctionCallChanges(IAddress iAddress, IAddress iAddress2, ECallDirection eCallDirection, List<Triple<RawFunction, RawFunction, EExistence>> list) {
        RawFunction rawFunction = this.diff.getCallGraph(ESide.PRIMARY).getFunction(iAddress);
        RawFunction rawFunction2 = this.diff.getCallGraph(ESide.SECONDARY).getFunction(iAddress2);
        Multiset<RawFunction> multiset = this.getFunctions(rawFunction, eCallDirection);
        Multiset<RawFunction> multiset2 = this.getFunctions(rawFunction2, eCallDirection);
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        ArrayList<RawFunction> arrayList2 = new ArrayList<RawFunction>();
        for (RawFunction object : multiset2) {
            RawFunction rawFunction3 = object.getMatchedFunction();
            if (rawFunction3 == null || !multiset.remove(rawFunction3)) continue;
            arrayList.add(rawFunction3);
            arrayList2.add(object);
        }
        multiset2.removeAll(arrayList2);
        for (RawFunction rawFunction4 : multiset2) {
            list.add(Triple.make(rawFunction4.getMatchedFunction(), rawFunction4, EExistence.ADDED));
        }
        multiset.addAll(arrayList);
        multiset2.addAll(arrayList2);
        ArrayList arrayList3 = new ArrayList();
        for (RawFunction rawFunction3 : multiset) {
            RawFunction rawFunction5 = rawFunction3.getMatchedFunction();
            if (rawFunction5 == null || !multiset2.remove(rawFunction5)) continue;
            arrayList3.add(rawFunction3);
        }
        multiset.removeAll(arrayList3);
        for (RawFunction rawFunction3 : multiset) {
            list.add(Triple.make(rawFunction3, rawFunction3.getMatchedFunction(), EExistence.REMOVED));
        }
    }

    private void updateBorders(int n2, int n3, int n4, int n5) {
        this.incomingBorder.setTitle(String.format(INCOMING_CALLS_BORDER_TEXT, n2, n3));
        this.outgoingBorder.setTitle(String.format(OUTGOING_CALLS_BORDER_TEXT, n4, n5));
        this.updateUI();
    }

    public void dispose() {
        this.matchedfunctionViewsTable.removeListener(this.matchedFunctionViewsSelectionListener);
    }

    private class InternalMatchedFunctionViewsTableListener
    implements IMatchedFunctionsViewsTableListener {
        private InternalMatchedFunctionViewsTableListener() {
        }

        @Override
        public void rowSelectionChanged(MatchedFunctionViewsTable matchedFunctionViewsTable) {
            int[] nArray = matchedFunctionViewsTable.getSelectedRows();
            ArrayList<Triple<RawFunction, RawFunction, EExistence>> arrayList = new ArrayList<Triple<RawFunction, RawFunction, EExistence>>();
            ArrayList<Triple<RawFunction, RawFunction, EExistence>> arrayList2 = new ArrayList<Triple<RawFunction, RawFunction, EExistence>>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int n6 : nArray) {
                String string = (String)matchedFunctionViewsTable.getModel().getValueAt(n6, 3);
                String string2 = (String)matchedFunctionViewsTable.getModel().getValueAt(n6, 6);
                CAddress cAddress = new CAddress(string, 16);
                CAddress cAddress2 = new CAddress(string2, 16);
                AddedAndRemovedCalledFunctionsPanel.this.getSecondaryFunctionCallChanges(cAddress, cAddress2, ECallDirection.INCOMING, arrayList);
                AddedAndRemovedCalledFunctionsPanel.this.getSecondaryFunctionCallChanges(cAddress, cAddress2, ECallDirection.OUTGOING, arrayList2);
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                Triple triple = (Triple)object.next();
                if (triple.third() == EExistence.ADDED) {
                    ++n2;
                    continue;
                }
                ++n3;
            }
            for (Triple triple : arrayList2) {
                if (triple.third() == EExistence.ADDED) {
                    ++n4;
                    continue;
                }
                ++n5;
            }
            ((ExtendedMatchedFunctionViewsTableModel)AddedAndRemovedCalledFunctionsPanel.this.outgoingFunctionsCalledTable.getTableModel()).setMatchedFunctionPairs(arrayList2);
            ((ExtendedMatchedFunctionViewsTableModel)AddedAndRemovedCalledFunctionsPanel.this.incomingFunctionsCalledTable.getTableModel()).setMatchedFunctionPairs(arrayList);
            ((ExtendedMatchedFunctionViewsTableModel)AddedAndRemovedCalledFunctionsPanel.this.outgoingFunctionsCalledTable.getTableModel()).fireTableDataChanged();
            ((ExtendedMatchedFunctionViewsTableModel)AddedAndRemovedCalledFunctionsPanel.this.incomingFunctionsCalledTable.getTableModel()).fireTableDataChanged();
            AddedAndRemovedCalledFunctionsPanel.this.updateBorders(n2, n3, n4, n5);
        }

        @Override
        public void tableDataChanged(MatchedFunctionsViewsTableModel matchedFunctionsViewsTableModel) {
        }
    }
}

