/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers;

import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.misc.EPercentageBarSortType;
import com.google.security.zynamics.zylib.general.Pair;

public class PercentageTwoBarCellData {
    private final Pair<Integer, Integer> data;
    private final EPercentageBarSortType sortRelevance;
    private final boolean inverted;

    public PercentageTwoBarCellData(int n2, int n3) {
        this(n2, n3, EPercentageBarSortType.SORT_BY_CENTER_VALUE, false);
    }

    public PercentageTwoBarCellData(int n2, int n3, EPercentageBarSortType ePercentageBarSortType, boolean bl2) {
        this.data = new Pair<Integer, Integer>(n2, n3);
        this.sortRelevance = ePercentageBarSortType == null ? EPercentageBarSortType.SORT_BY_CENTER_VALUE : ePercentageBarSortType;
        this.inverted = bl2;
    }

    public double getLeftBarPercent() {
        if (this.inverted) {
            return (double)(this.data.second() / this.getTotalBarValue()) * 100.0;
        }
        return (double)(this.data.first() / this.getTotalBarValue()) * 100.0;
    }

    public String getLeftBarString(boolean bl2) {
        String string = "%d";
        string = String.format(string, this.inverted ? this.getRightBarValue() : this.getLeftBarValue());
        if (bl2) {
            string = string + "%s(%.1f)";
            string = String.format(string, this.inverted ? this.getRightBarPercent() : this.getLeftBarPercent());
        }
        return string;
    }

    public int getLeftBarValue() {
        if (this.inverted) {
            return this.data.second();
        }
        return this.data.first();
    }

    public double getRightBarPercent() {
        if (this.inverted) {
            return (double)(this.data.first() / this.getTotalBarValue()) * 100.0;
        }
        return (double)(this.data.second() / this.getTotalBarValue()) * 100.0;
    }

    public String getRightBarString(boolean bl2) {
        String string = "%d";
        string = String.format(string, this.inverted ? this.getLeftBarValue() : this.getRightBarValue());
        if (bl2) {
            string = string + "%s(%.1f)";
            string = String.format(string, this.inverted ? this.getLeftBarPercent() : this.getRightBarPercent());
        }
        return string;
    }

    public int getRightBarValue() {
        if (this.inverted) {
            return this.data.first();
        }
        return this.data.second();
    }

    public double getSortByValue() {
        if (this.sortRelevance == EPercentageBarSortType.SORT_BY_LEFT_VALUE) {
            return this.data.first().intValue();
        }
        if (this.sortRelevance == EPercentageBarSortType.SORT_BY_RIGHT_VALUE) {
            return this.data.second().intValue();
        }
        return this.getTotalBarValue();
    }

    public int getTotalBarValue() {
        return this.data.first() + this.data.second();
    }
}

