/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts;

import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.BarChart2dPanel;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class SimilarityBarChart2dPanel
extends JPanel {
    private static final int SIMILARITY = 0;
    private static final String SERIES = "Similarity";
    private final DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private final BarChart2dPanel barChart;
    private final double similarity;

    public SimilarityBarChart2dPanel(DiffMetadata diffMetadata) {
        super(new BorderLayout());
        this.similarity = diffMetadata.getTotalSimilarity();
        this.barChart = new BarChart2dPanel(this.getTitle(), this.dataset);
        this.init();
        this.updateDataset(diffMetadata.getSimilarityIntervalCounts());
        this.setPreferredSize(new Dimension(200, 200));
        this.add((Component)this.barChart, "Center");
    }

    private String getTitle() {
        return this.similarity == -1.0 ? SERIES : String.format("%s %.2f", SERIES, this.similarity);
    }

    private void init() {
        this.barChart.setSeriesStrokeWidth(0, 2.0f);
        this.barChart.setTooltipGenerator(new CustomTooltipGenerator());
    }

    private void updateDataset(int[] nArray) {
        for (int i2 = 0; i2 <= 10; ++i2) {
            this.dataset.addValue(nArray[i2], (Comparable)((Object)SERIES), (Comparable)Double.valueOf((double)i2 / 10.0));
        }
    }

    public JFreeChart getChart() {
        return this.barChart.getChart();
    }

    public void updateDataset(Vector<Double> vector) {
        if (vector.size() == 0) {
            return;
        }
        int[] nArray = new int[11];
        for (double d2 : vector) {
            int n2 = (int)Math.floor(d2 * 10.0);
            nArray[n2] = nArray[n2] + 1;
        }
        this.dataset.clear();
        this.updateDataset(nArray);
        this.barChart.setTitle(this.getTitle());
        this.barChart.fireChartChanged();
    }

    public class CustomTooltipGenerator
    implements CategoryToolTipGenerator {
        @Override
        public String generateToolTip(CategoryDataset categoryDataset, int n2, int n3) {
            String string = null;
            double d2 = (double)n3 / 10.0;
            String string2 = "";
            string2 = d2 == 1.0 ? "= 1.0" : String.format("%.1f - %.1f", d2, d2 + 0.1);
            string = String.format("%.0f %s (%s %s)", (double)((Double)categoryDataset.getValue(n2, n3)), "Matched Functions", SimilarityBarChart2dPanel.SERIES, string2);
            return string;
        }
    }
}

