/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.Pie3dPanel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.resources.Colors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.AttributedString;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class FunctionMatchesPie3dPanel
extends JPanel {
    private static final String MATCHED_FUNCTIONS = "Matched Functions";
    private static final String PRIMRAY_UNMATCHED_FUNCTIONS = "Primary unmatched Functions";
    private static final String SECONDARY_UNMATCHED_FUNCTIONS = "Secondary unmatched Functions";
    private final Pie3dPanel piePanel;
    private final int matchedCount;
    private final int primaryUnmatchedCount;
    private final int secondaryUnmatchedCount;
    private final double matchedPercent;
    private final double primaryUnmatchedPercent;
    private final double secondaryUnmatchedPercent;

    public FunctionMatchesPie3dPanel(Diff diff) {
        super(new BorderLayout());
        Preconditions.checkNotNull(diff);
        MatchData matchData = diff.getMatches();
        this.matchedCount = matchData.getSizeOfMatchedFunctions();
        this.primaryUnmatchedCount = matchData.getSizeOfUnmatchedFunctions(ESide.PRIMARY);
        this.secondaryUnmatchedCount = matchData.getSizeOfUnmatchedFunctions(ESide.SECONDARY);
        int n2 = this.matchedCount + this.primaryUnmatchedCount + this.secondaryUnmatchedCount;
        this.matchedPercent = (double)this.matchedCount / (double)n2 * 100.0;
        this.primaryUnmatchedPercent = (double)this.primaryUnmatchedCount / (double)n2 * 100.0;
        this.secondaryUnmatchedPercent = (double)this.secondaryUnmatchedCount / (double)n2 * 100.0;
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)MATCHED_FUNCTIONS), this.matchedPercent);
        defaultPieDataset.setValue((Comparable)((Object)PRIMRAY_UNMATCHED_FUNCTIONS), this.primaryUnmatchedPercent);
        defaultPieDataset.setValue((Comparable)((Object)SECONDARY_UNMATCHED_FUNCTIONS), this.secondaryUnmatchedPercent);
        this.piePanel = new Pie3dPanel(this.getTitle(), defaultPieDataset, new CustomLabelGenerator());
        this.piePanel.setSectionColor(MATCHED_FUNCTIONS, Colors.PIE_MATCHED);
        this.piePanel.setSectionColor(PRIMRAY_UNMATCHED_FUNCTIONS, Colors.PIE_PRIMARY_UNMATCHED);
        this.piePanel.setSectionColor(SECONDARY_UNMATCHED_FUNCTIONS, Colors.PIE_SECONDARY_UNMATCHED);
        this.piePanel.setTooltipGenerator(new CustomTooltipGenerator());
        this.add((Component)this.piePanel, "Center");
    }

    private String getTitle() {
        if (Double.isNaN(this.matchedPercent)) {
            return "Functions";
        }
        return String.format("%s %.1f%s", "Functions", this.matchedPercent, "%");
    }

    public FunctionMatchesPie3dPanel(DiffMetadata diffMetadata) {
        super(new BorderLayout());
        Preconditions.checkNotNull(diffMetadata);
        this.matchedCount = diffMetadata.getSizeOfMatchedFunctions();
        this.primaryUnmatchedCount = diffMetadata.getSizeOfUnmatchedFunctions(ESide.PRIMARY);
        this.secondaryUnmatchedCount = diffMetadata.getSizeOfUnmatchedFunctions(ESide.SECONDARY);
        int n2 = this.matchedCount + this.primaryUnmatchedCount + this.secondaryUnmatchedCount;
        this.matchedPercent = (double)this.matchedCount / (double)n2 * 100.0;
        this.primaryUnmatchedPercent = (double)this.primaryUnmatchedCount / (double)n2 * 100.0;
        this.secondaryUnmatchedPercent = (double)this.secondaryUnmatchedCount / (double)n2 * 100.0;
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)MATCHED_FUNCTIONS), this.matchedPercent);
        defaultPieDataset.setValue((Comparable)((Object)PRIMRAY_UNMATCHED_FUNCTIONS), this.primaryUnmatchedPercent);
        defaultPieDataset.setValue((Comparable)((Object)SECONDARY_UNMATCHED_FUNCTIONS), this.secondaryUnmatchedPercent);
        this.piePanel = new Pie3dPanel(String.format("%s %.1f%s", "Functions", this.matchedPercent, "%"), defaultPieDataset, new CustomLabelGenerator());
        this.piePanel.setSectionColor(MATCHED_FUNCTIONS, Colors.PIE_MATCHED);
        this.piePanel.setSectionColor(PRIMRAY_UNMATCHED_FUNCTIONS, Colors.PIE_PRIMARY_UNMATCHED);
        this.piePanel.setSectionColor(SECONDARY_UNMATCHED_FUNCTIONS, Colors.PIE_SECONDARY_UNMATCHED);
        this.piePanel.setTooltipGenerator(new CustomTooltipGenerator());
        this.add((Component)this.piePanel, "Center");
    }

    public JFreeChart getChart() {
        return this.piePanel.getChart();
    }

    private class CustomTooltipGenerator
    implements PieToolTipGenerator {
        private CustomTooltipGenerator() {
        }

        @Override
        public String generateToolTip(PieDataset pieDataset, Comparable comparable) {
            if (pieDataset == null) {
                return null;
            }
            if (comparable.equals(FunctionMatchesPie3dPanel.MATCHED_FUNCTIONS)) {
                return String.format("%s %d (%.1f%s)", FunctionMatchesPie3dPanel.MATCHED_FUNCTIONS, FunctionMatchesPie3dPanel.this.matchedCount, FunctionMatchesPie3dPanel.this.matchedPercent, "%");
            }
            if (comparable.equals(FunctionMatchesPie3dPanel.PRIMRAY_UNMATCHED_FUNCTIONS)) {
                return String.format("%s %d (%.1f%s)", FunctionMatchesPie3dPanel.PRIMRAY_UNMATCHED_FUNCTIONS, FunctionMatchesPie3dPanel.this.primaryUnmatchedCount, FunctionMatchesPie3dPanel.this.primaryUnmatchedPercent, "%");
            }
            if (comparable.equals(FunctionMatchesPie3dPanel.SECONDARY_UNMATCHED_FUNCTIONS)) {
                return String.format("%s %d (%.1f%s)", FunctionMatchesPie3dPanel.SECONDARY_UNMATCHED_FUNCTIONS, FunctionMatchesPie3dPanel.this.secondaryUnmatchedCount, FunctionMatchesPie3dPanel.this.secondaryUnmatchedPercent, "%");
            }
            return null;
        }
    }

    private class CustomLabelGenerator
    implements PieSectionLabelGenerator {
        private CustomLabelGenerator() {
        }

        @Override
        public AttributedString generateAttributedSectionLabel(PieDataset pieDataset, Comparable comparable) {
            return null;
        }

        @Override
        public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
            if (pieDataset == null) {
                return null;
            }
            if (comparable.equals(FunctionMatchesPie3dPanel.MATCHED_FUNCTIONS)) {
                return String.format("%d\n%.1f%s", FunctionMatchesPie3dPanel.this.matchedCount, FunctionMatchesPie3dPanel.this.matchedPercent, "%");
            }
            if (comparable.equals(FunctionMatchesPie3dPanel.PRIMRAY_UNMATCHED_FUNCTIONS)) {
                return String.format("%d\n%.1f%s", FunctionMatchesPie3dPanel.this.primaryUnmatchedCount, FunctionMatchesPie3dPanel.this.primaryUnmatchedPercent, "%");
            }
            if (comparable.equals(FunctionMatchesPie3dPanel.SECONDARY_UNMATCHED_FUNCTIONS)) {
                return String.format("%d\n%.1f%s", FunctionMatchesPie3dPanel.this.secondaryUnmatchedCount, FunctionMatchesPie3dPanel.this.secondaryUnmatchedPercent, "%");
            }
            return null;
        }
    }
}

