/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.Pie3dPanel;
import com.google.security.zynamics.bindiff.project.diff.CountsChangedListener;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.resources.Colors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.AttributedString;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class BasicBlockMatchesPie3dPanel
extends JPanel {
    private static final int MATCHED_BASICBLOCKS = 0;
    private static final int PRIMRAY_UNMATCHED_BASICBLOCKS = 1;
    private static final int SECONDARY_UNMATCHED_BASICBLOCKS = 2;
    private static final String[] PLOTS = new String[]{"Matched Basicblocks", "Primary unmatched Basicblocks", "Secondary unmatched Basicblocks"};
    private int matchedCount = 0;
    private int primaryUnmatchedCount = 0;
    private int secondaryUnmatchedCount = 0;
    private double matchedPercent = 0.0;
    private double primaryUnmatchedPercent = 0.0;
    private double secondaryUnmatchedPercent = 0.0;
    private final boolean includeUnmtachedFunctions;
    private final Diff diff;
    private final Pie3dPanel piePanel;
    private final DefaultPieDataset dataset = new DefaultPieDataset();
    private final InternalFlowgraphCachedCountsListener changeListener = new InternalFlowgraphCachedCountsListener();

    public BasicBlockMatchesPie3dPanel(Diff diff, boolean bl2) {
        super(new BorderLayout());
        Preconditions.checkNotNull(diff);
        this.includeUnmtachedFunctions = bl2;
        this.diff = diff;
        this.piePanel = new Pie3dPanel(this.getTitle(), this.dataset, new CustomLabelGenerator());
        this.piePanel.setSectionColor(PLOTS[0], Colors.PIE_MATCHED);
        this.piePanel.setSectionColor(PLOTS[1], Colors.PIE_PRIMARY_UNMATCHED);
        this.piePanel.setSectionColor(PLOTS[2], Colors.PIE_SECONDARY_UNMATCHED);
        this.piePanel.setTooltipGenerator(new CustomTooltipGenerator());
        this.add((Component)this.piePanel, "Center");
        if (this.includeUnmtachedFunctions) {
            diff.getMetadata().addListener(this.changeListener);
            this.updateDataset();
        }
    }

    private String getTitle() {
        if (Double.isNaN(this.matchedPercent)) {
            return "Basic Blocks";
        }
        return String.format("%s %.1f%s", "Basic Blocks", this.matchedPercent, "%");
    }

    private void updateDataset() {
        MatchData matchData = this.diff.getMatches();
        this.matchedCount = matchData.getSizeOfMatchedBasicBlocks();
        this.primaryUnmatchedCount = matchData.getSizeOfUnmatchedBasicBlocks(ESide.PRIMARY);
        this.secondaryUnmatchedCount = matchData.getSizeOfUnmatchedBasicBlocks(ESide.SECONDARY);
        int n2 = this.matchedCount + this.primaryUnmatchedCount + this.secondaryUnmatchedCount;
        this.matchedPercent = (double)this.matchedCount / (double)n2 * 100.0;
        this.primaryUnmatchedPercent = (double)this.primaryUnmatchedCount / (double)n2 * 100.0;
        this.secondaryUnmatchedPercent = (double)this.secondaryUnmatchedCount / (double)n2 * 100.0;
        this.dataset.setValue((Comparable)((Object)PLOTS[0]), this.matchedPercent);
        this.dataset.setValue((Comparable)((Object)PLOTS[1]), this.primaryUnmatchedPercent);
        this.dataset.setValue((Comparable)((Object)PLOTS[2]), this.secondaryUnmatchedPercent);
        this.piePanel.setTitle(this.getTitle());
        this.piePanel.fireChartChanged();
    }

    public void dispose() {
        if (this.includeUnmtachedFunctions) {
            this.diff.getMetadata().removeListener(this.changeListener);
        }
    }

    public JFreeChart getChart() {
        return this.piePanel.getChart();
    }

    public void updateDataset(int n2, int n3, int n4) {
        if (!this.includeUnmtachedFunctions) {
            this.matchedCount = n2;
            this.primaryUnmatchedCount = n3;
            this.secondaryUnmatchedCount = n4;
            int n5 = this.matchedCount + this.primaryUnmatchedCount + this.secondaryUnmatchedCount;
            this.matchedPercent = (double)this.matchedCount / (double)n5 * 100.0;
            this.primaryUnmatchedPercent = (double)this.primaryUnmatchedCount / (double)n5 * 100.0;
            this.secondaryUnmatchedPercent = (double)this.secondaryUnmatchedCount / (double)n5 * 100.0;
            this.dataset.setValue((Comparable)((Object)PLOTS[0]), this.matchedPercent);
            this.dataset.setValue((Comparable)((Object)PLOTS[1]), this.primaryUnmatchedPercent);
            this.dataset.setValue((Comparable)((Object)PLOTS[2]), this.secondaryUnmatchedPercent);
            this.piePanel.setTitle(this.getTitle());
            this.piePanel.fireChartChanged();
        }
    }

    private class InternalFlowgraphCachedCountsListener
    extends CountsChangedListener {
        private InternalFlowgraphCachedCountsListener() {
        }

        @Override
        public void basicBlocksCountChanged() {
            BasicBlockMatchesPie3dPanel.this.updateDataset();
        }
    }

    private class CustomTooltipGenerator
    implements PieToolTipGenerator {
        private CustomTooltipGenerator() {
        }

        @Override
        public String generateToolTip(PieDataset pieDataset, Comparable comparable) {
            if (pieDataset != null) {
                if (comparable.equals(PLOTS[0])) {
                    return String.format("%s %d (%.1f%s)", PLOTS[0], BasicBlockMatchesPie3dPanel.this.matchedCount, BasicBlockMatchesPie3dPanel.this.matchedPercent, "%");
                }
                if (comparable.equals(PLOTS[1])) {
                    return String.format("%s %d (%.1f%s)", PLOTS[1], BasicBlockMatchesPie3dPanel.this.primaryUnmatchedCount, BasicBlockMatchesPie3dPanel.this.primaryUnmatchedPercent, "%");
                }
                if (comparable.equals(PLOTS[2])) {
                    return String.format("%s %d (%.1f%s)", PLOTS[2], BasicBlockMatchesPie3dPanel.this.secondaryUnmatchedCount, BasicBlockMatchesPie3dPanel.this.secondaryUnmatchedPercent, "%");
                }
            }
            return null;
        }
    }

    private class CustomLabelGenerator
    implements PieSectionLabelGenerator {
        private CustomLabelGenerator() {
        }

        @Override
        public AttributedString generateAttributedSectionLabel(PieDataset pieDataset, Comparable comparable) {
            return null;
        }

        @Override
        public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
            String string = null;
            if (pieDataset != null) {
                if (comparable.equals(PLOTS[0])) {
                    string = String.format("%d\n%.1f%s", BasicBlockMatchesPie3dPanel.this.matchedCount, BasicBlockMatchesPie3dPanel.this.matchedPercent, "%");
                } else if (comparable.equals(PLOTS[1])) {
                    string = String.format("%d\n%.1f%s", BasicBlockMatchesPie3dPanel.this.primaryUnmatchedCount, BasicBlockMatchesPie3dPanel.this.primaryUnmatchedPercent, "%");
                } else if (comparable.equals(PLOTS[2])) {
                    string = String.format("%d\n%.1f%s", BasicBlockMatchesPie3dPanel.this.secondaryUnmatchedCount, BasicBlockMatchesPie3dPanel.this.secondaryUnmatchedPercent, "%");
                }
            }
            return string;
        }
    }
}

