/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.AbstractTreeNodeContextPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.BasicBlockMatchesPie3dPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.InstructionMatchesPie3dPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.JumpMatchesPie3dPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.SimilarityBarChart2dPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels.AddedAndRemovedCalledFunctionsPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels.IViewsFilterCheckboxListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.subpanels.MatchedFunctionViewsFilterPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.IMatchedFunctionsViewsTableListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionViewsTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.MatchedFunctionsViewsTableModel;
import com.google.security.zynamics.bindiff.project.diff.CountsChangedListener;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.GraphGetter;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class MatchedFunctionsTreeNodeContextPanel
extends AbstractTreeNodeContextPanel {
    private final Diff diff;
    private final JPanel tablePanel = new JPanel(new BorderLayout());
    private JPanel overviewPanel = new JPanel(new BorderLayout());
    private final MatchedFunctionViewsFilterPanel filterPanel;
    private final AddedAndRemovedCalledFunctionsPanel callerAndCalleesPanel;
    private final JumpMatchesPie3dPanel jumpsPiePanel;
    private final BasicBlockMatchesPie3dPanel basicBlocksPiePanel;
    private final InstructionMatchesPie3dPanel instructionsPiePanel;
    private final SimilarityBarChart2dPanel similarityBarChartPanel;
    private final MatchedFunctionsViewsTableModel matchedFunctionsTableModel;
    private final MatchedFunctionViewsTable matchedFunctionsTable;
    private final InternalViewsTableListener tableListener = new InternalViewsTableListener();
    private final InternalFilterCheckboxListener filterCheckboxListener = new InternalFilterCheckboxListener();
    private final InternalFlowGraphCachedCountsListener countsChangeListener = new InternalFlowGraphCachedCountsListener();

    public MatchedFunctionsTreeNodeContextPanel(WorkspaceTabPanelFunctions workspaceTabPanelFunctions, Diff diff) {
        Preconditions.checkNotNull(diff);
        this.diff = diff;
        this.basicBlocksPiePanel = new BasicBlockMatchesPie3dPanel(diff, false);
        this.jumpsPiePanel = new JumpMatchesPie3dPanel(diff, false);
        this.instructionsPiePanel = new InstructionMatchesPie3dPanel(diff, false);
        this.similarityBarChartPanel = new SimilarityBarChart2dPanel(diff.getMetadata());
        this.matchedFunctionsTableModel = new MatchedFunctionsViewsTableModel(diff, true);
        this.matchedFunctionsTable = new MatchedFunctionViewsTable(this.matchedFunctionsTableModel, workspaceTabPanelFunctions);
        this.filterPanel = new MatchedFunctionViewsFilterPanel(this.matchedFunctionsTable);
        this.callerAndCalleesPanel = new AddedAndRemovedCalledFunctionsPanel(diff, workspaceTabPanelFunctions, this.matchedFunctionsTable);
        this.filterPanel.addListener(this.filterCheckboxListener);
        this.matchedFunctionsTable.addListener(this.tableListener);
        this.matchedFunctionsTableModel.addListener(this.tableListener);
        diff.getMetadata().addListener(this.countsChangeListener);
        this.initComponents();
        this.updateCharts(this.matchedFunctionsTable);
    }

    private JPanel createOverviewPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(new CompoundBorder(new TitledBorder("Overview"), new LineBorder(Color.GRAY)));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4, 0, 0));
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add(this.basicBlocksPiePanel);
        jPanel2.add(this.jumpsPiePanel);
        jPanel2.add(this.instructionsPiePanel);
        jPanel2.add(this.similarityBarChartPanel);
        return jPanel;
    }

    private JPanel createTablePanel() {
        JScrollPane jScrollPane = new JScrollPane(this.matchedFunctionsTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void initComponents() {
        this.tablePanel.setBorder(new TitledBorder(""));
        this.overviewPanel = this.createOverviewPanel();
        this.updateBorderTitle();
        JSplitPane jSplitPane = new JSplitPane(0, true);
        jSplitPane.setBorder(null);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(200);
        JSplitPane jSplitPane2 = new JSplitPane(0, true);
        jSplitPane2.setBorder(null);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setResizeWeight(1.0);
        jSplitPane2.setDividerLocation(0.7);
        this.tablePanel.add((Component)this.filterPanel, "North");
        this.tablePanel.add((Component)this.createTablePanel(), "Center");
        jSplitPane.setTopComponent(this.overviewPanel);
        jSplitPane.setBottomComponent(jSplitPane2);
        jSplitPane2.setTopComponent(this.tablePanel);
        jSplitPane2.setBottomComponent(this.callerAndCalleesPanel);
        this.add((Component)jSplitPane, "Center");
    }

    private void updateBorderTitle() {
        ((TitledBorder)this.tablePanel.getBorder()).setTitle(String.format("%d / %d Matched Functions", this.matchedFunctionsTable.getRowCount(), this.diff.getMatches().getSizeOfMatchedFunctions()));
        this.updateUI();
    }

    private void updateCharts(MatchedFunctionViewsTable matchedFunctionViewsTable) {
        int n2;
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        int[] nArray = matchedFunctionViewsTable.getSelectedRows();
        if (nArray.length == 0) {
            nArray = new int[matchedFunctionViewsTable.getRowCount()];
            for (n2 = 0; n2 < matchedFunctionViewsTable.getRowCount(); ++n2) {
                nArray[n2] = n2;
            }
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int n11 : nArray) {
            String string = (String)matchedFunctionViewsTable.getValueAt(n11, matchedFunctionViewsTable.convertColumnIndexToView(3));
            CAddress cAddress = new CAddress(string, 16);
            String string2 = (String)matchedFunctionViewsTable.getValueAt(n11, matchedFunctionViewsTable.convertColumnIndexToView(6));
            CAddress cAddress2 = new CAddress(string2, 16);
            RawFunction rawFunction = this.diff.getFunction(cAddress, ESide.PRIMARY);
            RawFunction rawFunction2 = this.diff.getFunction(cAddress2, ESide.SECONDARY);
            n2 += rawFunction.getSizeOfMatchedBasicBlocks();
            n3 += rawFunction.getSizeOfUnmatchedBasicBlocks();
            n4 += rawFunction2.getSizeOfUnmatchedBasicBlocks();
            n5 += rawFunction.getSizeOfMatchedJumps();
            n6 += rawFunction.getSizeOfUnmatchedJumps();
            n7 += rawFunction2.getSizeOfUnmatchedJumps();
            n8 += rawFunction.getSizeOfMatchedInstructions();
            n9 += rawFunction.getSizeOfUnmatchedInstructions();
            n10 += rawFunction2.getSizeOfUnmatchedInstructions();
            FunctionMatchData functionMatchData = rawFunction.getFunctionMatch();
            vector.add(functionMatchData.getSimilarity());
            vector2.add(functionMatchData.getConfidence());
        }
        this.basicBlocksPiePanel.updateDataset(n2, n3, n4);
        this.jumpsPiePanel.updateDataset(n5, n6, n7);
        this.instructionsPiePanel.updateDataset(n8, n9, n10);
        this.similarityBarChartPanel.updateDataset(vector);
    }

    public void dispose() {
        this.matchedFunctionsTable.removeListener(this.tableListener);
        this.filterPanel.removeListener(this.filterCheckboxListener);
        this.matchedFunctionsTable.dispose();
        this.diff.getMetadata().removeListener(this.countsChangeListener);
    }

    @Override
    public List<AbstractTable> getTables() {
        ArrayList<AbstractTable> arrayList = new ArrayList<AbstractTable>();
        arrayList.add(this.matchedFunctionsTable);
        return arrayList;
    }

    private class InternalViewsTableListener
    implements IMatchedFunctionsViewsTableListener {
        private InternalViewsTableListener() {
        }

        @Override
        public void rowSelectionChanged(MatchedFunctionViewsTable matchedFunctionViewsTable) {
            MatchedFunctionsTreeNodeContextPanel.this.updateCharts(MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable);
        }

        @Override
        public void tableDataChanged(MatchedFunctionsViewsTableModel matchedFunctionsViewsTableModel) {
            MatchedFunctionsTreeNodeContextPanel.this.updateCharts(MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable);
            MatchedFunctionsTreeNodeContextPanel.this.updateBorderTitle();
        }
    }

    private class InternalFlowGraphCachedCountsListener
    extends CountsChangedListener {
        private InternalFlowGraphCachedCountsListener() {
        }

        @Override
        public void basicBlocksCountChanged() {
            MatchedFunctionsTreeNodeContextPanel.this.updateCharts(MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable);
        }

        @Override
        public void callsCountChanged() {
            MatchedFunctionsTreeNodeContextPanel.this.updateCharts(MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable);
        }

        @Override
        public void instructionsCountsChanged() {
            MatchedFunctionsTreeNodeContextPanel.this.updateCharts(MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable);
        }

        @Override
        public void jumpsCountChanged() {
            MatchedFunctionsTreeNodeContextPanel.this.updateCharts(MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable);
        }
    }

    private class InternalFilterCheckboxListener
    implements IViewsFilterCheckboxListener {
        private InternalFilterCheckboxListener() {
        }

        @Override
        public void functionViewsFilterChanged(boolean bl2, boolean bl3, boolean bl4) {
            RawCallGraph rawCallGraph = MatchedFunctionsTreeNodeContextPanel.this.diff.getCallGraph(ESide.PRIMARY);
            RawCallGraph rawCallGraph2 = MatchedFunctionsTreeNodeContextPanel.this.diff.getCallGraph(ESide.SECONDARY);
            HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
            if (!(bl2 || bl3 || bl4)) {
                hashSet.addAll(GraphGetter.getMatchedFunctionPairs(rawCallGraph, rawCallGraph2));
            } else {
                if (bl2) {
                    hashSet.addAll(GraphGetter.getStructuralChangedFunctionPairs(rawCallGraph, rawCallGraph2));
                }
                if (bl3) {
                    hashSet.addAll(GraphGetter.getInstructionOnlyChangedFunctionPairs(rawCallGraph, rawCallGraph2));
                }
                if (bl4) {
                    hashSet.addAll(GraphGetter.getIdenticalFunctionPairs(rawCallGraph, rawCallGraph2));
                }
            }
            ((MatchedFunctionsViewsTableModel)MatchedFunctionsTreeNodeContextPanel.this.matchedFunctionsTable.getTableModel()).setMatchedFunctionPairs(hashSet);
        }
    }
}

