/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.AbstractTreeNodeContextPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsContainerTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsContainerTableModel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FunctionDiffViewsContainerNodeContextPanel
extends AbstractTreeNodeContextPanel {
    private final FunctionDiffViewsContainerTable allFunctionDiffsViewsTable;
    private final TableModelListener tableModelListener = new InternalTableModelListener();

    public FunctionDiffViewsContainerNodeContextPanel(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        List<Diff> list = Preconditions.checkNotNull(workspaceTabPanelFunctions).getWorkspace().getDiffList(true);
        FunctionDiffViewsContainerTableModel functionDiffViewsContainerTableModel = new FunctionDiffViewsContainerTableModel(list);
        this.allFunctionDiffsViewsTable = new FunctionDiffViewsContainerTable(functionDiffViewsContainerTableModel, workspaceTabPanelFunctions);
        functionDiffViewsContainerTableModel.addTableModelListener(this.tableModelListener);
        this.init();
    }

    private JPanel createTablePanel() {
        JScrollPane jScrollPane = new JScrollPane(this.allFunctionDiffsViewsTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void init() {
        this.setBorder(new TitledBorder(""));
        this.add((Component)this.createTablePanel(), "Center");
        this.updateBorderTitle();
    }

    private void updateBorderTitle() {
        ((TitledBorder)this.getBorder()).setTitle(String.format("%d Single Function Diff Views", this.allFunctionDiffsViewsTable.getRowCount()));
    }

    public void dispose() {
        this.allFunctionDiffsViewsTable.getTableModel().removeTableModelListener(this.tableModelListener);
    }

    @Override
    public List<AbstractTable> getTables() {
        ArrayList<AbstractTable> arrayList = new ArrayList<AbstractTable>();
        arrayList.add(this.allFunctionDiffsViewsTable);
        return arrayList;
    }

    private class InternalTableModelListener
    implements TableModelListener {
        private InternalTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            FunctionDiffViewsContainerNodeContextPanel.this.updateBorderTitle();
        }
    }
}

