/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.AbstractTreeNodeContextPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.FunctionMatchesPie3dPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.charts.SimilarityBarChart2dPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers.PercentageTwoBarCellData;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.renderers.PercentageTwoBarLabel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CPathLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class DiffTreeNodeContextPanel
extends AbstractTreeNodeContextPanel {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final int TEXTFIELD_HEIGHT = 25;
    private static final int TEXTFIELD_LABEL_WIDTH = 100;
    private final InternalDescriptionFocusListener focusListener = new InternalDescriptionFocusListener();
    private final InternalKeyListener keyListener = new InternalKeyListener();
    private final InternalTimerListener timerListener = new InternalTimerListener();
    private final CPathLabel diffPath;
    private final JTextField creationDate;
    private final JTextField primaryIDBName;
    private final JTextField primaryImageName;
    private final JTextField primaryImageHash;
    private final JTextField primaryArchitectureName;
    private final JTextField secondaryIDBName;
    private final JTextField secondaryImageName;
    private final JTextField secondaryImageHash;
    private final JTextField secondaryArchitectureName;
    private final JTextArea description;
    private final PercentageTwoBarLabel primaryFunctions;
    private final PercentageTwoBarLabel secondaryFunctions;
    private final Timer timer = new Timer(3500, this.timerListener);
    private final Diff diff;
    private final TitledBorder descriptionBorder = new TitledBorder("Description");
    private final WorkspaceTabPanelFunctions controller;

    public DiffTreeNodeContextPanel(Diff diff, WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.diff = Preconditions.checkNotNull(diff);
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        DiffMetadata diffMetadata = diff.getMetadata();
        this.creationDate = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getDateString()));
        this.primaryIDBName = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getIdbName(ESide.PRIMARY)));
        this.primaryImageName = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getImageName(ESide.PRIMARY)));
        this.primaryImageHash = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getImageHash(ESide.PRIMARY)));
        this.primaryArchitectureName = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getArchitectureName(ESide.PRIMARY)));
        this.secondaryIDBName = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getIdbName(ESide.SECONDARY)));
        this.secondaryImageName = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getImageName(ESide.SECONDARY)));
        this.secondaryImageHash = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getImageHash(ESide.SECONDARY)));
        this.secondaryArchitectureName = TextComponentUtils.addDefaultEditorActions(new JTextField(diffMetadata.getArchitectureName(ESide.SECONDARY)));
        int n2 = diffMetadata.getSizeOfMatchedFunctions();
        PercentageTwoBarCellData percentageTwoBarCellData = new PercentageTwoBarCellData(n2, diffMetadata.getSizeOfUnmatchedFunctions(ESide.PRIMARY));
        PercentageTwoBarCellData percentageTwoBarCellData2 = new PercentageTwoBarCellData(n2, diffMetadata.getSizeOfUnmatchedFunctions(ESide.SECONDARY));
        this.primaryFunctions = new PercentageTwoBarLabel(percentageTwoBarCellData, Colors.MATCHED_LABEL_BAR, Colors.UNMATCHED_PRIMARY_LABEL_BAR, 25);
        this.secondaryFunctions = new PercentageTwoBarLabel(percentageTwoBarCellData2, Colors.MATCHED_LABEL_BAR, Colors.UNMATCHED_SECONDARY_LABEL_BAR, 25);
        this.diffPath = new CPathLabel(diff.getMatchesDatabase().getPath());
        this.description = new JTextArea(diffMetadata.getDiffDescription());
        this.description.addFocusListener(this.focusListener);
        this.description.addKeyListener(this.keyListener);
        this.initComponents();
        this.loadDescription();
    }

    private JPanel createDescriptionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.descriptionBorder);
        jPanel.add((Component)new JScrollPane(this.description), "Center");
        return jPanel;
    }

    private JPanel createDiffInfoPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 2, 2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(5, 1, 2, 2));
        JPanel jPanel5 = new JPanel(new GridLayout(5, 1, 2, 2));
        jPanel2.setBorder(new TitledBorder("Primary Image"));
        jPanel3.setBorder(new TitledBorder("Secondary Image"));
        jPanel4.setBorder(new LineBorder(Color.GRAY));
        jPanel5.setBorder(new LineBorder(Color.GRAY));
        jPanel4.setBackground(Color.WHITE);
        jPanel5.setBackground(Color.WHITE);
        jPanel4.add(GuiUtils.createHorizontalNamedLabelPanel("IDB Name", 100, this.primaryIDBName, 25));
        jPanel4.add(GuiUtils.createHorizontalNamedLabelPanel("Image Name", 100, this.primaryImageName, 25));
        jPanel4.add(GuiUtils.createHorizontalNamedLabelPanel("Hash", 100, this.primaryImageHash, 25));
        jPanel4.add(GuiUtils.createHorizontalNamedLabelPanel("Architecture", 100, this.primaryArchitectureName, 25));
        jPanel4.add(GuiUtils.createHorizontalNamedLabelPanel("Functions", 100, this.primaryFunctions, 25));
        jPanel5.add(GuiUtils.createHorizontalNamedLabelPanel("IDB Name", 100, this.secondaryIDBName, 25));
        jPanel5.add(GuiUtils.createHorizontalNamedLabelPanel("Image Name", 100, this.secondaryImageName, 25));
        jPanel5.add(GuiUtils.createHorizontalNamedLabelPanel("Hash", 100, this.secondaryImageHash, 25));
        jPanel5.add(GuiUtils.createHorizontalNamedLabelPanel("Architecture", 100, this.secondaryArchitectureName, 25));
        jPanel5.add(GuiUtils.createHorizontalNamedLabelPanel("Functions", 100, this.secondaryFunctions, 25));
        jPanel2.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel5, "Center");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createOverviewPanel() {
        DiffMetadata diffMetadata = this.diff.getMetadata();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(new CompoundBorder(new TitledBorder("Overview"), new LineBorder(Color.GRAY)));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add(new FunctionMatchesPie3dPanel(diffMetadata));
        jPanel2.add(new SimilarityBarChart2dPanel(diffMetadata));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 2, 2));
        jPanel3.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.add(GuiUtils.createHorizontalNamedLabelPanel("Diff Path", 100, this.diffPath, 25));
        jPanel3.add(GuiUtils.createHorizontalNamedLabelPanel("File Date", 100, this.creationDate, 25));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new TitledBorder("Diff Info"));
        jPanel4.add((Component)jPanel3, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "Center");
        jPanel5.add((Component)jPanel4, "South");
        return jPanel5;
    }

    private void initComponents() {
        this.diffPath.setPreferredSize(new Dimension(this.diffPath.getPreferredSize().width, 25));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createOverviewPanel(), "Center");
        jPanel.add((Component)this.createDiffInfoPanel(), "South");
        this.add((Component)jPanel, "North");
        this.add((Component)this.createDescriptionPanel(), "Center");
    }

    private void loadDescription() {
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(this.diff.getMatchesDatabase());){
            this.description.setText(matchesDatabase.loadDiffDescription());
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Load diff description failed");
        }
    }

    private void saveDescription() {
        if (this.controller.saveDescription(this.diff, this.description.getText())) {
            this.descriptionBorder.setTitleColor(Colors.JUMP_CONDITIONAL_FALSE);
            this.descriptionBorder.setTitle("Saved description");
            this.updateUI();
            this.timer.start();
        }
    }

    public void dispose() {
        this.description.removeFocusListener(this.focusListener);
        this.description.removeKeyListener(this.keyListener);
    }

    @Override
    public List<AbstractTable> getTables() {
        return null;
    }

    private final class InternalTimerListener
    implements ActionListener {
        private InternalTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DiffTreeNodeContextPanel.this.descriptionBorder.setTitleColor(Color.BLACK);
            DiffTreeNodeContextPanel.this.descriptionBorder.setTitle("Description");
            DiffTreeNodeContextPanel.this.updateUI();
            DiffTreeNodeContextPanel.this.timer.stop();
        }
    }

    private final class InternalKeyListener
    implements KeyListener {
        private static final int KEY_TYPED_SAVE_THRESHOLD = 50;
        private int typedCount = 0;

        private InternalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            ++this.typedCount;
            if (this.typedCount > 50) {
                DiffTreeNodeContextPanel.this.saveDescription();
                this.typedCount = 0;
            }
        }
    }

    private class InternalDescriptionFocusListener
    implements FocusListener {
        private InternalDescriptionFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            DiffTreeNodeContextPanel.this.saveDescription();
        }
    }
}

