/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.popupmenu;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.CloseDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.CloseViewsAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.DeleteDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.LoadDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.IWorkspaceTreeListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.AbstractTreeNode;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffListenerAdapter;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class NodePopupMenu
extends JPopupMenu {
    private final WorkspaceTabPanelFunctions controller;
    private final JMenuItem openDiff;
    private final JMenuItem closeDiff;
    private final JMenuItem deleteDiff;
    private final JMenuItem closeViews;
    private final InternalWorkspaceTreeListener workspaceTreeListener = new InternalWorkspaceTreeListener();
    private final InternalDiffListener diffListener = new InternalDiffListener();
    private Diff lastSelectedDiff = null;

    public NodePopupMenu(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.openDiff = GuiUtils.buildMenuItem("Open Diff", new LoadDiffAction(workspaceTabPanelFunctions));
        this.closeDiff = GuiUtils.buildMenuItem("Close Diff", new CloseDiffAction(workspaceTabPanelFunctions));
        this.deleteDiff = GuiUtils.buildMenuItem("Delete Diff", new DeleteDiffAction(workspaceTabPanelFunctions));
        this.closeViews = GuiUtils.buildMenuItem("Close Views", new CloseViewsAction(workspaceTabPanelFunctions));
        this.add(this.openDiff);
        this.add(this.closeDiff);
        this.add(new JSeparator());
        this.add(this.deleteDiff);
        this.add(new JSeparator());
        this.add(this.closeViews);
        this.openDiff.setEnabled(true);
        this.closeDiff.setEnabled(false);
        this.closeViews.setEnabled(false);
        this.controller.getWorkspaceTree().addListener(this.workspaceTreeListener);
    }

    private void registerCurrentDiffListener(Diff diff) {
        this.unregisterCurrentDiffListener();
        this.lastSelectedDiff = diff;
        this.lastSelectedDiff.addListener(this.diffListener);
    }

    private void unregisterCurrentDiffListener() {
        if (this.lastSelectedDiff != null) {
            this.lastSelectedDiff.removeListener(this.diffListener);
            this.lastSelectedDiff = null;
        }
    }

    private void updateMenu(Diff diff) {
        this.openDiff.setEnabled(!diff.isLoaded());
        this.closeDiff.setEnabled(diff.isLoaded());
        this.deleteDiff.setEnabled(true);
        HashSet<Diff> hashSet = new HashSet<Diff>();
        hashSet.add(diff);
        this.closeViews.setEnabled(this.controller.getOpenViews(hashSet).size() > 0);
    }

    public void dispose() {
        this.unregisterCurrentDiffListener();
        this.controller.getWorkspaceTree().removeListener(this.workspaceTreeListener);
    }

    private class InternalWorkspaceTreeListener
    implements IWorkspaceTreeListener {
        private InternalWorkspaceTreeListener() {
        }

        @Override
        public void changedSelection(AbstractTreeNode abstractTreeNode) {
            Diff diff = abstractTreeNode.getDiff();
            if (diff == null) {
                NodePopupMenu.this.openDiff.setEnabled(false);
                NodePopupMenu.this.closeDiff.setEnabled(false);
                NodePopupMenu.this.deleteDiff.setEnabled(false);
                NodePopupMenu.this.closeViews.setEnabled(false);
                NodePopupMenu.this.unregisterCurrentDiffListener();
            } else {
                NodePopupMenu.this.updateMenu(diff);
                NodePopupMenu.this.registerCurrentDiffListener(diff);
            }
        }
    }

    private class InternalDiffListener
    extends DiffListenerAdapter {
        private InternalDiffListener() {
        }

        @Override
        public void closedView(Diff diff) {
            NodePopupMenu.this.updateMenu(diff);
        }

        @Override
        public void loadedDiff(Diff diff) {
            NodePopupMenu.this.updateMenu(diff);
            if (diff.getMatches() == null) {
                NodePopupMenu.this.openDiff.setEnabled(false);
            }
        }

        @Override
        public void loadedView(Diff diff) {
            NodePopupMenu.this.updateMenu(diff);
        }

        @Override
        public void removedDiff(Diff diff) {
            NodePopupMenu.this.updateMenu(diff);
            NodePopupMenu.this.unregisterCurrentDiffListener();
            NodePopupMenu.this.controller.getWorkspaceTree().removeListener(NodePopupMenu.this.workspaceTreeListener);
        }

        @Override
        public void unloadedDiff(Diff diff) {
            NodePopupMenu.this.updateMenu(diff);
        }
    }
}

