/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.popupmenu;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.AddDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.NewDiffAction;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceAdapter;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class NoNodePopupMenu
extends JPopupMenu {
    private final WorkspaceTabPanelFunctions controller;
    private final JMenuItem newDiff;
    private final JMenuItem addDiff;
    private final InternalWorkspaceListener workspaceListener = new InternalWorkspaceListener();

    public NoNodePopupMenu(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.newDiff = GuiUtils.buildMenuItem("New Diff...", 'N', (AbstractAction)new NewDiffAction(workspaceTabPanelFunctions));
        this.addDiff = GuiUtils.buildMenuItem("Add Existing Diff...", 'A', (AbstractAction)new AddDiffAction(workspaceTabPanelFunctions));
        this.add(this.newDiff);
        this.add(this.addDiff);
        this.enableMenu(false);
        workspaceTabPanelFunctions.getWorkspace().addListener(this.workspaceListener);
    }

    private void enableMenu(boolean bl2) {
        this.newDiff.setEnabled(bl2);
        this.addDiff.setEnabled(bl2);
    }

    public void dispose() {
        this.controller.getWorkspace().addListener(this.workspaceListener);
    }

    private class InternalWorkspaceListener
    extends WorkspaceAdapter {
        private InternalWorkspaceListener() {
        }

        @Override
        public void closedWorkspace() {
            NoNodePopupMenu.this.enableMenu(false);
        }

        @Override
        public void loadedWorkspace(Workspace workspace) {
            NoNodePopupMenu.this.enableMenu(true);
        }
    }
}

