/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.popupmenu;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.CloseFunctionDiffsAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.CloseFunctionDiffsViewsAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.LoadFunctionDiffsAction;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class FunctionDiffContainerNodePopupMenu
extends JPopupMenu {
    public FunctionDiffContainerNodePopupMenu(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.add(GuiUtils.buildMenuItem("Open Function Diffs", new LoadFunctionDiffsAction(workspaceTabPanelFunctions), this.isOpenDiffsEnabled(workspaceTabPanelFunctions)));
        this.add(GuiUtils.buildMenuItem("Close Function Diffs", new CloseFunctionDiffsAction(workspaceTabPanelFunctions), this.isCloseDiffsEnabled(workspaceTabPanelFunctions)));
        this.add(new JSeparator());
        this.add(GuiUtils.buildMenuItem("Close Function Diff Views", new CloseFunctionDiffsViewsAction(workspaceTabPanelFunctions), this.isCloseViewsEnabled(workspaceTabPanelFunctions)));
    }

    private boolean isCloseDiffsEnabled(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        for (Diff diff : workspaceTabPanelFunctions.getWorkspace().getDiffList(true)) {
            if (!diff.isLoaded()) continue;
            return true;
        }
        return false;
    }

    private boolean isCloseViewsEnabled(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        TabPanelManager tabPanelManager = workspaceTabPanelFunctions.getMainWindow().getController().getTabPanelManager();
        return tabPanelManager.getViewTabPanels(true).size() > 0;
    }

    private boolean isOpenDiffsEnabled(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        for (Diff diff : workspaceTabPanelFunctions.getWorkspace().getDiffList(true)) {
            if (diff.isLoaded()) continue;
            return true;
        }
        return false;
    }
}

