/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.IWorkspaceTreeListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.WorkspaceTreeModel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.popupmenu.NoNodePopupMenu;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.AbstractTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.AllFunctionDiffViewsNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.FunctionDiffViewsNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.NodeRenderer;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.RootNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.FunctionDiffViewsNodeContextPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsContainerTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.FunctionDiffViewsTable;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceAdapter;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WorkspaceTree
extends JTree {
    private final JPopupMenu popup;
    private final WorkspaceTreeModel workspaceTreeModel;
    private final RootNode rootNode;
    private final WorkspaceTabPanelFunctions controller;
    private final InternalTreeSelectionListener treeSelectionListener = new InternalTreeSelectionListener();
    private final InternalMouseListener mouseListener = new InternalMouseListener();
    private final InternalWorkspaceModelListener mainWindowModelListener = new InternalWorkspaceModelListener();
    private final ListenerProvider<IWorkspaceTreeListener> listeners = new ListenerProvider();

    public WorkspaceTree(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.controller.setWorkspaceTree(this);
        this.rootNode = new RootNode(this, this.controller);
        this.popup = new NoNodePopupMenu(this.controller);
        this.setRootVisible(false);
        this.workspaceTreeModel = new WorkspaceTreeModel(this, this.rootNode);
        this.setModel(this.workspaceTreeModel);
        this.setCellRenderer(new NodeRenderer());
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultTreeSelectionModel);
        this.setBorder(new EmptyBorder(2, 4, 2, 2));
        this.addTreeSelectionListener(this.treeSelectionListener);
        this.addMouseListener(this.mouseListener);
        this.controller.getWorkspace().addListener(this.mainWindowModelListener);
    }

    public static boolean hasFunctionDiffRelatives(WorkspaceTree workspaceTree, Diff diff) {
        if (!diff.isFunctionDiff()) {
            return false;
        }
        TreeNode treeNode = workspaceTree.getModel().getRoot().getChildAt(0);
        if (treeNode.isLeaf()) {
            return false;
        }
        File file = diff.getMatchesDatabase().getParentFile();
        for (int i2 = 0; i2 < treeNode.getChildCount(); ++i2) {
            FunctionDiffViewsNode functionDiffViewsNode = (FunctionDiffViewsNode)treeNode.getChildAt(i2);
            FunctionDiffViewsNodeContextPanel functionDiffViewsNodeContextPanel = functionDiffViewsNode.getComponent();
            FunctionDiffViewsTable functionDiffViewsTable = (FunctionDiffViewsTable)functionDiffViewsNodeContextPanel.getTables().get(0);
            if (functionDiffViewsTable.getRowCount() <= 0 || !file.equals(AbstractTable.getRowDiff(functionDiffViewsTable, 0).getMatchesDatabase().getParentFile())) continue;
            return true;
        }
        return false;
    }

    private void handleDoubleClick(MouseEvent mouseEvent) {
        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)TreeHelpers.getNodeAt(this, mouseEvent.getX(), mouseEvent.getY());
        if (abstractTreeNode == null) {
            return;
        }
        abstractTreeNode.doubleClicked();
    }

    private void nodeSelected(AbstractTreeNode abstractTreeNode) {
        this.controller.setTreeNodeContextComponent(abstractTreeNode.getComponent());
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)TreeHelpers.getNodeAt(this, mouseEvent.getX(), mouseEvent.getY());
        if (abstractTreeNode != null) {
            this.setSelectionPath(new TreePath(abstractTreeNode.getPath()));
            JPopupMenu jPopupMenu = abstractTreeNode.getPopupMenu();
            if (jPopupMenu != null) {
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void addListener(IWorkspaceTreeListener iWorkspaceTreeListener) {
        this.listeners.addListener(iWorkspaceTreeListener);
    }

    public void closeFunctionDiffs() {
        AllFunctionDiffViewsNode allFunctionDiffViewsNode = (AllFunctionDiffViewsNode)this.rootNode.getFirstChild();
        allFunctionDiffViewsNode.deleteChildren();
        this.updateTree();
    }

    public void dispose() {
        this.removeTreeSelectionListener(this.treeSelectionListener);
        this.removeMouseListener(this.mouseListener);
        this.controller.getWorkspace().removeListener(this.mainWindowModelListener);
    }

    @Override
    public WorkspaceTreeModel getModel() {
        return this.workspaceTreeModel;
    }

    public void removeListener(IWorkspaceTreeListener iWorkspaceTreeListener) {
        this.listeners.removeListener(iWorkspaceTreeListener);
    }

    public void updateTree() {
        this.getModel().nodeStructureChanged(this.rootNode);
    }

    private class InternalWorkspaceModelListener
    extends WorkspaceAdapter {
        private InternalWorkspaceModelListener() {
        }

        @Override
        public void addedDiff(Diff diff) {
            if (!diff.isFunctionDiff()) {
                WorkspaceTree.this.rootNode.addDiff(diff);
                WorkspaceTree.this.updateTree();
            } else {
                AllFunctionDiffViewsNode allFunctionDiffViewsNode = (AllFunctionDiffViewsNode)WorkspaceTree.this.rootNode.getFirstChild();
                ((FunctionDiffViewsContainerTable)allFunctionDiffViewsNode.getComponent().getTables().get(0)).addRow(diff);
                TreePath treePath = new TreePath(allFunctionDiffViewsNode.getPath());
                boolean bl2 = WorkspaceTree.this.isExpanded(treePath);
                TreePath treePath2 = WorkspaceTree.this.getSelectionPath();
                allFunctionDiffViewsNode.addDiff(diff);
                WorkspaceTree.this.updateTree();
                for (int i2 = 0; i2 < allFunctionDiffViewsNode.getChildCount(); ++i2) {
                    FunctionDiffViewsNode functionDiffViewsNode = (FunctionDiffViewsNode)allFunctionDiffViewsNode.getChildAt(i2);
                    if (!functionDiffViewsNode.getViewDirectory().equals(diff.getMatchesDatabase().getParentFile())) continue;
                    ((FunctionDiffViewsTable)functionDiffViewsNode.getComponent().getTables().get(0)).addRow(diff);
                    break;
                }
                if (bl2) {
                    WorkspaceTree.this.expandPath(new TreePath(allFunctionDiffViewsNode.getPath()));
                }
                WorkspaceTree.this.setSelectionPath(treePath2);
            }
        }

        @Override
        public void closedWorkspace() {
            WorkspaceTree.this.rootNode.deleteChildren();
            TreePath treePath = new TreePath(WorkspaceTree.this.rootNode.getPath());
            WorkspaceTree.this.getSelectionModel().setSelectionPath(treePath);
            WorkspaceTree.this.updateTree();
        }

        @Override
        public void loadedWorkspace(Workspace workspace) {
            WorkspaceTree.this.rootNode.setWorkspace(workspace);
            WorkspaceTree.this.getModel().nodeStructureChanged(WorkspaceTree.this.rootNode);
        }

        @Override
        public void removedDiff(Diff diff) {
            if (diff.isFunctionDiff()) {
                FunctionDiffViewsNode functionDiffViewsNode;
                int n2;
                AllFunctionDiffViewsNode allFunctionDiffViewsNode = (AllFunctionDiffViewsNode)WorkspaceTree.this.rootNode.getFirstChild();
                FunctionDiffViewsContainerTable functionDiffViewsContainerTable = (FunctionDiffViewsContainerTable)allFunctionDiffViewsNode.getComponent().getTables().get(0);
                functionDiffViewsContainerTable.removeRow(diff);
                for (n2 = 0; n2 < allFunctionDiffViewsNode.getChildCount(); ++n2) {
                    functionDiffViewsNode = (FunctionDiffViewsNode)allFunctionDiffViewsNode.getChildAt(n2);
                    if (!functionDiffViewsNode.getViewDirectory().equals(diff.getMatchesDatabase().getParentFile())) continue;
                    ((FunctionDiffViewsTable)functionDiffViewsNode.getComponent().getTables().get(0)).removeRow(diff);
                    break;
                }
                for (n2 = 0; n2 < allFunctionDiffViewsNode.getChildCount(); ++n2) {
                    functionDiffViewsNode = (FunctionDiffViewsNode)allFunctionDiffViewsNode.getChildAt(n2);
                    if (!functionDiffViewsNode.getViewDirectory().equals(diff.getMatchesDatabase().getParentFile())) continue;
                    ((FunctionDiffViewsTable)functionDiffViewsNode.getComponent().getTables().get(0)).addRow(diff);
                    break;
                }
            }
        }
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private DefaultMutableTreeNode lastNode = null;

        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)WorkspaceTree.this.getLastSelectedPathComponent();
            if (abstractTreeNode != null) {
                WorkspaceTree.this.nodeSelected(abstractTreeNode);
                this.lastNode = abstractTreeNode;
            } else if (this.lastNode == null || !TreeHelpers.isAncestor(this.lastNode, WorkspaceTree.this.rootNode)) {
                WorkspaceTree.this.nodeSelected(WorkspaceTree.this.rootNode);
            }
            for (IWorkspaceTreeListener iWorkspaceTreeListener : WorkspaceTree.this.listeners) {
                iWorkspaceTreeListener.changedSelection(abstractTreeNode != null ? abstractTreeNode : WorkspaceTree.this.rootNode);
            }
        }
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                WorkspaceTree.this.showPopupMenu(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2) {
                WorkspaceTree.this.handleDoubleClick(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                WorkspaceTree.this.showPopupMenu(mouseEvent);
            }
        }
    }
}

