/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.menubar;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceAdapter;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public final class WorkspaceMenu
extends JMenu {
    public static final int MAX_RECENT = 4;
    private final List<String> recentWorkspaces = new ArrayList<String>(4);
    private final WorkspaceTabPanelFunctions controller;
    private final InternalWorkspaceListener workspaceModelListener = new InternalWorkspaceListener();
    private JMenuItem newWorkspace;
    private JMenuItem loadWorkspace;
    private JMenuItem closeWorkspace;
    private JMenuItem exit;

    public WorkspaceMenu(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        super("File");
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.setMnemonic('F');
        this.loadRecentWorkspacesFromConfig();
        this.initItems();
        workspaceTabPanelFunctions.getWorkspace().addListener(this.workspaceModelListener);
        this.enableSubmenus(false);
    }

    private void addRecentWorkspaces() {
        boolean bl2 = true;
        for (final String string : this.recentWorkspaces) {
            if (string.isEmpty()) continue;
            if (bl2) {
                this.add(new JSeparator());
                bl2 = false;
            }
            JMenuItem jMenuItem = GuiUtils.buildMenuItem(this.minimizeWorkspacePath(string), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WorkspaceMenu.this.controller.closeWorkspace();
                    WorkspaceMenu.this.controller.loadWorkspace(string);
                }
            });
            this.add(jMenuItem);
        }
    }

    private void addSubmenuEntries() {
        this.add(this.newWorkspace);
        this.add(this.loadWorkspace);
        this.add(this.closeWorkspace);
        this.addRecentWorkspaces();
        this.add(new JSeparator());
        this.add(this.exit);
    }

    private void initItems() {
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newWorkspace = GuiUtils.buildMenuItem("New Workspace...", 'N', 78, n2 | 1, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkspaceMenu.this.controller.newWorkspace();
            }
        });
        this.loadWorkspace = GuiUtils.buildMenuItem("Open Workspace...", 'O', 79, n2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkspaceMenu.this.controller.loadWorkspace();
            }
        });
        this.closeWorkspace = GuiUtils.buildMenuItem("Close Workspace", 'W', 87, n2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkspaceMenu.this.controller.closeWorkspace();
            }
        });
        this.exit = GuiUtils.buildMenuItem("Exit", 'Q', 81, n2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkspaceMenu.this.controller.exitBinDiff();
            }
        });
        this.addSubmenuEntries();
    }

    private void loadRecentWorkspacesFromConfig() {
        GeneralSettingsConfigItem generalSettingsConfigItem = BinDiffConfig.getInstance().getMainSettings();
        for (String string : generalSettingsConfigItem.getRecentWorkspaceDirectories()) {
            if (!new File(string).isFile()) continue;
            this.recentWorkspaces.add(string);
        }
    }

    private String minimizeWorkspacePath(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        StringBuilder stringBuilder = new StringBuilder(file.getPath());
        if (string2.length() > 25) {
            stringBuilder = new StringBuilder(string2.substring(0, 3));
            stringBuilder.append("...");
            stringBuilder.append(string2, string2.length() - 20, string2.length());
            stringBuilder.append(File.separator);
            stringBuilder.append(file.getName());
        }
        return stringBuilder.toString();
    }

    private void updateWorkspaceMenu() {
        this.removeAll();
        this.addSubmenuEntries();
    }

    public void dispose() {
        this.controller.getWorkspace().removeListener(this.workspaceModelListener);
    }

    public void enableSubmenus(boolean bl2) {
        this.closeWorkspace.setEnabled(bl2);
    }

    public String[] getRecentWorkspaces() {
        return this.recentWorkspaces.toArray(new String[0]);
    }

    private class InternalWorkspaceListener
    extends WorkspaceAdapter {
        private InternalWorkspaceListener() {
        }

        @Override
        public void closedWorkspace() {
            WorkspaceMenu.this.enableSubmenus(false);
        }

        @Override
        public void loadedWorkspace(Workspace workspace) {
            WorkspaceMenu.this.enableSubmenus(true);
            String string = workspace.getWorkspaceFilePath();
            if (string.isEmpty()) {
                return;
            }
            int n2 = WorkspaceMenu.this.recentWorkspaces.indexOf(string);
            if (n2 >= 0) {
                String string2 = (String)WorkspaceMenu.this.recentWorkspaces.get(0);
                WorkspaceMenu.this.recentWorkspaces.set(0, (String)WorkspaceMenu.this.recentWorkspaces.get(n2));
                WorkspaceMenu.this.recentWorkspaces.set(n2, string2);
            } else {
                if (!WorkspaceMenu.this.recentWorkspaces.isEmpty()) {
                    WorkspaceMenu.this.recentWorkspaces.remove(WorkspaceMenu.this.recentWorkspaces.size() - 1);
                }
                WorkspaceMenu.this.recentWorkspaces.add(0, string);
            }
            WorkspaceMenu.this.updateWorkspaceMenu();
        }
    }
}

