/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.menubar;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.AddDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.CloseDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.DeleteDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.DirectoryDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.LoadDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.NewDiffAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.IWorkspaceTreeListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.AbstractTreeNode;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceAdapter;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffListenerAdapter;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class DiffMenu
extends JMenu {
    private final JMenuItem newDiff;
    private final JMenuItem dirDiff;
    private final JMenuItem addDiff;
    private final JMenuItem openDiff;
    private final JMenuItem closeDiff;
    private final JMenuItem deleteDiff;
    private final InternalWorkspaceTreeListener workspaceTreeListener = new InternalWorkspaceTreeListener();
    private final InternalWorkspaceListener workspaceListener = new InternalWorkspaceListener();
    private final InternalDiffListener diffListener = new InternalDiffListener();
    private final WorkspaceTabPanelFunctions controller;
    private Diff lastSelectedDiff = null;

    public DiffMenu(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        super("Diffs");
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.setMnemonic('D');
        this.setEnabled(false);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newDiff = GuiUtils.buildMenuItem("New Diff...", 'N', 78, n2, new NewDiffAction(workspaceTabPanelFunctions));
        this.addDiff = GuiUtils.buildMenuItem("Add Existing Diff...", 'A', 65, n2, new AddDiffAction(workspaceTabPanelFunctions));
        this.dirDiff = GuiUtils.buildMenuItem("New Directory Diff...", 'N', (AbstractAction)new DirectoryDiffAction(workspaceTabPanelFunctions));
        this.openDiff = GuiUtils.buildMenuItem("Open Diff", 'O', (AbstractAction)new LoadDiffAction(workspaceTabPanelFunctions));
        this.closeDiff = GuiUtils.buildMenuItem("Close Diff", 'C', (AbstractAction)new CloseDiffAction(workspaceTabPanelFunctions));
        this.deleteDiff = GuiUtils.buildMenuItem("Delete Diff", 'D', (AbstractAction)new DeleteDiffAction(workspaceTabPanelFunctions));
        this.add(this.newDiff);
        this.add(this.addDiff);
        this.add(this.dirDiff);
        this.add(new JSeparator());
        this.add(this.openDiff);
        this.add(this.closeDiff);
        this.add(new JSeparator());
        this.add(this.deleteDiff);
        workspaceTabPanelFunctions.getWorkspace().addListener(this.workspaceListener);
        workspaceTabPanelFunctions.getWorkspaceTree().addListener(this.workspaceTreeListener);
    }

    private void registerCurrentDiffListener(Diff diff) {
        this.unregisterCurrentDiffListener();
        this.lastSelectedDiff = diff;
        this.lastSelectedDiff.addListener(this.diffListener);
        this.unregisterCurrentDiffListener();
    }

    private void unregisterCurrentDiffListener() {
        if (this.lastSelectedDiff != null) {
            this.lastSelectedDiff.removeListener(this.diffListener);
            this.lastSelectedDiff = null;
        }
    }

    private class InternalWorkspaceTreeListener
    implements IWorkspaceTreeListener {
        private InternalWorkspaceTreeListener() {
        }

        @Override
        public void changedSelection(AbstractTreeNode abstractTreeNode) {
            Diff diff = abstractTreeNode.getDiff();
            if (diff == null) {
                DiffMenu.this.newDiff.setEnabled(true);
                DiffMenu.this.addDiff.setEnabled(true);
                DiffMenu.this.openDiff.setEnabled(false);
                DiffMenu.this.closeDiff.setEnabled(false);
                DiffMenu.this.deleteDiff.setEnabled(false);
                DiffMenu.this.unregisterCurrentDiffListener();
            } else {
                DiffMenu.this.openDiff.setEnabled(!diff.isLoaded());
                DiffMenu.this.closeDiff.setEnabled(diff.isLoaded());
                DiffMenu.this.deleteDiff.setEnabled(diff.isLoaded());
                DiffMenu.this.registerCurrentDiffListener(diff);
            }
        }
    }

    private class InternalWorkspaceListener
    extends WorkspaceAdapter {
        private InternalWorkspaceListener() {
        }

        @Override
        public void closedWorkspace() {
            DiffMenu.this.setEnabled(false);
            DiffMenu.this.unregisterCurrentDiffListener();
        }

        @Override
        public void loadedWorkspace(Workspace workspace) {
            DiffMenu.this.setEnabled(true);
            DiffMenu.this.newDiff.setEnabled(true);
            DiffMenu.this.addDiff.setEnabled(true);
            DiffMenu.this.openDiff.setEnabled(false);
            DiffMenu.this.closeDiff.setEnabled(false);
            DiffMenu.this.deleteDiff.setEnabled(false);
        }
    }

    private class InternalDiffListener
    extends DiffListenerAdapter {
        private InternalDiffListener() {
        }

        @Override
        public void loadedDiff(Diff diff) {
            DiffMenu.this.openDiff.setEnabled(!diff.isLoaded());
            DiffMenu.this.closeDiff.setEnabled(diff.isLoaded());
        }

        @Override
        public void removedDiff(Diff diff) {
            DiffMenu.this.controller.getWorkspaceTree().removeListener(DiffMenu.this.workspaceTreeListener);
        }

        @Override
        public void unloadedDiff(Diff diff) {
            DiffMenu.this.openDiff.setEnabled(!diff.isLoaded());
            DiffMenu.this.closeDiff.setEnabled(diff.isLoaded());
        }
    }
}

