/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.implementations;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.ByteStreams;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.exceptions.BinExportException;
import com.google.security.zynamics.bindiff.exceptions.DifferException;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.processes.DiffProcess;
import com.google.security.zynamics.bindiff.processes.ExportProcess;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.diff.DiffLoader;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.bindiff.utils.ExternalAppUtils;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;

public final class NewDiffImplementation
extends CEndlessHelperThread {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final MainWindow parentWindow;
    private final Workspace workspace;
    private File primaryBinExportFile;
    private File secondaryBinExportFile;
    private final File primaryIdbFile;
    private final File secondaryIdbFile;
    private final File destinationDirectory;

    public NewDiffImplementation(MainWindow mainWindow, Workspace workspace, File file, File file2, File file3, File file4, File file5) {
        this.parentWindow = Preconditions.checkNotNull(mainWindow);
        this.workspace = Preconditions.checkNotNull(workspace);
        this.destinationDirectory = Preconditions.checkNotNull(file5);
        this.primaryIdbFile = file;
        this.secondaryIdbFile = file2;
        this.primaryBinExportFile = file3;
        this.secondaryBinExportFile = file4;
    }

    private String createUniqueExportFileName(ESide eSide) {
        String string = "";
        if (this.primaryBinExportFile != null) {
            string = this.primaryBinExportFile.getName();
        } else if (this.primaryIdbFile != null) {
            string = this.primaryIdbFile.getName();
        }
        string = BinDiffFileUtils.removeFileExtension(string);
        String string2 = "";
        if (this.secondaryBinExportFile != null) {
            string2 = this.secondaryBinExportFile.getName();
        } else if (this.secondaryIdbFile != null) {
            string2 = this.secondaryIdbFile.getName();
        }
        string2 = BinDiffFileUtils.removeFileExtension(string2);
        if (string.equals(string2)) {
            string = string + "_primary";
            string2 = string2 + "_secondary";
        }
        string = BinDiffFileUtils.forceFilenameEndsWithExtension(string, "BinExport");
        string2 = BinDiffFileUtils.forceFilenameEndsWithExtension(string2, "BinExport");
        return eSide == ESide.PRIMARY ? string : string2;
    }

    @Override
    protected void runExpensiveCommand() {
        this.newDiff();
    }

    public String createNewDiff() {
        try {
            Object object;
            this.setDescription("Creating destination directory...");
            if (!this.destinationDirectory.isDirectory() && !this.destinationDirectory.mkdirs()) {
                logger.at(Level.SEVERE).log("Could not create destination directory");
                CMessageBox.showError(this.parentWindow, "Could not create destination directory.");
                return null;
            }
            String string = this.createUniqueExportFileName(ESide.PRIMARY);
            String string2 = this.createUniqueExportFileName(ESide.SECONDARY);
            if (this.primaryIdbFile != null) {
                try {
                    logger.at(Level.INFO).log("- Exporting primary IDB '%s' to '%s'", (Object)this.primaryIdbFile.getPath(), (Object)this.destinationDirectory.getPath());
                    this.setDescription("Exporting primary IDB...");
                    object = ExternalAppUtils.getIdaExe(this.primaryIdbFile);
                    if (object == null || !((File)object).canExecute()) {
                        String string3 = "Can't start disassembler. Please set correct path in the main settings first.";
                        logger.at(Level.SEVERE).log("Can't start disassembler. Please set correct path in the main settings first.");
                        CMessageBox.showError(this.parentWindow, "Can't start disassembler. Please set correct path in the main settings first.");
                        return null;
                    }
                    ExportProcess.startExportProcess((File)object, this.destinationDirectory, this.primaryIdbFile, string);
                }
                catch (BinExportException binExportException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(binExportException)).log(binExportException.getMessage());
                    CMessageBox.showError(this.parentWindow, binExportException.getMessage());
                    try {
                        BinDiffFileUtils.deleteDirectory(this.destinationDirectory);
                    }
                    catch (IOException iOException) {
                        ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Couldn't delete diff folder '%s' after diffing failed", this.destinationDirectory.getPath());
                        CMessageBox.showWarning(this.parentWindow, String.format("Couldn't delete diff folder '%s' after diffing failed.\nPlease delete this folder manually.", this.destinationDirectory.getPath()));
                    }
                    return null;
                }
            }
            if (this.primaryBinExportFile != null) {
                try {
                    object = new File(String.format("%s%s%s", this.destinationDirectory.getPath(), File.separator, string));
                    if (!((File)object).exists()) {
                        this.setDescription("Copying primary BinExport binary...");
                        ByteStreams.copy(new FileInputStream(this.primaryBinExportFile), new FileOutputStream((File)object));
                    }
                    this.primaryBinExportFile = object;
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("New Diff failed. Couldn't copy already exported primary binaries into the new diff directory.");
                    CMessageBox.showError(this.parentWindow, "New Diff failed. Couldn't copy already exported primary binaries into the new diff directory.");
                    try {
                        BinDiffFileUtils.deleteDirectory(this.destinationDirectory);
                    }
                    catch (IOException iOException2) {
                        ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException2)).log("Couldn't delete diff folder '%s' after diffing failed", this.destinationDirectory.getPath());
                        CMessageBox.showWarning(this.parentWindow, String.format("Couldn't delete diff folder '%s' after diffing failed.\nPlease delete this folder manually.", this.destinationDirectory.getPath()));
                    }
                    return null;
                }
            }
            if (this.secondaryIdbFile != null) {
                try {
                    logger.at(Level.INFO).log("- Exporting secondary IDB '%s' to '%s'", (Object)this.secondaryIdbFile.getPath(), (Object)this.destinationDirectory.getPath());
                    this.setDescription("Exporting secondary IDB...");
                    object = ExternalAppUtils.getIdaExe(this.secondaryIdbFile);
                    if (object == null || !((File)object).canExecute()) {
                        String string4 = "Can't start disassembler. Please set correct path in the main settings first.";
                        logger.at(Level.SEVERE).log("Can't start disassembler. Please set correct path in the main settings first.");
                        CMessageBox.showError(this.parentWindow, "Can't start disassembler. Please set correct path in the main settings first.");
                        return null;
                    }
                    ExportProcess.startExportProcess((File)object, this.destinationDirectory, this.secondaryIdbFile, string2);
                }
                catch (BinExportException binExportException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(binExportException)).log(binExportException.getMessage());
                    CMessageBox.showError(this.parentWindow, binExportException.getMessage());
                    try {
                        BinDiffFileUtils.deleteDirectory(this.destinationDirectory);
                    }
                    catch (IOException iOException) {
                        ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Couldn't delete diff folder '%s' after exporting failed", this.destinationDirectory.getPath());
                        CMessageBox.showWarning(this.parentWindow, String.format("Couldn't delete diff folder '%s' after exporting failed.\nPlease delete this folder manually.", this.destinationDirectory.getPath()));
                    }
                    return null;
                }
            }
            if (this.secondaryBinExportFile != null) {
                try {
                    object = new File(String.format("%s%s%s", this.destinationDirectory.getPath(), File.separator, string2));
                    if (!((File)object).exists()) {
                        this.setDescription("Copying primary BinExport binary...");
                        ByteStreams.copy(new FileInputStream(this.secondaryBinExportFile), new FileOutputStream((File)object));
                    }
                    this.secondaryBinExportFile = object;
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("New Diff failed. Couldn't copy secondary BinExport binaries into the new diff directory.");
                    CMessageBox.showError(this.parentWindow, "New Diff failed. Couldn't copy secondary BinExport binaries into the new diff directory.");
                    try {
                        BinDiffFileUtils.deleteDirectory(this.destinationDirectory);
                    }
                    catch (IOException iOException3) {
                        ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException3)).log("Couldn't delete diff folder '%s' after exporting failed", this.destinationDirectory.getPath());
                        CMessageBox.showWarning(this.parentWindow, String.format("Couldn't delete diff folder '%s' after exporting failed.\nPlease delete this folder manually.", this.destinationDirectory.getPath()));
                    }
                    return null;
                }
            }
            try {
                object = ExternalAppUtils.getCommandLineDiffer();
                String string5 = "";
                string5 = this.primaryIdbFile != null ? ExportProcess.getExportFilename(string, this.destinationDirectory) : this.primaryBinExportFile.getPath();
                String string6 = "";
                string6 = this.secondaryIdbFile != null ? ExportProcess.getExportFilename(string2, this.destinationDirectory) : this.secondaryBinExportFile.getPath();
                logger.at(Level.INFO).log("- Diffing '%s'", this.destinationDirectory.getName());
                this.setDescription("Diffing...");
                DiffProcess.startDiffProcess((String)object, string5, string6, this.destinationDirectory);
                String string7 = DiffProcess.getBinDiffFilename(string5, string6);
                logger.at(Level.INFO).log("- Diffing done successfully");
                return string7;
            }
            catch (DifferException differException) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(differException)).log(differException.getMessage());
                CMessageBox.showError(this.parentWindow, differException.getMessage());
                return null;
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("New Diff failed..");
            CMessageBox.showError(this.parentWindow, "New Diff failed.");
            return null;
        }
    }

    public void newDiff() {
        try {
            String string = this.createNewDiff();
            if (string == null) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                this.setDescription("Preloading Diff...");
                DiffMetadata diffMetadata = DiffLoader.preloadDiffMatches(file);
                this.setDescription("Adding Diff to workspace...");
                this.workspace.addDiff(file, diffMetadata, false);
            } else {
                logger.at(Level.SEVERE).log("Create and add new Diff to workspace failed. Diff binary does not exist.");
                CMessageBox.showError(this.parentWindow, "Adding new Diff to workspace failed. Diff binary does not exist.");
            }
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("New Diff failed. Couldn't read matches database.");
            CMessageBox.showError(this.parentWindow, "New Diff failed. Couldn't read matches database: " + sQLException.getMessage());
        }
    }
}

