/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.implementations;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.exceptions.BinExportException;
import com.google.security.zynamics.bindiff.exceptions.DifferException;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DiffPairTableData;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.processes.DiffProcess;
import com.google.security.zynamics.bindiff.processes.ExportProcess;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.diff.DiffLoader;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.bindiff.utils.ExternalAppUtils;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DirectoryDiffImplementation
extends CEndlessHelperThread {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final List<String> diffingErrorMessages = new ArrayList<String>();
    private final List<String> openingDiffErrorMessages = new ArrayList<String>();
    private final MainWindow parentWindow;
    private final Workspace workspace;
    private final String primarySourcePath;
    private final String secondarySourcePath;
    private final List<DiffPairTableData> idbPairs;

    public DirectoryDiffImplementation(MainWindow mainWindow, Workspace workspace, String string, String string2, List<DiffPairTableData> list) {
        this.parentWindow = Preconditions.checkNotNull(mainWindow);
        this.workspace = Preconditions.checkNotNull(workspace);
        this.primarySourcePath = Preconditions.checkNotNull(string);
        this.secondarySourcePath = Preconditions.checkNotNull(string2);
        this.idbPairs = Preconditions.checkNotNull(list);
    }

    private String createUniqueExportFileName(File file, File file2, ESide eSide) {
        String string;
        String string2 = FileUtils.getFileBasename(file);
        if (string2.equals(string = FileUtils.getFileBasename(file2))) {
            string2 = string2 + "_primary";
            string = string + "_secondary";
        }
        string2 = BinDiffFileUtils.forceFilenameEndsWithExtension(string2, "BinExport");
        string = BinDiffFileUtils.forceFilenameEndsWithExtension(string, "BinExport");
        return eSide == ESide.PRIMARY ? string2 : string;
    }

    private void deleteDirectory(MainWindow mainWindow, File file) {
        try {
            BinDiffFileUtils.deleteDirectory(file);
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Couldn't delete diff folder '%s' after exporting failed", file.getPath());
            CMessageBox.showWarning(mainWindow, String.format("Couldn't delete diff folder '%s' after exporting failed.\nPlease delete this folder manually.", file.getPath()));
        }
    }

    private List<String> directoryDiff() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ExternalAppUtils.getCommandLineDiffer();
        if (!new File(string).exists()) {
            String string2 = String.format("Can't start directory diff. Couldn't find engine at '%s'", string);
            logger.at(Level.SEVERE).log(string2);
            CMessageBox.showError(this.parentWindow, string2);
            return arrayList;
        }
        logger.at(Level.INFO).log("Start Directory Diff '%s' vs '%s'", (Object)this.primarySourcePath, (Object)this.secondarySourcePath);
        String string3 = this.workspace.getWorkspaceDir().getPath();
        for (DiffPairTableData diffPairTableData : this.idbPairs) {
            String string4;
            Object object;
            String string5 = String.join((CharSequence)File.separator, string3, diffPairTableData.getDestinationDirectory());
            String string6 = String.join((CharSequence)File.separator, this.primarySourcePath, diffPairTableData.getIDBLocation(), diffPairTableData.getIDBName());
            String string7 = String.join((CharSequence)File.separator, this.secondarySourcePath, diffPairTableData.getIDBLocation(), diffPairTableData.getIDBName());
            this.setDescription(String.format("%s vs %s", diffPairTableData.getIDBName(), diffPairTableData.getIDBName()));
            File file = new File(string6);
            File file2 = new File(string7);
            String string8 = this.createUniqueExportFileName(file, file2, ESide.PRIMARY);
            String string9 = this.createUniqueExportFileName(file, file2, ESide.SECONDARY);
            File file3 = new File(string5);
            if (file3.exists()) {
                object = String.format("'%s' failed. Reason: Destination folder already exists.", diffPairTableData.getDestinationDirectory());
                this.diffingErrorMessages.add((String)object);
                continue;
            }
            if (!file3.mkdir()) {
                object = String.format("'%s' failed. Reason: Destination folder cannot be created.", diffPairTableData.getDestinationDirectory());
                this.diffingErrorMessages.add((String)object);
                continue;
            }
            try {
                logger.at(Level.INFO).log(" - Start exporting primary IDB '%s' to '%s'", (Object)string6, (Object)string5);
                object = ExternalAppUtils.getIdaExe(file);
                if (object == null || !((File)object).canExecute()) {
                    string4 = "Can't start disassembler. Please set correct path in the main settings first.";
                    logger.at(Level.SEVERE).log("Can't start disassembler. Please set correct path in the main settings first.");
                    CMessageBox.showError(this.parentWindow, "Can't start disassembler. Please set correct path in the main settings first.");
                    this.deleteDirectory(this.parentWindow, file3);
                    return arrayList;
                }
                ExportProcess.startExportProcess((File)object, file3, file, string8);
                logger.at(Level.INFO).log(" - Finished exporting primary IDB '%s' to '%s' successfully", (Object)string6, (Object)string5);
            }
            catch (BinExportException binExportException) {
                logger.at(Level.INFO).log(" - Exporting primary '%s' to '%s' failed. Reason: %s", string6, string5, binExportException.getMessage());
                string4 = String.format("Exporting primary '%s' failed. Reason: %s", string6, binExportException.getMessage());
                this.diffingErrorMessages.add(string4);
                this.deleteDirectory(this.parentWindow, file3);
                continue;
            }
            try {
                logger.at(Level.INFO).log(" - Start exporting secondary IDB '%s' to '%s'", (Object)string7, (Object)string5);
                object = ExternalAppUtils.getIdaExe(file2);
                if (object == null || !((File)object).canExecute()) {
                    string4 = "Can't start disassembler. Please set correct path in the main settings first.";
                    logger.at(Level.SEVERE).log("Can't start disassembler. Please set correct path in the main settings first.");
                    CMessageBox.showError(this.parentWindow, "Can't start disassembler. Please set correct path in the main settings first.");
                    return arrayList;
                }
                ExportProcess.startExportProcess((File)object, file3, file2, string9);
                logger.at(Level.INFO).log(" - Finished exporting secondary IDB '%s' to '%s' successfully", (Object)string7, (Object)string5);
            }
            catch (BinExportException binExportException) {
                logger.at(Level.WARNING).log(" - Exporting secondary '%s' to '%s' failed. Reason: %s", string7, string5, binExportException.getMessage());
                string4 = String.format("Exporting secondary '%s' failed. Reason: %s", string7, binExportException.getMessage());
                this.diffingErrorMessages.add(string4);
                this.deleteDirectory(this.parentWindow, file3);
                continue;
            }
            try {
                object = ExportProcess.getExportFilename(string8, file3);
                string4 = ExportProcess.getExportFilename(string9, file3);
                logger.at(Level.INFO).log(" - Start diffing '%s'", file3.getName());
                DiffProcess.startDiffProcess(string, (String)object, string4, file3);
                String string10 = DiffProcess.getBinDiffFilename((String)object, string4);
                logger.at(Level.INFO).log(" - Diffing '%s' done successfully", file3.getName());
                arrayList.add(string10);
            }
            catch (DifferException differException) {
                logger.at(Level.WARNING).log(" - Diffing '%s' failed. Reason: %s", (Object)file3.getName(), (Object)differException.getMessage());
                string4 = String.format("Diffing '%s' failed. Reason: %s", diffPairTableData.getDestinationDirectory(), differException.getMessage());
                this.diffingErrorMessages.add(string4);
            }
        }
        if (this.diffingErrorMessages.size() == 0) {
            logger.at(Level.INFO).log("Finished Directory Diff '%s' vs '%s' successfully", (Object)this.primarySourcePath, (Object)this.secondarySourcePath);
        } else {
            logger.at(Level.WARNING).log("Finished Directory Diff '%s' vs '%s' with errors.", (Object)this.primarySourcePath, (Object)this.secondarySourcePath);
        }
        return arrayList;
    }

    @Override
    protected void runExpensiveCommand() {
        List<String> list = this.directoryDiff();
        if (list.size() > 0) {
            this.setGeneralDescription("Preloading diffs...");
        }
        for (String string : list) {
            if (string == null) continue;
            File file = new File(string);
            try {
                this.setDescription(String.format("Loading '%s'", file.getName()));
                if (!file.exists()) continue;
                DiffMetadata diffMetadata = DiffLoader.preloadDiffMatches(file);
                this.workspace.addDiff(file, diffMetadata, false);
            }
            catch (Exception exception) {
                String string2 = String.format("Could not load '%s' into workspace.", file.getName());
                this.openingDiffErrorMessages.add(string2);
            }
        }
    }

    public List<String> getDiffingErrorMessages() {
        return this.diffingErrorMessages;
    }

    public List<String> getOpeningDiffErrorMessages() {
        return this.openingDiffErrorMessages;
    }
}

