/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.Triple;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;

public class OpenMultipeFlowGraphsViewsAction
extends AbstractAction {
    private static final int OPEN_VIEWS_WARNING_THRESHOLD = 10;
    private final AbstractTable table;

    public OpenMultipeFlowGraphsViewsAction(AbstractTable abstractTable) {
        this.table = Preconditions.checkNotNull(abstractTable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Diff diff;
        int n2;
        int n3;
        WorkspaceTabPanelFunctions workspaceTabPanelFunctions = this.table.getController();
        LinkedHashSet<Triple<Diff, IAddress, IAddress>> linkedHashSet = new LinkedHashSet<Triple<Diff, IAddress, IAddress>>();
        int[] nArray = this.table.getSelectedRows();
        LinkedHashSet<Diff> linkedHashSet2 = new LinkedHashSet<Diff>();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            diff = AbstractTable.getRowDiff(this.table, n2);
            if (diff.isLoaded()) continue;
            linkedHashSet2.add(diff);
        }
        workspaceTabPanelFunctions.loadFunctionDiffs(linkedHashSet2);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            diff = AbstractTable.getRowDiff(this.table, n2);
            Pair<IAddress, IAddress> pair = AbstractTable.getViewAddressPair(this.table, n2);
            linkedHashSet.add(Triple.make(diff, pair.first(), pair.second()));
        }
        n3 = 0;
        if (linkedHashSet.size() > 10) {
            n3 = CMessageBox.showYesNoQuestion(workspaceTabPanelFunctions.getMainWindow(), String.format("This operation will open more than %d views. Continue?", 10));
        }
        if (n3 == 0) {
            workspaceTabPanelFunctions.openFlowGraphViews(workspaceTabPanelFunctions.getMainWindow(), linkedHashSet);
        }
    }
}

