/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;

public class CloseViewsAction
extends AbstractAction {
    private final WorkspaceTabPanelFunctions controller;
    private final AbstractTable table;

    public CloseViewsAction(AbstractTable abstractTable, int n2) {
        this.table = Preconditions.checkNotNull(abstractTable);
        this.controller = abstractTable.getController();
    }

    public CloseViewsAction(WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
        this.table = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.table == null) {
            Diff diff = this.controller.getSelectedDiff();
            HashSet<Diff> hashSet = new HashSet<Diff>();
            if (diff != null) {
                hashSet.add(diff);
            }
            this.controller.closeViews(this.controller.getOpenViews(hashSet));
        } else {
            HashSet<ViewTabPanel> hashSet = new HashSet<ViewTabPanel>();
            Diff diff = this.table.getDiff();
            boolean bl2 = diff == null;
            for (int n2 : this.table.getSelectedRows()) {
                TabPanelManager tabPanelManager;
                ViewTabPanel viewTabPanel;
                Pair<IAddress, IAddress> pair;
                if (bl2) {
                    diff = AbstractTable.getRowDiff(this.table, n2);
                }
                if ((pair = AbstractTable.getViewAddressPair(this.table, n2)) == null || (viewTabPanel = (tabPanelManager = this.controller.getMainWindow().getController().getTabPanelManager()).getTabPanel(pair.first(), pair.second(), diff)) == null) continue;
                hashSet.add(viewTabPanel);
            }
            this.controller.closeViews(hashSet);
        }
    }
}

