/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.ByteStreams;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.gui.dialogs.AddDiffDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.NewDiffDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.NewWorkspaceDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.ProgressDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DiffPairTableData;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DirectoryDiffDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.InitialCallGraphSettingsDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.InitialFlowGraphSettingsDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.MainSettingsDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.detachedviewstabpanel.FunctionDiffViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.implementations.DirectoryDiffImplementation;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.implementations.NewDiffImplementation;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.WorkspaceTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.AbstractTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.AllFunctionDiffViewsNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.projecttree.treenodes.FunctionDiffViewsNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.io.matches.DiffRequestMessage;
import com.google.security.zynamics.bindiff.project.IWorkspaceListener;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceLoader;
import com.google.security.zynamics.bindiff.project.diff.CallGraphViewLoader;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffLoader;
import com.google.security.zynamics.bindiff.project.diff.FlowGraphViewLoader;
import com.google.security.zynamics.bindiff.project.diff.FunctionDiffViewLoader;
import com.google.security.zynamics.bindiff.project.diff.IDiffListener;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.userview.CallGraphViewData;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.Triple;
import com.google.security.zynamics.zylib.gui.CFileChooser;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CUnlimitedProgressDialog;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public final class WorkspaceTabPanelFunctions
extends TabPanelFunctions {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private MainSettingsDialog mainSettingsDialog = null;
    private InitialCallGraphSettingsDialog callGraphSettingsDialog = null;
    private InitialFlowGraphSettingsDialog flowGraphSettingsDialog = null;
    private WorkspaceTree workspaceTree;

    public WorkspaceTabPanelFunctions(MainWindow mainWindow, Workspace workspace) {
        super(mainWindow, workspace);
    }

    private boolean closeViews(List<ViewTabPanel> list, List<ViewTabPanel> list2) {
        for (ViewTabPanel viewTabPanel : list) {
            viewTabPanel.getController().getTabPanelManager().getTabbedPane().setSelectedComponent(viewTabPanel);
            Diff diff = viewTabPanel.getDiff();
            int n2 = CMessageBox.showYesNoCancelQuestion(this.getMainWindow(), String.format("Save %s '%s'?", diff.isFunctionDiff() ? "Function Diff View" : "Diff View", viewTabPanel.getView().getViewName()));
            switch (n2) {
                case 0: {
                    if (viewTabPanel.getController().closeView(true)) break;
                    return false;
                }
                case 1: {
                    list2.add(viewTabPanel);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        for (ViewTabPanel viewTabPanel : list2) {
            viewTabPanel.getController().closeView(false);
        }
        return true;
    }

    private File copyFileIntoNewDiffDir(File file, File file2) {
        String string = String.format("%s%s%s", file, File.separator, file2.getName());
        File file3 = new File(string);
        ByteStreams.copy(new FileInputStream(file2), new FileOutputStream(file3));
        return file3;
    }

    private boolean deleteDiff(Diff diff, boolean bl2) {
        this.removeDiffFromWorkspace(diff);
        if (bl2) {
            try {
                if (!diff.isFunctionDiff()) {
                    BinDiffFileUtils.deleteDirectory(new File(diff.getDiffFolder()));
                } else if (!this.deleteFunctionDiff(diff)) {
                    CMessageBox.showError(this.getMainWindow(), String.format("Couldn't delete '%s'.", diff.getMatchesDatabase().toString()));
                }
            }
            catch (IOException iOException) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Delete diff failed. Couldn't delete diff folder.");
                CMessageBox.showError(this.getMainWindow(), "Delete diff failed. Couldn't delete diff folder.");
                return false;
            }
        }
        return true;
    }

    private boolean deleteFunctionDiff(Diff diff) {
        if (diff.getMatchesDatabase().delete()) {
            File file = diff.getMatchesDatabase().getParentFile();
            File file2 = diff.getExportFile(ESide.PRIMARY);
            File file3 = diff.getExportFile(ESide.SECONDARY);
            boolean bl2 = true;
            boolean bl3 = true;
            for (Diff object : this.getWorkspace().getDiffList(true)) {
                if (!file.equals(object.getMatchesDatabase().getParentFile())) continue;
                if (object.getExportFile(ESide.PRIMARY).equals(file2)) {
                    bl2 = false;
                }
                if (!object.getExportFile(ESide.SECONDARY).equals(file3)) continue;
                bl3 = false;
            }
            if (bl2 && !file2.delete()) {
                return false;
            }
            if (bl3 && !file3.delete()) {
                return false;
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length == 0) {
                Serializable serializable;
                AllFunctionDiffViewsNode allFunctionDiffViewsNode = (AllFunctionDiffViewsNode)this.workspaceTree.getModel().getRoot().getChildAt(0);
                int n2 = -1;
                for (int functionDiffViewsNode = 0; functionDiffViewsNode < allFunctionDiffViewsNode.getChildCount(); ++functionDiffViewsNode) {
                    serializable = (FunctionDiffViewsNode)allFunctionDiffViewsNode.getChildAt(functionDiffViewsNode);
                    if (!serializable.getViewDirectory().equals(file)) continue;
                    n2 = functionDiffViewsNode;
                    serializable.delete();
                    allFunctionDiffViewsNode.remove(functionDiffViewsNode);
                    this.workspaceTree.updateTree();
                }
                if (n2 == allFunctionDiffViewsNode.getChildCount()) {
                    --n2;
                }
                if (n2 > -1) {
                    FunctionDiffViewsNode functionDiffViewsNode = (FunctionDiffViewsNode)allFunctionDiffViewsNode.getChildAt(n2);
                    serializable = new TreePath(functionDiffViewsNode.getPath());
                    this.workspaceTree.expandPath((TreePath)serializable);
                    this.workspaceTree.setSelectionPath((TreePath)serializable);
                }
                return file.delete();
            }
            return true;
        }
        return false;
    }

    private MainWindow getParentWindow() {
        return (MainWindow)SwingUtilities.getWindowAncestor(this.workspaceTree);
    }

    private WorkspaceTabPanel getWorkspaceTabPanel() {
        return this.getMainWindow().getController().getTabPanelManager().getWorkspaceTabPanel();
    }

    private boolean isImportThunkView(Diff diff, IAddress iAddress, IAddress iAddress2, boolean bl2) {
        RawFunction rawFunction = diff.getCallGraph(ESide.PRIMARY).getFunction(iAddress);
        RawFunction rawFunction2 = diff.getCallGraph(ESide.SECONDARY).getFunction(iAddress2);
        if (rawFunction != null && rawFunction2 == null && rawFunction.getFunctionType() == EFunctionType.IMPORTED || rawFunction2 != null && rawFunction == null && rawFunction2.getFunctionType() == EFunctionType.IMPORTED) {
            if (bl2) {
                CMessageBox.showInformation(this.getMainWindow(), "Cannot open unmatched import thunk view since it doesn't contain any code.");
            }
            return true;
        }
        if (rawFunction != null && rawFunction.getFunctionType() == EFunctionType.IMPORTED && rawFunction2 != null && rawFunction2.getFunctionType() == EFunctionType.IMPORTED) {
            if (bl2) {
                CMessageBox.showInformation(this.getMainWindow(), "Cannot open matched import thunk view since it doesn't contain any code.");
            }
            return true;
        }
        return false;
    }

    private void loadWorkspace(File file, boolean bl2) {
        try {
            if (this.getWorkspace().isLoaded()) {
                this.getWorkspace().closeWorkspace();
            }
            Workspace workspace = this.getWorkspace();
            WorkspaceLoader workspaceLoader = new WorkspaceLoader(file, workspace);
            if (bl2) {
                ProgressDialog.show((Window)this.getMainWindow(), String.format("Loading Workspace '%s'", file.getName()), workspaceLoader);
            } else {
                workspaceLoader.loadMetaData();
            }
            String string = workspaceLoader.getErrorMessage();
            if (!"".equals(string)) {
                logger.at(Level.SEVERE).log(string);
                CMessageBox.showError(this.getMainWindow(), string);
            } else {
                this.getWorkspace().saveWorkspace();
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Load workspace failed. %s", exception.getMessage());
            CMessageBox.showError(this.getMainWindow(), String.format("Load workspace failed. %s", exception.getMessage()));
        }
    }

    private void removeDiffFromWorkspace(Diff diff) {
        assert (diff != null);
        HashSet<Diff> hashSet = new HashSet<Diff>();
        hashSet.add(diff);
        this.getWorkspace().getDiffList().remove(diff);
        this.closeDiffs(hashSet);
        diff.removeDiff();
        for (IWorkspaceListener iWorkspaceListener : this.getWorkspace().getListeners()) {
            iWorkspaceListener.removedDiff(diff);
        }
        try {
            this.getWorkspace().saveWorkspace();
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Couldn't delete temporary files");
            CMessageBox.showError(this.getMainWindow(), "Couldn't delete temporary files: " + sQLException.getMessage());
        }
    }

    public void addDiff() {
        try {
            AddDiffDialog addDiffDialog = new AddDiffDialog((Window)this.getParentWindow(), this.getWorkspace());
            if (addDiffDialog.getAddButtonPressed()) {
                File file = addDiffDialog.getMatchesBinary();
                File file2 = addDiffDialog.getBinExportBinary(ESide.PRIMARY);
                File file3 = addDiffDialog.getBinExportBinary(ESide.SECONDARY);
                File file4 = addDiffDialog.getDestinationDirectory();
                File file5 = file;
                if (!file4.equals(file.getParentFile())) {
                    file4.mkdir();
                    file5 = this.copyFileIntoNewDiffDir(file4, file);
                    this.copyFileIntoNewDiffDir(file4, file2);
                    this.copyFileIntoNewDiffDir(file4, file3);
                }
                DiffMetadata diffMetadata = DiffLoader.preloadDiffMatches(file5);
                this.getWorkspace().addDiff(file5, diffMetadata, false);
            }
        }
        catch (IOException | SQLException exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Add diff failed. Couldn't add diff to workspace");
            CMessageBox.showError(this.getMainWindow(), "Add diff failed. Couldn't add diff to workspace: " + exception.getMessage());
        }
    }

    public void closeDialogs() {
        if (this.mainSettingsDialog != null) {
            this.mainSettingsDialog.dispose();
        }
        if (this.flowGraphSettingsDialog != null) {
            this.flowGraphSettingsDialog.dispose();
        }
        if (this.callGraphSettingsDialog != null) {
            this.callGraphSettingsDialog.dispose();
        }
    }

    public boolean closeDiffs(Set<Diff> set) {
        ArrayList<ViewTabPanel> arrayList = new ArrayList<ViewTabPanel>();
        ArrayList<ViewTabPanel> arrayList2 = new ArrayList<ViewTabPanel>();
        for (ViewTabPanel object : this.getOpenViews(set)) {
            if (object.getController().hasChanged()) {
                if (object.getDiff().isFunctionDiff()) {
                    arrayList.add(0, object);
                    continue;
                }
                arrayList.add(object);
                continue;
            }
            arrayList2.add(object);
        }
        if (this.closeViews(arrayList, arrayList2)) {
            for (Diff diff : set) {
                diff.closeDiff();
            }
            return true;
        }
        return false;
    }

    public void closeViews(Set<ViewTabPanel> set) {
        ArrayList<ViewTabPanel> arrayList = new ArrayList<ViewTabPanel>();
        ArrayList<ViewTabPanel> arrayList2 = new ArrayList<ViewTabPanel>();
        for (ViewTabPanel viewTabPanel : set) {
            if (viewTabPanel.getController().hasChanged()) {
                if (viewTabPanel.getDiff().isFunctionDiff()) {
                    arrayList.add(0, viewTabPanel);
                    continue;
                }
                arrayList.add(viewTabPanel);
                continue;
            }
            arrayList2.add(viewTabPanel);
        }
        this.closeViews(arrayList, arrayList2);
    }

    public boolean closeWorkspace() {
        HashSet<Diff> hashSet = new HashSet<Diff>();
        hashSet.addAll(this.getWorkspace().getDiffList());
        if (!this.closeDiffs(hashSet)) {
            return false;
        }
        this.getWorkspace().closeWorkspace();
        return true;
    }

    public boolean deleteDiff(Diff diff) {
        Diff diff2 = diff == null ? this.getSelectedDiff() : diff;
        Pair<Integer, Boolean> pair = CMessageBox.showYesNoQuestionWithCheckbox(this.getParentWindow(), String.format("Are you sure you want to remove '%s'?\n\n", diff2.getDiffName()), "Also delete diff contents on disk?");
        if (pair.first() != 0) {
            return false;
        }
        return this.deleteDiff(diff2, pair.second());
    }

    public boolean deleteFunctionDiffs(List<Diff> list) {
        int n2;
        if (list.isEmpty()) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Are you sure you want to delete this function diff views from disk?\n\n");
        int n3 = 0;
        for (Diff diff : list) {
            if (n3 != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(String.format("'%s'", diff.getDiffName()));
            if (n3++ != 4 || list.size() <= 5) continue;
            stringBuilder.append("\n...");
            break;
        }
        if ((n2 = CMessageBox.showYesNoQuestion(this.getParentWindow(), stringBuilder.toString())) == 0) {
            boolean bl2 = true;
            for (Diff diff : list) {
                boolean bl3 = this.deleteDiff(diff, true);
                if (!bl2) continue;
                bl2 = bl3;
            }
            return bl2;
        }
        return false;
    }

    public void directoryDiff() {
        Workspace workspace;
        String string;
        MainWindow mainWindow = this.getMainWindow();
        DirectoryDiffDialog directoryDiffDialog = new DirectoryDiffDialog((Window)mainWindow, new File(string = (workspace = this.getWorkspace()).getWorkspaceDir().getPath()));
        if (directoryDiffDialog.getDiffButtonPressed()) {
            StringBuilder stringBuilder;
            String string2 = directoryDiffDialog.getSourceBasePath(ESide.PRIMARY);
            String string3 = directoryDiffDialog.getSourceBasePath(ESide.SECONDARY);
            List<DiffPairTableData> list = directoryDiffDialog.getSelectedIdbPairs();
            DirectoryDiffImplementation directoryDiffImplementation = new DirectoryDiffImplementation(mainWindow, workspace, string2, string3, list);
            try {
                ProgressDialog.show((Window)mainWindow, "Directory Diffing...", directoryDiffImplementation);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Directory diffing was canceled because of an unexpected exception");
                CMessageBox.showError(mainWindow, "Directory diffing was canceled because of an unexpected exception!");
            }
            if (directoryDiffImplementation.getDiffingErrorMessages().size() != 0) {
                int n2 = 0;
                stringBuilder = new StringBuilder();
                for (String string4 : directoryDiffImplementation.getDiffingErrorMessages()) {
                    if (++n2 == 10) {
                        stringBuilder.append("...");
                        break;
                    }
                    stringBuilder.append(string4).append("\n");
                }
                CMessageBox.showError(mainWindow, stringBuilder.toString());
            }
            if (directoryDiffImplementation.getOpeningDiffErrorMessages().size() != 0) {
                int n3 = 0;
                stringBuilder = new StringBuilder();
                for (String string4 : directoryDiffImplementation.getOpeningDiffErrorMessages()) {
                    if (++n3 == 10) {
                        stringBuilder.append("...");
                        break;
                    }
                    stringBuilder.append(string4).append("\n");
                }
                CMessageBox.showError(mainWindow, stringBuilder.toString());
            }
        }
    }

    public LinkedHashSet<ViewTabPanel> getOpenViews(Set<Diff> set) {
        LinkedHashSet<ViewTabPanel> linkedHashSet = new LinkedHashSet<ViewTabPanel>();
        MainWindow mainWindow = this.getMainWindow();
        ArrayList<ViewTabPanel> arrayList = new ArrayList<ViewTabPanel>(mainWindow.getController().getTabPanelManager().getViewTabPanels());
        for (ViewTabPanel viewTabPanel : arrayList) {
            Diff diff = viewTabPanel.getDiff();
            if (!set.contains(diff)) continue;
            linkedHashSet.add(viewTabPanel);
        }
        return linkedHashSet;
    }

    public Diff getSelectedDiff() {
        TreePath treePath = this.getWorkspaceTree().getSelectionModel().getSelectionPath();
        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)treePath.getLastPathComponent();
        return abstractTreeNode.getDiff();
    }

    public WorkspaceTree getWorkspaceTree() {
        return this.workspaceTree;
    }

    public void loadDefaultWorkspace() {
        String string = BinDiffConfig.getInstance().getMainSettings().getDefaultWorkspace();
        if (string == null || "".equals(string)) {
            return;
        }
        File file = new File(string);
        if (file.exists() && file.canWrite()) {
            this.loadWorkspace(file, false);
        }
    }

    public void loadDiff(Diff diff) {
        if (diff == null) {
            diff = this.getSelectedDiff();
        }
        if (diff.isLoaded()) {
            return;
        }
        LinkedHashSet<Diff> linkedHashSet = new LinkedHashSet<Diff>();
        linkedHashSet.add(diff);
        DiffLoader diffLoader = new DiffLoader(linkedHashSet);
        CUnlimitedProgressDialog cUnlimitedProgressDialog = new CUnlimitedProgressDialog((Window)this.getParentWindow(), "BinDiff", String.format("Loading '%s'", diff.getDiffName()), diffLoader);
        diffLoader.setProgressDescriptionTarget(cUnlimitedProgressDialog);
        cUnlimitedProgressDialog.setVisible(true);
        Exception exception = cUnlimitedProgressDialog.getException();
        if (exception != null) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log(exception.getMessage());
            CMessageBox.showError(this.getMainWindow(), exception.getMessage());
        }
    }

    public void loadFunctionDiffs() {
        LinkedHashSet<Diff> linkedHashSet = new LinkedHashSet<Diff>();
        for (Diff diff : this.getWorkspace().getDiffList(true)) {
            if (diff.isLoaded()) continue;
            linkedHashSet.add(diff);
        }
        this.loadFunctionDiffs(linkedHashSet);
    }

    public void loadFunctionDiffs(LinkedHashSet<Diff> linkedHashSet) {
        DiffLoader diffLoader = new DiffLoader(linkedHashSet);
        CUnlimitedProgressDialog cUnlimitedProgressDialog = new CUnlimitedProgressDialog((Window)this.getParentWindow(), "BinDiff", "Loading Function Diffs", diffLoader);
        diffLoader.setProgressDescriptionTarget(cUnlimitedProgressDialog);
        cUnlimitedProgressDialog.setVisible(true);
        Exception exception = cUnlimitedProgressDialog.getException();
        if (exception != null) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log(exception.getMessage());
            CMessageBox.showError(this.getMainWindow(), exception.getMessage());
        }
    }

    public void loadWorkspace() {
        String string = BinDiffConfig.getInstance().getMainSettings().getWorkspaceDirectory();
        if ("".equals(string)) {
            BinDiffConfig.getInstance().getMainSettings().setWorkspaceDirectory(SystemHelpers.getUserDirectory());
        }
        File file = new File(BinDiffConfig.getInstance().getMainSettings().getWorkspaceDirectory());
        CFileChooser cFileChooser = new CFileChooser("BinDiffWorkspace", "BinDiff Workspace");
        cFileChooser.setDialogTitle("Open Workspace");
        cFileChooser.setApproveButtonText("Open");
        cFileChooser.setCheckBox("Use as default workspace");
        if (file.exists()) {
            cFileChooser.setCurrentDirectory(file);
        }
        if (0 == cFileChooser.showOpenDialog(this.getMainWindow())) {
            File file2 = cFileChooser.getSelectedFile();
            this.loadWorkspace(file2, true);
            if (cFileChooser.isSelectedCheckBox()) {
                BinDiffConfig.getInstance().getMainSettings().setDefaultWorkspace(file2.getAbsolutePath());
            }
        }
    }

    public void loadWorkspace(String string) {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = "Load workspace failed. Workspace folder does not exist.";
            logger.at(Level.SEVERE).log("Load workspace failed. Workspace folder does not exist.");
            CMessageBox.showError(this.getMainWindow(), "Load workspace failed. Workspace folder does not exist.");
            return;
        }
        this.loadWorkspace(file, true);
    }

    public void newDiff() {
        Workspace workspace;
        String string;
        MainWindow mainWindow = this.getMainWindow();
        NewDiffDialog newDiffDialog = new NewDiffDialog((Window)mainWindow, new File(string = (workspace = this.getWorkspace()).getWorkspaceDir().getPath()));
        if (newDiffDialog.getDiffButtonPressed()) {
            File file = newDiffDialog.getIdb(ESide.PRIMARY);
            File file2 = newDiffDialog.getIdb(ESide.SECONDARY);
            File file3 = newDiffDialog.getBinExportBinary(ESide.PRIMARY);
            File file4 = newDiffDialog.getBinExportBinary(ESide.SECONDARY);
            File file5 = newDiffDialog.getDestinationDirectory();
            NewDiffImplementation newDiffImplementation = new NewDiffImplementation(mainWindow, workspace, file, file2, file3, file4, file5);
            try {
                ProgressDialog.show((Window)this.getMainWindow(), String.format("New single Diff '%s'", file5.getName()), newDiffImplementation);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log(exception.getMessage());
                CMessageBox.showError(this.getMainWindow(), "Unknown error while diffing.");
            }
        }
    }

    public void newWorkspace() {
        NewWorkspaceDialog newWorkspaceDialog = new NewWorkspaceDialog((Window)this.getParentWindow(), "New Workspace");
        newWorkspaceDialog.setVisible(true);
        if (!newWorkspaceDialog.isOkPressed()) {
            return;
        }
        if (this.getWorkspace().isLoaded() && !this.closeWorkspace()) {
            return;
        }
        String string = FileUtils.ensureTrailingSlash(newWorkspaceDialog.getWorkspacePath());
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(String.format("%s%s.%s", string, newWorkspaceDialog.getWorkspaceName(), "BinDiffWorkspace"));
        try {
            this.getWorkspace().newWorkspace(file2);
            if (newWorkspaceDialog.isDefaultWorkspace()) {
                BinDiffConfig.getInstance().getMainSettings().setDefaultWorkspace(file2.getAbsolutePath());
            }
        }
        catch (IOException | SQLException exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log();
            CMessageBox.showError(this.getMainWindow(), exception.getMessage());
        }
    }

    public void openCallGraphDiffView(DiffRequestMessage diffRequestMessage) {
        MainWindow mainWindow = this.getMainWindow();
        TabPanelManager tabPanelManager = mainWindow.getController().getTabPanelManager();
        CallGraphViewLoader callGraphViewLoader = new CallGraphViewLoader(diffRequestMessage, mainWindow, tabPanelManager, this.getWorkspace());
        try {
            ProgressDialog.show((Window)this.getMainWindow(), "Loading call graph diff", callGraphViewLoader);
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Open call graph view failed. Couldn't create graph.");
            CMessageBox.showError(this.getMainWindow(), "Open call graph view failed. Couldn't create graph.");
        }
    }

    public void openCallGraphView(MainWindow mainWindow, Diff diff) {
        try {
            TabPanelManager tabPanelManager = mainWindow.getController().getTabPanelManager();
            if (diff.getViewManager().containsView(null, null)) {
                tabPanelManager.selectTabPanel(null, null, diff);
            } else {
                CallGraphViewLoader callGraphViewLoader = new CallGraphViewLoader(diff, this.getMainWindow(), tabPanelManager, this.getWorkspace());
                ProgressDialog.show((Window)this.getMainWindow(), String.format("Loading call graph '%s'", diff.getDiffName()), callGraphViewLoader);
                for (IDiffListener iDiffListener : diff.getListener()) {
                    iDiffListener.loadedView(diff);
                }
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Open call graph view failed. Couldn't create graph.");
            CMessageBox.showError(this.getMainWindow(), "Open call graph view failed. Couldn't create graph.");
        }
    }

    public void openFlowGraphView(MainWindow mainWindow, Diff diff, IAddress iAddress, IAddress iAddress2) {
        if (this.isImportThunkView(diff, iAddress, iAddress2, true)) {
            return;
        }
        TabPanelManager tabPanelManager = mainWindow.getController().getTabPanelManager();
        if (diff.getViewManager().containsView(iAddress, iAddress2)) {
            tabPanelManager.selectTabPanel(iAddress, iAddress2, diff);
            return;
        }
        try {
            LinkedHashSet<Triple<Diff, IAddress, IAddress>> linkedHashSet = new LinkedHashSet<Triple<Diff, IAddress, IAddress>>();
            linkedHashSet.add(Triple.make(diff, iAddress, iAddress2));
            FlowGraphViewLoader flowGraphViewLoader = new FlowGraphViewLoader(this.getMainWindow(), tabPanelManager, this.getWorkspace(), linkedHashSet);
            ProgressDialog.show((Window)this.getMainWindow(), String.format("Loading flow graph '%s'", diff.getDiffName()), flowGraphViewLoader);
            for (IDiffListener iDiffListener : diff.getListener()) {
                iDiffListener.loadedView(diff);
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Open flow graph view failed. Couldn't create graph.");
            CMessageBox.showError(this.getMainWindow(), "Open flow graph view failed. Couldn't create graph.");
        }
    }

    public void openFlowGraphViews(MainWindow mainWindow, LinkedHashSet<Triple<Diff, IAddress, IAddress>> linkedHashSet) {
        Object object;
        TabPanelManager tabPanelManager = mainWindow.getController().getTabPanelManager();
        LinkedHashSet<Triple<Diff, IAddress, IAddress>> linkedHashSet2 = new LinkedHashSet<Triple<Diff, IAddress, IAddress>>();
        int n2 = 0;
        for (Triple object2 : linkedHashSet) {
            Diff diff = (Diff)object2.first();
            IAddress iAddress = (IAddress)object2.second();
            object = (IAddress)object2.third();
            if (diff.getViewManager().containsView(iAddress, (IAddress)object)) continue;
            if (this.isImportThunkView(diff, iAddress, (IAddress)object, false)) {
                ++n2;
                continue;
            }
            linkedHashSet2.add(object2);
        }
        if (n2 > 0) {
            CMessageBox.showInformation(this.getParentWindow(), String.format("%d import thunk views have not been opened since they do not contain any code.", n2));
            if (linkedHashSet2.size() == 0) {
                return;
            }
        }
        try {
            FlowGraphViewLoader flowGraphViewLoader = new FlowGraphViewLoader(this.getMainWindow(), tabPanelManager, this.getWorkspace(), linkedHashSet2);
            ProgressDialog.show((Window)this.getMainWindow(), "Loading flow graph views", flowGraphViewLoader);
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Triple triple : linkedHashSet) {
                object = (Diff)triple.first();
                if (hashSet.contains(object)) continue;
                hashSet.add(object);
                for (IDiffListener iDiffListener : ((Diff)object).getListener()) {
                    iDiffListener.loadedView((Diff)object);
                }
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Open flow graph view failed. Couldn't create graph.");
            CMessageBox.showError(this.getMainWindow(), "Open flow graph view failed. Couldn't create graph.");
        }
    }

    public void openFunctionDiffView(DiffRequestMessage diffRequestMessage) {
        try {
            MainWindow mainWindow = this.getMainWindow();
            TabPanelManager tabPanelManager = mainWindow.getController().getTabPanelManager();
            FunctionDiffViewLoader functionDiffViewLoader = new FunctionDiffViewLoader(diffRequestMessage, mainWindow, tabPanelManager, this.getWorkspace());
            ProgressDialog.show((Window)mainWindow, "Loading function diff", functionDiffViewLoader);
            if (diffRequestMessage.getDiff() != null) {
                for (IDiffListener iDiffListener : diffRequestMessage.getDiff().getListener()) {
                    iDiffListener.loadedView(diffRequestMessage.getDiff());
                }
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Open function diff view failed. Couldn't create graph.");
            CMessageBox.showError(this.getMainWindow(), "Open function diff view failed. Couldn't create graph.");
        }
    }

    public void openFunctionDiffView(MainWindow mainWindow, Diff diff) {
        Preconditions.checkArgument(diff.isFunctionDiff());
        IAddress iAddress = ((RawFunction)diff.getCallGraph(ESide.PRIMARY).getNodes().get(0)).getAddress();
        IAddress iAddress2 = ((RawFunction)diff.getCallGraph(ESide.SECONDARY).getNodes().get(0)).getAddress();
        if (this.isImportThunkView(diff, iAddress, iAddress2, true)) {
            return;
        }
        TabPanelManager tabPanelManager = mainWindow.getController().getTabPanelManager();
        for (TabPanel tabPanel : tabPanelManager) {
            FunctionDiffViewTabPanel functionDiffViewTabPanel;
            Diff diff2;
            if (!(tabPanel instanceof FunctionDiffViewTabPanel) || (diff2 = (functionDiffViewTabPanel = (FunctionDiffViewTabPanel)tabPanel).getView().getGraphs().getDiff()) != diff) continue;
            tabPanelManager.getTabbedPane().setSelectedComponent(tabPanel);
            return;
        }
        DiffRequestMessage diffRequestMessage = new DiffRequestMessage(diff);
        diffRequestMessage.setBinExportPath(diff.getExportFile(ESide.PRIMARY).getPath(), ESide.PRIMARY);
        diffRequestMessage.setBinExportPath(diff.getExportFile(ESide.SECONDARY).getPath(), ESide.SECONDARY);
        diffRequestMessage.setMatchesDBPath(diff.getMatchesDatabase().getPath());
        this.openFunctionDiffView(diffRequestMessage);
    }

    public boolean saveDescription(Diff diff, String string) {
        boolean bl2;
        MatchesDatabase matchesDatabase = new MatchesDatabase(diff.getMatchesDatabase());
        try {
            matchesDatabase.saveDiffDescription(string);
            bl2 = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    matchesDatabase.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException sQLException) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Database error. Couldn't save diff description.");
                CMessageBox.showError(this.getMainWindow(), "Database error. Couldn't save diff description: " + sQLException.getMessage());
                return false;
            }
        }
        matchesDatabase.close();
        return bl2;
    }

    public void setTreeNodeContextComponent(Component component) {
        if (component == null) {
            return;
        }
        JPanel jPanel = this.getWorkspaceTabPanel().getTreeNodeContextContainer();
        jPanel.removeAll();
        jPanel.add(component, "Center");
        jPanel.updateUI();
    }

    public void setWorkspaceTree(WorkspaceTree workspaceTree) {
        this.workspaceTree = workspaceTree;
    }

    public void showInCallGraph(Diff diff, Set<Pair<IAddress, IAddress>> set) {
        Iterable<TabPanel> iterable;
        if (!diff.getViewManager().containsView(null, null)) {
            this.openCallGraphView(this.getMainWindow(), diff);
        } else {
            iterable = this.getMainWindow().getController().getTabPanelManager();
            ((TabPanelManager)iterable).selectTabPanel(null, null, diff);
        }
        iterable = new ArrayList();
        ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
        CallGraphViewData callGraphViewData = diff.getViewManager().getCallGraphViewData(diff);
        if (callGraphViewData != null) {
            CombinedGraph combinedGraph = callGraphViewData.getGraphs().getCombinedGraph();
            for (CombinedDiffNode combinedDiffNode : combinedGraph.getNodes()) {
                IAddress iAddress;
                RawCombinedFunction rawCombinedFunction = (RawCombinedFunction)combinedDiffNode.getRawNode();
                IAddress iAddress2 = rawCombinedFunction.getAddress(ESide.PRIMARY);
                if (set.contains(Pair.make(iAddress2, iAddress = rawCombinedFunction.getAddress(ESide.SECONDARY)))) {
                    iterable.add(combinedDiffNode);
                    continue;
                }
                arrayList.add(combinedDiffNode);
            }
            combinedGraph.selectNodes(iterable, arrayList);
        }
    }

    public void showInitialCallGraphSettingsDialog() {
        if (this.callGraphSettingsDialog == null) {
            this.callGraphSettingsDialog = new InitialCallGraphSettingsDialog((Window)this.getMainWindow());
        }
        this.callGraphSettingsDialog.setVisible(true);
    }

    public void showInitialFlowGraphSettingsDialog() {
        if (this.flowGraphSettingsDialog == null) {
            this.flowGraphSettingsDialog = new InitialFlowGraphSettingsDialog((Window)this.getMainWindow());
        }
        this.flowGraphSettingsDialog.setVisible(true);
    }

    public void showMainSettingsDialog() {
        if (this.mainSettingsDialog == null) {
            this.mainSettingsDialog = new MainSettingsDialog((Window)this.getMainWindow());
        }
        this.mainSettingsDialog.setVisible(true);
    }
}

