/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.detachedviewstabpanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EMatchType;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.MatchesGetter;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FunctionDiffViewTabPanel
extends ViewTabPanel {
    private static final ImageIcon FUNCTIONDIFF_IDENTICAL_MATCHED_ICON = ImageUtils.getImageIcon("data/tabicons/functiondiff-flowgraphs-identical-matched-tab.png");
    private static final ImageIcon FUNCTIONDIFF_INSTRUCTION_CHANGED_ONLY_ICON = ImageUtils.getImageIcon("data/tabicons/functiondiff-flowgraphs-changed-instructions-only-tab.png");
    private static final ImageIcon FUNCTIONDIFF_STRUTURAL_CHANGED_ICON = ImageUtils.getImageIcon("data/tabicons/functiondiff-flowgraphs_structural-changed-tab.png");
    private static final ImageIcon SAVED_FUNCTIONDIFF_IDENTICAL_MATCHED_ICON = ImageUtils.getImageIcon("data/tabicons/savedfunctiondiff-flowgraphs-identical-matched-tab.png");
    private static final ImageIcon SAVED_FUNCTIONDIFF_INSTRUCTION_CHANGED_ONLY_ICON = ImageUtils.getImageIcon("data/tabicons/savedfunctiondiffflowgraphs-changed-instructions-only-tab.png");
    private static final ImageIcon SAVED_FUNCTIONDIFF_STRUTURAL_CHANGED_ICON = ImageUtils.getImageIcon("data/tabicons/savedfunctiondiffflowgraphs_structural-changed-tab.png");
    private final FunctionMatchData functionMatch;
    private final Workspace workspace;

    public FunctionDiffViewTabPanel(MainWindow mainWindow, TabPanelManager tabPanelManager, Workspace workspace, Diff diff, FunctionMatchData functionMatchData, ViewData viewData) {
        super(mainWindow, tabPanelManager, workspace, diff, viewData);
        this.functionMatch = Preconditions.checkNotNull(functionMatchData);
        this.workspace = Preconditions.checkNotNull(workspace);
    }

    private boolean isSavedView() {
        if (this.workspace.isLoaded()) {
            String string = this.getDiff().getMatchesDatabase().getParentFile().getParentFile().getParent();
            String string2 = this.workspace.getWorkspaceDirPath();
            return string.equals(string2);
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        CombinedGraph combinedGraph = this.getView().getGraphs().getCombinedGraph();
        if (this.getView().isFlowGraphView()) {
            EMatchType eMatchType = MatchesGetter.getFlowGraphsMatchType(combinedGraph, this.functionMatch);
            switch (eMatchType) {
                case IDENTICAL: {
                    return this.isSavedView() ? SAVED_FUNCTIONDIFF_IDENTICAL_MATCHED_ICON : FUNCTIONDIFF_IDENTICAL_MATCHED_ICON;
                }
                case INSTRUCTIONS_CHANGED: {
                    return this.isSavedView() ? SAVED_FUNCTIONDIFF_INSTRUCTION_CHANGED_ONLY_ICON : FUNCTIONDIFF_INSTRUCTION_CHANGED_ONLY_ICON;
                }
                case STRUCTURAL_CHANGED: {
                    return this.isSavedView() ? SAVED_FUNCTIONDIFF_STRUTURAL_CHANGED_ICON : FUNCTIONDIFF_STRUTURAL_CHANGED_ICON;
                }
            }
            return null;
        }
        return null;
    }
}

