/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.MaterialChromeTabbedPaneUI;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.ICloseTabButtonListener;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.TabButtonComponent;
import com.google.security.zynamics.bindiff.gui.dialogs.searchresultsdialog.SearchResultsDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.detachedviewstabpanel.FunctionDiffViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.subpanels.ViewToolbarPanel;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffListenerAdapter;
import com.google.security.zynamics.bindiff.project.diff.IDiffListener;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class TabPanelManager
implements Iterable<TabPanel> {
    private static final Color WORKSPACE_TAB_COLOR = Color.WHITE;
    private static final Color SINGLE_FUNCTION_DIFF_VIEWS_TAB_COLOR = Color.WHITE;
    private static final ColorSlot[] colorSlots = new ColorSlot[]{ColorSlot.make(Colors.DIFF_A_VIEW_TABS_COLOR), ColorSlot.make(Colors.DIFF_B_VIEW_TABS_COLOR), ColorSlot.make(Colors.DIFF_C_VIEW_TABS_COLOR), ColorSlot.make(Colors.DIFF_D_VIEW_TABS_COLOR)};
    private final InternalCloseTabButtonListener closeTabListener = new InternalCloseTabButtonListener();
    private final InternalTabListener tablistener = new InternalTabListener();
    private final MainWindow window;
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final List<TabPanel> tabPanels = new ArrayList<TabPanel>();
    private final Workspace workspace;

    public TabPanelManager(MainWindow mainWindow, Workspace workspace) {
        this.window = Preconditions.checkNotNull(mainWindow);
        this.workspace = Preconditions.checkNotNull(workspace);
        this.tabbedPane.setTabLayoutPolicy(0);
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.setUI(new MaterialChromeTabbedPaneUI());
        this.addListener();
    }

    private void addListener() {
        this.tabbedPane.addChangeListener(this.tablistener);
    }

    private Color getTabColor(TabPanel tabPanel) {
        if (tabPanel instanceof FunctionDiffViewTabPanel) {
            return SINGLE_FUNCTION_DIFF_VIEWS_TAB_COLOR;
        }
        if (tabPanel instanceof ViewTabPanel) {
            Diff diff = ((ViewTabPanel)tabPanel).getDiff();
            for (ColorSlot colorSlot : colorSlots) {
                if (colorSlot.diff != diff) continue;
                return colorSlot.color;
            }
        }
        return Colors.GRAY240;
    }

    private void registerTabColor(TabPanel tabPanel) {
        if (tabPanel instanceof ViewTabPanel) {
            Diff diff = ((ViewTabPanel)tabPanel).getDiff();
            if (diff.isFunctionDiff()) {
                return;
            }
            for (ColorSlot colorSlot : colorSlots) {
                if (colorSlot.diff != diff) continue;
                return;
            }
            for (ColorSlot colorSlot : colorSlots) {
                if (colorSlot.diff != null) continue;
                InternalDiffListener internalDiffListener = new InternalDiffListener();
                diff.addListener(internalDiffListener);
                colorSlot.diff = diff;
                colorSlot.diffListener = internalDiffListener;
                return;
            }
        }
    }

    private void unregisterTabColor(Diff diff) {
        for (ViewTabPanel viewTabPanel : this.window.getController().getTabPanelManager().getViewTabPanels()) {
            if (viewTabPanel.getDiff() != diff) continue;
            return;
        }
        for (ColorSlot colorSlot : colorSlots) {
            if (colorSlot.diff != diff) continue;
            colorSlot.diff.removeListener(colorSlot.diffListener);
            colorSlot.diff = null;
            colorSlot.diffListener = null;
        }
    }

    public void addTab(TabPanel tabPanel) {
        TabButtonComponent tabButtonComponent;
        this.tabbedPane.addTab(tabPanel.getTitle().toString(), tabPanel);
        int n2 = this.tabbedPane.getTabCount() - 1;
        Color color = Color.WHITE;
        if (tabPanel instanceof WorkspaceTabPanel) {
            tabButtonComponent = new TabButtonComponent(this.tabbedPane, tabPanel, tabPanel.getIcon(), false);
            color = WORKSPACE_TAB_COLOR;
        } else {
            this.registerTabColor(tabPanel);
            color = this.getTabColor(tabPanel);
            tabButtonComponent = new TabButtonComponent(this.tabbedPane, tabPanel, tabPanel.getIcon(), true);
            tabButtonComponent.addListener(this.closeTabListener);
        }
        this.tabbedPane.setTabComponentAt(n2, tabButtonComponent);
        this.tabbedPane.setBackgroundAt(n2, color);
        this.tabPanels.add(tabPanel);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public ViewTabPanel getTabPanel(IAddress iAddress, IAddress iAddress2, Diff diff) {
        for (TabPanel tabPanel : this.tabPanels) {
            boolean bl2;
            boolean bl3;
            ViewData viewData;
            if (!(tabPanel instanceof ViewTabPanel) || (viewData = ((ViewTabPanel)tabPanel).getView()).getGraphs().getDiff() != diff) continue;
            IAddress iAddress3 = viewData.getAddress(ESide.PRIMARY);
            IAddress iAddress4 = viewData.getAddress(ESide.SECONDARY);
            if (viewData.isCallGraphView() && iAddress3 == null && iAddress4 == null && iAddress == null && iAddress2 == null) {
                return (ViewTabPanel)tabPanel;
            }
            if (!viewData.isFlowGraphView()) continue;
            boolean bl4 = bl3 = iAddress3 == null && iAddress == null;
            if (iAddress3 != null && iAddress != null) {
                bl3 = iAddress3.equals(iAddress);
            }
            boolean bl5 = bl2 = iAddress4 == null && iAddress2 == null;
            if (iAddress4 != null && iAddress2 != null) {
                bl2 = iAddress4.equals(iAddress2);
            }
            if (!bl3 || !bl2) continue;
            return (ViewTabPanel)tabPanel;
        }
        return null;
    }

    public List<ViewTabPanel> getViewTabPanels() {
        ArrayList<ViewTabPanel> arrayList = new ArrayList<ViewTabPanel>();
        for (TabPanel tabPanel : this.tabPanels) {
            if (!(tabPanel instanceof ViewTabPanel)) continue;
            arrayList.add((ViewTabPanel)tabPanel);
        }
        return arrayList;
    }

    public List<ViewTabPanel> getViewTabPanels(boolean bl2) {
        ArrayList<ViewTabPanel> arrayList = new ArrayList<ViewTabPanel>();
        for (TabPanel tabPanel : this.tabPanels) {
            if (!(tabPanel instanceof ViewTabPanel) || ((ViewTabPanel)tabPanel).getDiff().isFunctionDiff() != bl2) continue;
            arrayList.add((ViewTabPanel)tabPanel);
        }
        return arrayList;
    }

    public WorkspaceTabPanel getWorkspaceTabPanel() {
        return (WorkspaceTabPanel)this.tabbedPane.getComponentAt(0);
    }

    @Override
    public Iterator<TabPanel> iterator() {
        return this.tabPanels.iterator();
    }

    public void removeListener() {
        this.tabbedPane.addChangeListener(this.tablistener);
    }

    public void removeTab(TabPanel tabPanel) {
        this.tabPanels.remove(tabPanel);
        int n2 = this.tabbedPane.indexOfComponent(tabPanel);
        this.tabbedPane.remove(n2);
    }

    public void selectTab(TabPanel tabPanel) {
        this.tabbedPane.setSelectedComponent(tabPanel);
    }

    public void selectTabPanel(IAddress iAddress, IAddress iAddress2, Diff diff) {
        ViewTabPanel viewTabPanel = this.getTabPanel(iAddress, iAddress2, diff);
        if (viewTabPanel != null) {
            this.selectTab(viewTabPanel);
        }
    }

    public void udpateSelectedTabIcon() {
        int n2 = this.tabbedPane.getSelectedIndex();
        TabButtonComponent tabButtonComponent = (TabButtonComponent)this.tabbedPane.getTabComponentAt(n2);
        if (tabButtonComponent != null) {
            tabButtonComponent.setIcon(this.tabPanels.get(n2).getIcon());
            tabButtonComponent.updateUI();
        }
    }

    public void updateSelectedTabTitel(String string) {
        int n2 = this.tabbedPane.getSelectedIndex();
        TabButtonComponent tabButtonComponent = (TabButtonComponent)this.tabbedPane.getTabComponentAt(n2);
        if (tabButtonComponent != null) {
            tabButtonComponent.setTitle(string);
            tabButtonComponent.updateUI();
        }
    }

    private class InternalTabListener
    implements ChangeListener {
        private InternalTabListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            TabPanel tabPanel = (TabPanel)TabPanelManager.this.tabbedPane.getSelectedComponent();
            TabPanelManager.this.window.updateTitle(TabPanelManager.this.workspace, tabPanel);
            TabPanelManager.this.window.setJMenuBar(tabPanel.getMenuBar());
            for (TabPanel tabPanel2 : TabPanelManager.this.tabPanels) {
                SearchResultsDialog searchResultsDialog;
                ViewToolbarPanel viewToolbarPanel;
                if (!(tabPanel2 instanceof ViewTabPanel)) continue;
                if (tabPanel == tabPanel2) {
                    viewToolbarPanel = ((ViewTabPanel)tabPanel2).getToolbar();
                    searchResultsDialog = viewToolbarPanel.getSearchResultsDialog();
                    searchResultsDialog.setVisible(searchResultsDialog.getReshowDialog());
                    continue;
                }
                viewToolbarPanel = ((ViewTabPanel)tabPanel2).getToolbar();
                searchResultsDialog = viewToolbarPanel.getSearchResultsDialog();
                boolean bl2 = searchResultsDialog.isVisible() || searchResultsDialog.getReshowDialog();
                searchResultsDialog.setVisible(false);
                searchResultsDialog.setReshowDialog(bl2);
            }
        }
    }

    private class InternalDiffListener
    extends DiffListenerAdapter {
        private InternalDiffListener() {
        }

        @Override
        public void closedView(Diff diff) {
            TabPanelManager.this.unregisterTabColor(diff);
        }
    }

    private static final class ColorSlot {
        protected final Color color;
        protected Diff diff;
        protected IDiffListener diffListener;

        private ColorSlot(Color color) {
            this.color = Preconditions.checkNotNull(color);
            this.diff = null;
            this.diffListener = null;
        }

        protected static ColorSlot make(Color color) {
            return new ColorSlot(color);
        }
    }

    private class InternalCloseTabButtonListener
    implements ICloseTabButtonListener {
        private InternalCloseTabButtonListener() {
        }

        @Override
        public boolean closing(TabButtonComponent tabButtonComponent) {
            ViewTabPanel viewTabPanel = (ViewTabPanel)tabButtonComponent.getTabPanel();
            ViewData viewData = viewTabPanel.getView();
            if (viewTabPanel.getController().hasChanged()) {
                viewTabPanel.getTabPanelManager().selectTab(viewTabPanel);
                int n2 = CMessageBox.showYesNoCancelQuestion(TabPanelManager.this.window, String.format("'%s' has been modified. Save?", viewData.getViewName()));
                if (n2 == 2) {
                    return false;
                }
                viewTabPanel.getController().closeView(n2 == 0);
            } else {
                viewTabPanel.getController().closeView(false);
            }
            return true;
        }
    }
}

