/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CDialogAboutEx;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.license.UpdateCheckHelper;
import java.awt.Desktop;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class TabPanelFunctions {
    private static final ImageIcon BINDIFF_ABOUT_IMAGE = ImageUtils.getImageIcon("data/appimages/bindiff-about-image.png");
    private final Workspace workspace;
    private final MainWindow window;

    public TabPanelFunctions(MainWindow mainWindow, Workspace workspace) {
        this.window = Preconditions.checkNotNull(mainWindow);
        this.workspace = Preconditions.checkNotNull(workspace);
    }

    public MainWindow getMainWindow() {
        return this.window;
    }

    public void checkForUpdates() {
        UpdateCheckHelper.checkForUpdatesWithUi(this.window, "BinDiff", "6");
    }

    public void exitBinDiff() {
        this.window.getController().exitBinDiff();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void reportABug() {
        try {
            Desktop.getDesktop().browse(new URL("https://bugs.zynamics.com/BinDiff").toURI());
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : "Malformed URL";
        }
        catch (URISyntaxException uRISyntaxException) {
            assert (false) : "URL could not be converted to URI";
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.window, "Couldn't open URL \"https://bugs.zynamics.com/BinDiff\"!", "BinDiff", 0);
        }
    }

    public void showAboutDialog() {
        ArrayList<Pair<String, URL>> arrayList;
        block2: {
            arrayList = new ArrayList<Pair<String, URL>>();
            try {
                arrayList.add(new Pair<String, URL>("zynamics Website", new URL("https://www.zynamics.com")));
                arrayList.add(new Pair<String, URL>("BinDiff Product Site", new URL("http://www.zynamics.com/bindiff.html")));
                arrayList.add(new Pair<String, URL>("Report Bugs", new URL("mailto:zynamics-support@google.com")));
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Malformed URL in About dialog.");
            }
        }
        String string = "BinDiff 6\n\nCopyright \u00a92004-2011 zynamics GmbH\nCopyright \u00a92011-2020 Google LLC.\n";
        String string2 = "\nParts of this software were created by third parties and may have different licensing requirements.\nPlease see the manual for a complete list.\n";
        Image image = BINDIFF_ABOUT_IMAGE.getImage();
        CDialogAboutEx cDialogAboutEx = new CDialogAboutEx(this.window, new ImageIcon(image), "BinDiff", "BinDiff 6\n\nCopyright \u00a92004-2011 zynamics GmbH\nCopyright \u00a92011-2020 Google LLC.\n", "\nParts of this software were created by third parties and may have different licensing requirements.\nPlease see the manual for a complete list.\n", arrayList);
        cDialogAboutEx.setIconImage(ImageUtils.getImageIcon("data/appicons/bindiff-16x16-rgba.png").getImage());
        cDialogAboutEx.setSize(cDialogAboutEx.getWidth() - 8, cDialogAboutEx.getHeight());
        GuiHelper.centerChildToParent(this.window, cDialogAboutEx, true);
        cDialogAboutEx.setVisible(true);
    }

    public void showHelp() {
        try {
            Desktop.getDesktop().browse(new URL("https://www.zynamics.com/bindiff/manual/index.html").toURI());
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : "Malformed URL";
        }
        catch (URISyntaxException uRISyntaxException) {
            assert (false) : "URL could not be converted to URI";
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.window, "Couldn't open URL \"https://www.zynamics.com/bindiff/manual/index.html\"!", "BinDiff", 0);
        }
    }
}

