/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.searchresultsdialog;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.searchers.SearchResult;
import com.google.security.zynamics.bindiff.gui.components.graphsearchfield.GraphSearchField;
import com.google.security.zynamics.bindiff.gui.components.graphsearchfield.IGraphSearchFieldListener;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.searchresultsdialog.SearchResultsCellRenderer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class SearchResultsDialog
extends BaseDialog {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JTable primaryTable = new JTable();
    private final JTable secondaryTable = new JTable();
    private final JLabel primaryResultsLabel = new JLabel("");
    private final JLabel secondaryResultsLabel = new JLabel("");
    private final InternalTableListener listener = new InternalTableListener();
    private final IGraphSearchFieldListener searchListener = new InternalSearchListener();
    private final GraphSearchField searchField;
    private boolean wasVisible = false;

    public SearchResultsDialog(Window window, GraphSearchField graphSearchField) {
        super(window, "Search Results");
        this.setModal(false);
        this.searchField = graphSearchField;
        this.setResults(graphSearchField.getGraphs());
        this.setLayout(new BorderLayout());
        graphSearchField.addListener(this.searchListener);
        this.primaryTable.setDefaultRenderer(Object.class, new SearchResultsCellRenderer());
        this.primaryTable.getSelectionModel().addListSelectionListener(this.listener);
        this.primaryTable.setSelectionMode(0);
        this.secondaryTable.setDefaultRenderer(Object.class, new SearchResultsCellRenderer());
        this.secondaryTable.getSelectionModel().addListSelectionListener(this.listener);
        this.secondaryTable.setSelectionMode(0);
        this.init();
        this.setSize(400, 400);
    }

    private void fillUpTableData(List<SearchResult> list, Object[][] objectArray) {
        int n2 = 0;
        Color color = null;
        Object object = null;
        for (SearchResult searchResult : list) {
            if (object == null || object != searchResult.getObject()) {
                object = searchResult.getObject();
                color = color == null || color.equals(Color.WHITE) ? new Color(242, 242, 242) : Color.WHITE;
            }
            searchResult.setObjectMarkerColor(color);
            if (searchResult.getObject() instanceof ZyGraphNode) {
                objectArray[n2++][0] = searchResult;
                continue;
            }
            if (!(searchResult.getObject() instanceof ZyGraphEdge)) continue;
            objectArray[n2++][0] = searchResult;
        }
    }

    private void removAllRows(JTable jTable) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
        defaultTableModel.getDataVector().removeAllElements();
    }

    private void setResults(GraphsContainer graphsContainer) {
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        arrayList.addAll(graphsContainer.getPrimaryGraph().getGraphSearcher().getSubObjectResults());
        ArrayList<SearchResult> arrayList2 = new ArrayList<SearchResult>();
        arrayList2.addAll(graphsContainer.getSecondaryGraph().getGraphSearcher().getSubObjectResults());
        Object[][] objectArray = new Object[arrayList.size()][1];
        Object[][] objectArray2 = new Object[arrayList2.size()][1];
        this.fillUpTableData(arrayList, objectArray);
        this.fillUpTableData(arrayList2, objectArray2);
        this.primaryTable.setModel(new CResultsTableModel(objectArray, new String[]{"Primary Results"}));
        this.secondaryTable.setModel(new CResultsTableModel(objectArray2, new String[]{"Secondary Results"}));
        this.primaryResultsLabel.setText(String.format("%d search results", objectArray.length));
        this.secondaryResultsLabel.setText(String.format("%d search results", objectArray2.length));
    }

    private void init() {
        this.tabbedPane.setFocusable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tabbedPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(2, 2, 2, 1));
        jPanel2.add((Component)new JScrollPane(this.primaryTable), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(2, 2, 2, 1));
        jPanel3.add((Component)new JScrollPane(this.secondaryTable), "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new LineBorder(Color.GRAY));
        jPanel4.add((Component)jPanel2, "Center");
        this.primaryResultsLabel.setBorder(new EmptyBorder(2, 2, 5, 2));
        jPanel4.add((Component)this.primaryResultsLabel, "South");
        this.tabbedPane.add("Primary", jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new LineBorder(Color.GRAY));
        jPanel5.add((Component)jPanel3, "Center");
        this.secondaryResultsLabel.setBorder(new EmptyBorder(2, 2, 5, 1));
        jPanel5.add((Component)this.secondaryResultsLabel, "South");
        this.tabbedPane.add("Secondary", jPanel5);
        this.add((Component)jPanel, "Center");
    }

    public boolean getReshowDialog() {
        return this.wasVisible;
    }

    public void setReshowDialog(boolean bl2) {
        this.wasVisible = bl2;
    }

    private class InternalTableListener
    implements ListSelectionListener {
        private InternalTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SearchResultsDialog.this.tabbedPane.getSelectedIndex() == 0) {
                int n2 = SearchResultsDialog.this.primaryTable.getSelectedRow();
                if (n2 == -1) {
                    return;
                }
                SearchResultsDialog.this.searchField.jumpToIndex(n2, ESide.PRIMARY);
            } else {
                int n3 = SearchResultsDialog.this.secondaryTable.getSelectedRow();
                if (n3 == -1) {
                    return;
                }
                SearchResultsDialog.this.searchField.jumpToIndex(n3, ESide.SECONDARY);
            }
        }
    }

    private class InternalSearchListener
    implements IGraphSearchFieldListener {
        private InternalSearchListener() {
        }

        @Override
        public void cleaned() {
            this.searched();
        }

        @Override
        public void searched() {
            SearchResultsDialog.this.removAllRows(SearchResultsDialog.this.primaryTable);
            SearchResultsDialog.this.removAllRows(SearchResultsDialog.this.secondaryTable);
            SearchResultsDialog.this.setResults(SearchResultsDialog.this.searchField.getGraphs());
            SearchResultsDialog.this.primaryTable.updateUI();
            SearchResultsDialog.this.secondaryTable.updateUI();
            SearchResultsDialog.this.primaryResultsLabel.updateUI();
            SearchResultsDialog.this.secondaryResultsLabel.updateUI();
        }
    }

    private class CResultsTableModel
    extends DefaultTableModel {
        public CResultsTableModel(Object[][] objectArray, String[] stringArray) {
            super(objectArray, stringArray);
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }
    }
}

