/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.printing;

import a.h.am;
import a.h.ar;
import a.h.cj;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.printing.PrintGraphOptionsDialog;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class PrintGraphPreviewDialog
extends BaseDialog {
    private final ActionListener buttonListener = new InternalButtonListener();
    private final PrinterJob printJob;
    private final am printer;
    private final ar view;
    private final JButton cancelButton;
    private CGraph2DPrintPreviewPanel hiddenPrinterPreviewPanel;
    private JButton pageSetupButton;
    private JButton printButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private final JButton optionsButton;
    private JComboBox<String> zoomComboBox;
    private JScrollPane previewPane;

    public PrintGraphPreviewDialog(JFrame jFrame, ar ar2) {
        super((Window)jFrame, "Print View");
        this.view = ar2;
        this.printJob = PrinterJob.getPrinterJob();
        this.printer = new am(ar2);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this.buttonListener);
        this.optionsButton = new JButton();
        this.optionsButton.addActionListener(this.buttonListener);
        this.extractComponents();
        this.printButton.addActionListener(this.buttonListener);
        this.init();
        this.pack();
        GuiHelper.centerChildToParent(jFrame, this, true);
        this.setVisible(true);
    }

    private void extractComponents() {
        this.hiddenPrinterPreviewPanel = new CGraph2DPrintPreviewPanel(this.printJob, this.printer, this.printJob.defaultPage());
    }

    private void init() {
        this.pageSetupButton.setText("Page Setup");
        this.printButton.setText("Print");
        this.zoomOutButton.setText("Zoom In");
        this.zoomInButton.setText("Zoom Out");
        this.optionsButton.setText("Options");
        this.cancelButton.setText("Cancel");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 4, 5, 5));
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel3.add(this.zoomComboBox);
        jPanel3.add(this.zoomOutButton);
        jPanel3.add(this.zoomInButton);
        jPanel3.add(this.optionsButton);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(0, 5, 0, 4));
        jPanel4.add((Component)this.previewPane, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)this.pageSetupButton, "West");
        JPanel jPanel7 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel7.add(this.printButton);
        jPanel7.add(this.cancelButton);
        jPanel5.add((Component)jPanel6, "West");
        jPanel5.add((Component)jPanel7, "East");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel5, "South");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void dispose() {
        this.cancelButton.removeActionListener(this.buttonListener);
        this.optionsButton.removeActionListener(this.buttonListener);
        this.printButton.removeActionListener(this.buttonListener);
        super.dispose();
    }

    private class InternalButtonListener
    implements ActionListener {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintGraphOptionsDialog printGraphOptionsDialog;
            if (actionEvent.getSource() == PrintGraphPreviewDialog.this.cancelButton || actionEvent.getSource() == PrintGraphPreviewDialog.this.printButton) {
                PrintGraphPreviewDialog.this.dispose();
            } else if (actionEvent.getSource() == PrintGraphPreviewDialog.this.optionsButton && (printGraphOptionsDialog = new PrintGraphOptionsDialog((Window)PrintGraphPreviewDialog.this, PrintGraphPreviewDialog.this.printer)).isOkPressed()) {
                PrintGraphPreviewDialog.this.hiddenPrinterPreviewPanel.setPages(0, PrintGraphPreviewDialog.this.printer.Ce(), PrintGraphPreviewDialog.this.printer.Ce() * PrintGraphPreviewDialog.this.printer.Cd());
            }
        }
    }

    private class CGraph2DPrintPreviewPanel
    extends cj {
        public CGraph2DPrintPreviewPanel(PrinterJob printerJob, am am2, PageFormat pageFormat) {
            super(printerJob, am2, am2.Ce(), am2.Ce() * am2.Cd(), pageFormat);
            JButton[] jButtonArray = new JButton[4];
            int n2 = 0;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Component component = this.getComponent(i2);
                for (int i3 = 0; i3 < ((JPanel)component).getComponentCount(); ++i3) {
                    Component component2 = ((JPanel)component).getComponent(i3);
                    if (component2 instanceof JButton) {
                        jButtonArray[n2++] = (JButton)component2;
                        continue;
                    }
                    if (component2 instanceof JComboBox) {
                        PrintGraphPreviewDialog.this.zoomComboBox = (JComboBox)component2;
                        continue;
                    }
                    if (!(component2 instanceof JScrollPane)) continue;
                    PrintGraphPreviewDialog.this.previewPane = (JScrollPane)component2;
                }
            }
            PrintGraphPreviewDialog.this.pageSetupButton = jButtonArray[0];
            PrintGraphPreviewDialog.this.printButton = jButtonArray[1];
            PrintGraphPreviewDialog.this.zoomOutButton = jButtonArray[2];
            PrintGraphPreviewDialog.this.zoomInButton = jButtonArray[3];
        }
    }
}

