/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.printing;

import a.h.am;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class PrintGraphOptionsDialog
extends BaseDialog {
    private static final int LABEL_WIDTH = 125;
    private static final int ROW_HEIGHT = 25;
    private final am printer;
    private boolean okPressed = false;
    private final ActionListener buttonListener = new InteneralButtonListener();
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Cancel");
    private final JFormattedTextField posterRows = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CDecFormatter(2)));
    private final JFormattedTextField posterCols = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CDecFormatter(2)));
    private final JComboBox<String> posterCoords = new JComboBox();
    private final JComboBox<String> clipArea = new JComboBox();
    private final JTextField titleTextField = TextComponentUtils.addDefaultEditorActions(new JTextField());
    private final ColorPanel titleBarColor = new ColorPanel(Colors.GRAY192, true, true);
    private final ColorPanel titleTextColor = new ColorPanel(Color.BLACK, true, true);
    private final JFormattedTextField fontSize = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CDecFormatter(2)));

    public PrintGraphOptionsDialog(Window window, am am2) {
        super(window, "Print Options");
        this.printer = am2;
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
        this.init();
        this.pack();
        GuiHelper.centerChildToParent(window, this, true);
        this.setVisible(true);
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private JPanel createGeneralTabPanel() {
        this.posterRows.setText(String.valueOf(this.printer.Cd()));
        this.posterCols.setText(String.valueOf(this.printer.Ce()));
        this.posterCoords.addItem("Show");
        this.posterCoords.addItem("Hide");
        this.posterCoords.setSelectedIndex(1);
        this.clipArea.addItem("Graph");
        this.clipArea.addItem("View");
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 3, 3));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), new EmptyBorder(5, 5, 5, 5)));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Poster Rows", 125, this.posterRows, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Poster Columns", 125, this.posterCols, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Add Poster Coords", 125, this.posterCoords, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Clip Area", 125, this.clipArea, 25));
        return jPanel;
    }

    private JPanel createTitleTabPanel() {
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 3, 3));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), new EmptyBorder(5, 5, 5, 5)));
        this.fontSize.setText("13");
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Text", 125, this.titleTextField, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Text Color", 125, this.titleTextColor, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Titlebar Color", 125, this.titleBarColor, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Font Size", 125, this.fontSize, 25));
        return jPanel;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("General", this.createGeneralTabPanel());
        jTabbedPane.addTab("Title", this.createTitleTabPanel());
        jPanel.add((Component)jTabbedPane, "North");
        jPanel.add((Component)this.createButtonsPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void dispose() {
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
        super.dispose();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private final class InteneralButtonListener
    implements ActionListener {
        private InteneralButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PrintGraphOptionsDialog.this.okButton) {
                if (Integer.parseInt(PrintGraphOptionsDialog.this.posterRows.getText()) < 0) {
                    CMessageBox.showInformation(PrintGraphOptionsDialog.this, "Poster rows value must be greater than 0.");
                    return;
                }
                if (Integer.parseInt(PrintGraphOptionsDialog.this.posterCols.getText()) < 0) {
                    CMessageBox.showInformation(PrintGraphOptionsDialog.this, "Poster columns value must be greater than 0.");
                    return;
                }
                if (Integer.parseInt(PrintGraphOptionsDialog.this.fontSize.getText()) < 0) {
                    CMessageBox.showInformation(PrintGraphOptionsDialog.this, "Font size value must be greater than 0.");
                    return;
                }
                PrintGraphOptionsDialog.this.okPressed = true;
                PrintGraphOptionsDialog.this.printer.bs(Integer.parseInt(PrintGraphOptionsDialog.this.posterRows.getText()));
                PrintGraphOptionsDialog.this.printer.bt(Integer.parseInt(PrintGraphOptionsDialog.this.posterCols.getText()));
                PrintGraphOptionsDialog.this.printer.d(PrintGraphOptionsDialog.this.clipArea.getSelectedIndex() == 0 ? (byte)1 : 0);
                PrintGraphOptionsDialog.this.printer.bL(PrintGraphOptionsDialog.this.posterCoords.getSelectedIndex() == 0);
                am.c c2 = new am.c();
                c2.setText(PrintGraphOptionsDialog.this.titleTextField.getText());
                c2.a(PrintGraphOptionsDialog.this.titleTextColor.getColor());
                c2.setTextColor(PrintGraphOptionsDialog.this.titleBarColor.getColor());
                c2.setFont(new Font("Dialog", 0, Integer.parseInt(PrintGraphOptionsDialog.this.fontSize.getText())));
                PrintGraphOptionsDialog.this.printer.a(c2);
            }
            PrintGraphOptionsDialog.this.dispose();
        }
    }
}

