/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.panels;

import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.ThemeConfigItem;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class SyntaxHighlightingPanel
extends JPanel {
    private static final int COLORPANEL_WIDTH = 200;
    private static final int COLORPANEL_HEIGHT = 25;
    private static final int NUMMBER_OF_ROWS = 15;
    private ColorPanel defaultColor;
    private ColorPanel addressColor;
    private ColorPanel mnemonicColor;
    private ColorPanel symbolColor;
    private ColorPanel immediateColor;
    private ColorPanel operatorColor;
    private ColorPanel registerColor;
    private ColorPanel sizePrefixColor;
    private ColorPanel dereferenceColor;
    private ColorPanel operandSeparatorColor;
    private ColorPanel stackVariableColor;
    private ColorPanel globalVariableColor;
    private ColorPanel jumpLabelColor;
    private ColorPanel functionColor;
    private ColorPanel commentColor;
    Set<Color> defaultColors = new HashSet<Color>();

    public SyntaxHighlightingPanel() {
        super(new BorderLayout());
        this.init();
    }

    private JPanel createInstructionColorsPanel() {
        ThemeConfigItem themeConfigItem = BinDiffConfig.getInstance().getThemeSettings();
        JPanel jPanel = new JPanel(new GridLayout(15, 1, 5, 5));
        jPanel.setBorder(new TitledBorder("Syntax Highlighting"));
        this.defaultColors.add(themeConfigItem.getDefaultColor());
        this.defaultColors.add(themeConfigItem.getAddressColor());
        this.defaultColors.add(themeConfigItem.getMnemonicColor());
        this.defaultColors.add(themeConfigItem.getRegisterColor());
        this.defaultColors.add(themeConfigItem.getFunctionColor());
        this.defaultColors.add(themeConfigItem.getImmediateColor());
        this.defaultColors.add(themeConfigItem.getGlobalVariableColor());
        this.defaultColors.add(themeConfigItem.getStackVariableColor());
        this.defaultColors.add(themeConfigItem.getJumpLabelColor());
        this.defaultColors.add(themeConfigItem.getDereferenceColor());
        this.defaultColors.add(themeConfigItem.getOperatorSeparatorColor());
        this.defaultColors.add(themeConfigItem.getSymbolColor());
        this.defaultColors.add(themeConfigItem.getSizePrefixColor());
        this.defaultColors.add(themeConfigItem.getDefaultColor());
        this.defaultColors.add(themeConfigItem.getDefaultColor());
        this.defaultColors.add(themeConfigItem.getCommentColor());
        this.defaultColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Default color:", new ColorPanel(themeConfigItem.getDefaultColor(), true, true, this.defaultColors), 200, 25, false);
        this.addressColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Address color:", new ColorPanel(themeConfigItem.getAddressColor(), true, true, this.defaultColors), 200, 25, false);
        this.mnemonicColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Mnemonic color:", new ColorPanel(themeConfigItem.getMnemonicColor(), true, true, this.defaultColors), 200, 25, false);
        this.registerColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Register color:", new ColorPanel(themeConfigItem.getRegisterColor(), true, true, this.defaultColors), 200, 25, false);
        this.functionColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Function color:", new ColorPanel(themeConfigItem.getFunctionColor(), true, true, this.defaultColors), 200, 25, false);
        this.immediateColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Integer immediate color:", new ColorPanel(themeConfigItem.getImmediateColor(), true, true, this.defaultColors), 200, 25, false);
        this.globalVariableColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Global variable color:", new ColorPanel(themeConfigItem.getGlobalVariableColor(), true, true, this.defaultColors), 200, 25, false);
        this.stackVariableColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Stack variable color:", new ColorPanel(themeConfigItem.getStackVariableColor(), true, true, this.defaultColors), 200, 25, false);
        this.jumpLabelColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Jump label color:", new ColorPanel(themeConfigItem.getJumpLabelColor(), true, true, this.defaultColors), 200, 25, false);
        this.operatorColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Operator color:", new ColorPanel(themeConfigItem.getOperatorColor(), true, true, this.defaultColors), 200, 25, false);
        this.dereferenceColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Dereference color:", new ColorPanel(themeConfigItem.getDereferenceColor(), true, true, this.defaultColors), 200, 25, false);
        this.operandSeparatorColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Operand separator color:", new ColorPanel(themeConfigItem.getOperatorSeparatorColor(), true, true, this.defaultColors), 200, 25, false);
        this.symbolColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Symbol color:", new ColorPanel(themeConfigItem.getSymbolColor(), true, true, this.defaultColors), 200, 25, false);
        this.sizePrefixColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Size prefix color:", new ColorPanel(themeConfigItem.getSizePrefixColor(), true, true, this.defaultColors), 200, 25, false);
        this.commentColor = GuiUtils.createHorizontalNamedComponent(jPanel, "Comment color:", new ColorPanel(themeConfigItem.getCommentColor(), true, true, this.defaultColors), 200, 25, false);
        return jPanel;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.createInstructionColorsPanel(), gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        this.add(new JScrollPane(jPanel));
    }

    public Color getAddressColor() {
        return this.addressColor.getColor();
    }

    public Color getCommentColor() {
        return this.commentColor.getColor();
    }

    public Color getDefaultColor() {
        return this.defaultColor.getColor();
    }

    public Color getDereferenceColor() {
        return this.dereferenceColor.getColor();
    }

    public Color getFunctionColor() {
        return this.functionColor.getColor();
    }

    public Color getGlobalVariableColor() {
        return this.globalVariableColor.getColor();
    }

    public Color getImmediateColor() {
        return this.immediateColor.getColor();
    }

    public Color getJumpLabelColor() {
        return this.jumpLabelColor.getColor();
    }

    public Color getMnemonicColor() {
        return this.mnemonicColor.getColor();
    }

    public Color getOperandSeparatorColor() {
        return this.operandSeparatorColor.getColor();
    }

    public Color getOperatorColor() {
        return this.operatorColor.getColor();
    }

    public Color getRegisterColor() {
        return this.registerColor.getColor();
    }

    public Color getSizePrefixColor() {
        return this.sizePrefixColor.getColor();
    }

    public Color getStackVariableColor() {
        return this.stackVariableColor.getColor();
    }

    public Color getSymbolColor() {
        return this.symbolColor.getColor();
    }

    public void setCurrentValues() {
        ThemeConfigItem themeConfigItem = BinDiffConfig.getInstance().getThemeSettings();
        this.defaultColor.setColor(themeConfigItem.getDefaultColor());
        this.addressColor.setColor(themeConfigItem.getAddressColor());
        this.mnemonicColor.setColor(themeConfigItem.getMnemonicColor());
        this.registerColor.setColor(themeConfigItem.getRegisterColor());
        this.functionColor.setColor(themeConfigItem.getFunctionColor());
        this.immediateColor.setColor(themeConfigItem.getImmediateColor());
        this.globalVariableColor.setColor(themeConfigItem.getGlobalVariableColor());
        this.stackVariableColor.setColor(themeConfigItem.getStackVariableColor());
        this.jumpLabelColor.setColor(themeConfigItem.getJumpLabelColor());
        this.operatorColor.setColor(themeConfigItem.getOperatorColor());
        this.dereferenceColor.setColor(themeConfigItem.getDereferenceColor());
        this.operandSeparatorColor.setColor(themeConfigItem.getOperatorSeparatorColor());
        this.symbolColor.setColor(themeConfigItem.getSymbolColor());
        this.sizePrefixColor.setColor(themeConfigItem.getSizePrefixColor());
        this.commentColor.setColor(themeConfigItem.getCommentColor());
    }
}

