/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.panels;

import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.logging.Logger;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.io.DirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class LoggingPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS_PANEL_1 = 3;
    private static final int NUMBER_OF_ROWS_PANEL_2 = 6;
    private final JCheckBox consoleLogging = new JCheckBox();
    private final JCheckBox fileLogging = new JCheckBox();
    private final JComboBox<String> logLevel = new JComboBox<String>(new String[]{"Debug", "Info", "Warning", "Error", "Off"});
    private FileChooserPanel logFileLocationPanel;

    public LoggingPanel() {
        super(new BorderLayout());
        this.init();
    }

    private static String selectLogFileDirectory(Container container) {
        DirectoryChooser directoryChooser = new DirectoryChooser("Select Logger Directory");
        return directoryChooser.showOpenDialog(container) == 0 ? directoryChooser.getSelectedFile().getAbsolutePath() : null;
    }

    private JPanel createLoggingDetailPanel() {
        JPanel jPanel = new JPanel(new GridLayout(6, 1, 5, 5));
        jPanel.setBorder(new TitledBorder("Detail"));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Log level:", 275, this.logLevel, 25));
        return jPanel;
    }

    private JPanel createLoggingPanel() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        String string = generalSettingsConfigItem.getLogFileLocation();
        if ("".equals(string)) {
            string = Logger.getDefaultLoggingDirectoryPath();
        }
        this.logFileLocationPanel = new FileChooserPanel(string, new InternalLogFileDirectoryListener(), "...", 0, 25, 0);
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        jPanel.setBorder(new TitledBorder("Activation"));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Console logging:", 275, this.consoleLogging, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("File logging:", 275, this.fileLogging, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Logger directory:", 275, this.logFileLocationPanel, 25));
        return jPanel;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.createLoggingPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.createLoggingDetailPanel(), gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        this.add(new JScrollPane(jPanel));
        this.setCurrentValues();
    }

    public boolean getConsoleLogging() {
        return this.consoleLogging.isSelected();
    }

    public boolean getFileLogging() {
        return this.fileLogging.isSelected();
    }

    public String getLogFileLocation() {
        return this.logFileLocationPanel.getText();
    }

    private static int levelToIndex(Level level) {
        if (level.equals(Level.ALL)) {
            return 0;
        }
        if (level.equals(Level.INFO)) {
            return 1;
        }
        if (level.equals(Level.WARNING)) {
            return 2;
        }
        if (level.equals(Level.SEVERE)) {
            return 3;
        }
        if (level.equals(Level.OFF)) {
            return 4;
        }
        return 1;
    }

    public Level getLogLevel() {
        switch (this.logLevel.getSelectedIndex()) {
            case 0: {
                return Level.ALL;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.SEVERE;
            }
            case 4: {
                return Level.OFF;
            }
        }
        return Level.INFO;
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        this.consoleLogging.setSelected(generalSettingsConfigItem.getConsoleLogging());
        this.fileLogging.setSelected(generalSettingsConfigItem.getFileLogging());
        this.logLevel.setSelectedIndex(LoggingPanel.levelToIndex(generalSettingsConfigItem.getLogLevel()));
    }

    private class InternalLogFileDirectoryListener
    implements ActionListener {
        private InternalLogFileDirectoryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = LoggingPanel.selectLogFileDirectory(LoggingPanel.this.getParent());
            if (string != null) {
                LoggingPanel.this.logFileLocationPanel.setText(string);
            }
        }
    }
}

