/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.panels;

import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.io.DirectoryChooser;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 2;
    private FileChooserPanel idaDirectoryPanel;
    private FileChooserPanel workspaceDirectoryPanel;

    public GeneralPanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setBorder(new LineBorder(Color.GRAY));
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        InternalDirectoryListener internalDirectoryListener = new InternalDirectoryListener("Choose IDA Installation Directory");
        this.idaDirectoryPanel = new FileChooserPanel(generalSettingsConfigItem.getIdaDirectory(), internalDirectoryListener, "...", 0, 25, 0);
        internalDirectoryListener.setPanel(this.idaDirectoryPanel);
        String string = generalSettingsConfigItem.getWorkspaceDirectory();
        if ("".equals(string)) {
            string = SystemHelpers.getUserDirectory();
        }
        InternalDirectoryListener internalDirectoryListener2 = new InternalDirectoryListener("Choose Workspace Directory");
        this.workspaceDirectoryPanel = new FileChooserPanel(string, internalDirectoryListener2, "...", 0, 25, 0);
        internalDirectoryListener2.setPanel(this.workspaceDirectoryPanel);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel.setBorder(new TitledBorder("General settings"));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("IDA directory:", 275, this.idaDirectoryPanel, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Workspaces directory:", 275, this.workspaceDirectoryPanel, 25));
        this.add((Component)jPanel, "North");
    }

    public String getIDADirectory() {
        return this.idaDirectoryPanel.getText();
    }

    public String getWorkspaceDirectory() {
        return this.workspaceDirectoryPanel.getText();
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        this.idaDirectoryPanel.setText(generalSettingsConfigItem.getIdaDirectory());
        String string = generalSettingsConfigItem.getWorkspaceDirectory();
        if ("".equals(string)) {
            string = SystemHelpers.getUserDirectory();
        }
        this.workspaceDirectoryPanel.setText(string);
    }

    private class InternalDirectoryListener
    implements ActionListener {
        FileChooserPanel panel;
        final String title;

        public InternalDirectoryListener(String string) {
            this.title = string;
        }

        public void setPanel(FileChooserPanel fileChooserPanel) {
            this.panel = fileChooserPanel;
        }

        private String selectDirectory(Container container) {
            DirectoryChooser directoryChooser = new DirectoryChooser(this.title);
            directoryChooser.setCurrentDirectory(new File(this.panel.getText()));
            if (directoryChooser.showOpenDialog(container) == 0) {
                File file = directoryChooser.getSelectedFile();
                if (!file.exists()) {
                    CMessageBox.showError(container, "Directory does not exist.");
                    return null;
                }
                if (!file.canExecute()) {
                    CMessageBox.showError(container, "Directory is not executable.");
                    return null;
                }
                return file.getAbsolutePath();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.selectDirectory(GeneralPanel.this.getParent());
            if (string != null) {
                this.panel.setText(string);
            }
        }
    }
}

