/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.mainsettings;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.BinDiff;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.config.ThemeConfigItem;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.panels.GeneralPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.panels.LoggingPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.mainsettings.panels.SyntaxHighlightingPanel;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class MainSettingsDialog
extends BaseDialog {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 430;
    private final GeneralPanel generalPanel = new GeneralPanel();
    private final LoggingPanel loggingPanel = new LoggingPanel();
    private final SyntaxHighlightingPanel syntaxHighlightingPanel = new SyntaxHighlightingPanel();
    private final CPanelTwoButtons buttons = new CPanelTwoButtons(new InternalButtonListener(), "Ok", "Cancel");

    public MainSettingsDialog(Window window) {
        super(window, "Main Settings");
        this.init();
        this.pack();
        this.setSize(600, 430);
        this.setMinimumSize(new Dimension(600, 430));
        GuiHelper.centerChildToParent(window, this, true);
    }

    private void adoptChanges() {
        try {
            BinDiff.applyLoggingChanges();
        }
        catch (IOException | SecurityException exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Couldn't create file logger");
            CMessageBox.showError(this, "Couldn't create file logger.");
        }
    }

    private void save() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        ThemeConfigItem themeConfigItem = binDiffConfig.getThemeSettings();
        generalSettingsConfigItem.setIdaDirectory(this.generalPanel.getIDADirectory());
        generalSettingsConfigItem.setWorkspaceDirectory(this.generalPanel.getWorkspaceDirectory());
        generalSettingsConfigItem.setConsoleLogging(this.loggingPanel.getConsoleLogging());
        generalSettingsConfigItem.setFileLogging(this.loggingPanel.getFileLogging());
        generalSettingsConfigItem.setLogFileLocation(this.loggingPanel.getLogFileLocation());
        generalSettingsConfigItem.setLogLevel(this.loggingPanel.getLogLevel());
        themeConfigItem.setAddressColor(this.syntaxHighlightingPanel.getAddressColor());
        themeConfigItem.setMnemonicColor(this.syntaxHighlightingPanel.getMnemonicColor());
        themeConfigItem.setRegisterColor(this.syntaxHighlightingPanel.getRegisterColor());
        themeConfigItem.setOperatorColor(this.syntaxHighlightingPanel.getOperatorColor());
        themeConfigItem.setSizePrefixColor(this.syntaxHighlightingPanel.getSizePrefixColor());
        themeConfigItem.setDereferenceColor(this.syntaxHighlightingPanel.getDereferenceColor());
        themeConfigItem.setImmediateColor(this.syntaxHighlightingPanel.getImmediateColor());
        themeConfigItem.setOperatorSeparatorColor(this.syntaxHighlightingPanel.getOperandSeparatorColor());
        themeConfigItem.setCommentColor(this.syntaxHighlightingPanel.getCommentColor());
        themeConfigItem.setDefaultColor(this.syntaxHighlightingPanel.getDefaultColor());
        themeConfigItem.setSymbolColor(this.syntaxHighlightingPanel.getSymbolColor());
        themeConfigItem.setStackVariableColor(this.syntaxHighlightingPanel.getStackVariableColor());
        themeConfigItem.setGlobalVariableColor(this.syntaxHighlightingPanel.getGlobalVariableColor());
        themeConfigItem.setJumpLabelColor(this.syntaxHighlightingPanel.getJumpLabelColor());
        themeConfigItem.setFunctionColor(this.syntaxHighlightingPanel.getFunctionColor());
        this.adoptChanges();
        binDiffConfig.write();
    }

    private void init() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("General", this.generalPanel);
        jTabbedPane.addTab("Logging", this.loggingPanel);
        jTabbedPane.addTab("Syntax Highlighting", this.syntaxHighlightingPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        jPanel.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)this.buttons, "South");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setVisible(boolean bl2) {
        this.generalPanel.setCurrentValues();
        this.loggingPanel.setCurrentValues();
        this.syntaxHighlightingPanel.setCurrentValues();
        super.setVisible(bl2);
    }

    private class InternalButtonListener
    implements ActionListener {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MainSettingsDialog.this.buttons.getFirstButton()) {
                try {
                    MainSettingsDialog.this.save();
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Couldn't save main settings");
                    CMessageBox.showError(MainSettingsDialog.this, "Couldn't save main settings.");
                }
            }
            MainSettingsDialog.this.dispose();
        }
    }
}

