/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.components.SliderPanel;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;

public class ProximityBrowsingPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 5;
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 10;
    private static final int SLIDER_LABEL_WIDTH = 25;
    private final JComboBox<String> proximityBrowsing = new JComboBox();
    private final SliderPanel proximityBrowsingParentDepth = new SliderPanel(0, 0, 10, true, true, false, true, 25, 25);
    private final SliderPanel proximityBrowsingChildDepth = new SliderPanel(0, 0, 10, true, true, false, true, 25, 25);
    private final JFormattedTextField autoProximityBrowsingActivionThreshold = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(5))));
    private final JFormattedTextField visibilityWarningThreshold = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(5))));
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public ProximityBrowsingPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public ProximityBrowsingPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.init(string);
    }

    private int getAutoProximityBrowsingActivationThreshold(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getAutoProximityBrowsingActivationThreshold();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getAutoProximityBrowsingActivationThreshold();
            }
        }
        return this.settings.getProximitySettings().getAutoProximityBrowsingActivationThreshold();
    }

    private boolean getProximityBrowsing(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getProximityBrowsing();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getProximityBrowsing();
            }
        }
        return this.settings.getProximitySettings().getProximityBrowsing();
    }

    private int getProximityBrowsingChildDepth(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getProximityBrowsingChildDepth();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getProximityBrowsingChildDepth();
            }
        }
        return this.settings.getProximitySettings().getProximityBrowsingChildren();
    }

    private int getProximityBrowsingParentDepth(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getProximityBrowsingParentDepth();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getProximityBrowsingParentDepth();
            }
        }
        return this.settings.getProximitySettings().getProximityBrowsingParents();
    }

    private int getVisibilityWarningThreshold(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getVisibilityWarningThreshold();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getVisibilityWarningThreshold();
            }
        }
        return this.settings.getLayoutSettings().getVisibilityWarningThreshold();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.proximityBrowsing.addItem("On");
        this.proximityBrowsing.addItem("Off");
        this.setCurrentValues();
        int n2 = this.dialogType != ESettingsDialogType.GRAPH_VIEW_SETTINGS ? 5 : 3;
        JPanel jPanel = new JPanel(new GridLayout(n2, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        if (this.dialogType != ESettingsDialogType.GRAPH_VIEW_SETTINGS) {
            jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Automatic proximity browsing", 275, this.proximityBrowsing, 25));
        }
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Proximity browsing parent depth", 275, this.proximityBrowsingParentDepth, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Proximity browsing child depth", 275, this.proximityBrowsingChildDepth, 25));
        if (this.dialogType != ESettingsDialogType.GRAPH_VIEW_SETTINGS) {
            jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Automatic proximity browsing activation threshold", 275, this.autoProximityBrowsingActivionThreshold, 25));
        }
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Visibility Warning threshold", 275, this.visibilityWarningThreshold, 25));
        this.add((Component)jPanel, "North");
    }

    public void dispose() {
        this.proximityBrowsingParentDepth.dispose();
        this.proximityBrowsingChildDepth.dispose();
    }

    public int getAutoProximityBrowsingActivationThreshold() {
        return Integer.parseInt(this.autoProximityBrowsingActivionThreshold.getText());
    }

    public boolean getProximityBrowsing() {
        return this.proximityBrowsing.getSelectedIndex() == 0;
    }

    public int getProximityBrowsingChildDepth() {
        return this.proximityBrowsingChildDepth.getValue();
    }

    public int getProximityBrowsingParentDepth() {
        return this.proximityBrowsingParentDepth.getValue();
    }

    public int getVisibilityWarningThreshold() {
        return Integer.parseInt(this.visibilityWarningThreshold.getText());
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.proximityBrowsing.setSelectedIndex(this.getProximityBrowsing(binDiffConfig) ? 0 : 1);
        this.proximityBrowsingParentDepth.setValue(this.getProximityBrowsingParentDepth(binDiffConfig));
        this.proximityBrowsingChildDepth.setValue(this.getProximityBrowsingChildDepth(binDiffConfig));
        this.autoProximityBrowsingActivionThreshold.setText(Integer.toString(this.getAutoProximityBrowsingActivationThreshold(binDiffConfig)));
        this.visibilityWarningThreshold.setText(Integer.toString(this.getVisibilityWarningThreshold(binDiffConfig)));
    }
}

