/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.ELayoutOrientation;
import com.google.security.zynamics.bindiff.enums.EOrthogonalLayoutStyle;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;

public class OrthogonalLayoutPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 3;
    private final JComboBox<String> orientation = new JComboBox();
    private final JComboBox<String> layoutStyle = new JComboBox();
    private final JFormattedTextField minimumNodeDistance = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(3))));
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public OrthogonalLayoutPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public OrthogonalLayoutPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.init(string);
    }

    private int getMinimumNodeDistance(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getOrthogonalMinimumNodeDistance();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getOrthogonalMinimumNodeDistance();
            }
        }
        return (int)this.settings.getLayoutSettings().getMinimumOrthogonalNodeDistance();
    }

    private EOrthogonalLayoutStyle getOrthogonalLayoutStyle(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getOrthogonalLayoutStyle();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getOrthogonalLayoutStyle();
            }
        }
        return this.settings.getLayoutSettings().getOrthogonalLayoutStyle();
    }

    private ELayoutOrientation getOrthogonalOrientation(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getOrthogonalOrientation();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getOrthogonalOrientation();
            }
        }
        return this.settings.getLayoutSettings().getOrthogonalLayoutOrientation();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.layoutStyle.addItem("Normal");
        this.layoutStyle.addItem("Tree");
        this.orientation.addItem("Horizontal");
        this.orientation.addItem("Vertical");
        this.setCurrentValues();
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Layout Style", 275, this.layoutStyle, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Layout orientation", 275, this.orientation, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Minimum node distance", 275, this.minimumNodeDistance, 25));
        this.add((Component)jPanel, "North");
    }

    public int getMinimumNodeDistance() {
        return Integer.parseInt(this.minimumNodeDistance.getText());
    }

    public EOrthogonalLayoutStyle getOrthogonalLayoutStyle() {
        return EOrthogonalLayoutStyle.getEnum(this.layoutStyle.getSelectedIndex());
    }

    public ELayoutOrientation getOrthogonalOrientation() {
        return ELayoutOrientation.getEnum(this.orientation.getSelectedIndex());
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.layoutStyle.setSelectedIndex(EOrthogonalLayoutStyle.getOrdinal(this.getOrthogonalLayoutStyle(binDiffConfig)));
        this.orientation.setSelectedIndex(ELayoutOrientation.getOrdinal(this.getOrthogonalOrientation(binDiffConfig)));
        this.minimumNodeDistance.setText(Integer.toString(this.getMinimumNodeDistance(binDiffConfig)));
    }
}

