/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.EGraphSynchronization;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.sliders.DoubleLabeledSlider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class MiscPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 4;
    private final JCheckBox viewSynchronization = new JCheckBox();
    private final JCheckBox layoutAnimation = new JCheckBox();
    private final DoubleLabeledSlider animationSpeed = new DoubleLabeledSlider("  Slow  ", "  Fast  ", 1, 10, false, new LineBorder(Color.GRAY));
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public MiscPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public MiscPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.animationSpeed.setInverted(true);
        this.init(string);
    }

    private int getAnimationSpeed(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getAnimationSpeed();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getAnimationSpeed();
            }
        }
        return this.settings.getDisplaySettings().getAnimationSpeed();
    }

    private boolean getViewSynchronization(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getViewSynchronization();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getViewSynchronization();
            }
        }
        return this.settings.getGraphSyncMode() == EGraphSynchronization.SYNC;
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.setCurrentValues();
        int n2 = this.dialogType != ESettingsDialogType.GRAPH_VIEW_SETTINGS ? 4 : 3;
        JPanel jPanel = new JPanel(new GridLayout(n2, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        if (this.dialogType != ESettingsDialogType.GRAPH_VIEW_SETTINGS) {
            jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Views synchronization", 275, this.viewSynchronization, 25));
        }
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Layout animation", 275, this.layoutAnimation, 25));
        JPanel jPanel2 = GuiUtils.createHorizontalNamedComponentPanel("Animation speed", 275, this.animationSpeed, 25);
        this.layoutAnimation.addItemListener(itemEvent -> this.animationSpeed.setEnabled(this.layoutAnimation.isSelected()));
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
    }

    public int getAnimationSpeed() {
        return this.layoutAnimation.isSelected() ? this.animationSpeed.getValue() : 0;
    }

    public boolean getViewSynchronization() {
        return this.viewSynchronization.isSelected();
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.viewSynchronization.setSelected(this.getViewSynchronization(binDiffConfig));
        int n2 = this.getAnimationSpeed(binDiffConfig);
        this.layoutAnimation.setSelected(n2 > 0);
        this.animationSpeed.setValue(n2);
    }
}

