/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.EGraphLayout;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public final class LayoutingPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 2;
    private final JComboBox<String> initalLayout = new JComboBox();
    private final JComboBox<String> autoLayouting = new JComboBox();
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public LayoutingPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public LayoutingPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.init(string);
    }

    private boolean getAutoLayouting(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getAutoLayouting();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getAutoLayouting();
            }
        }
        return this.settings.getLayoutSettings().getAutomaticLayouting();
    }

    private EGraphLayout getDefaultGraphLayout(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getDefaultGraphLayout();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getDefaultGraphLayout();
            }
        }
        return this.settings.getLayoutSettings().getDefaultGraphLayout();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.initalLayout.addItem("Hierarchical");
        this.initalLayout.addItem("Orthogonal");
        this.initalLayout.addItem("Circular");
        this.autoLayouting.addItem("On");
        this.autoLayouting.addItem("Off");
        this.setCurrentValues();
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Default layout", 275, this.initalLayout, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Automatic layouting", 275, this.autoLayouting, 25));
        this.add((Component)jPanel, "North");
    }

    public boolean getAutoLayouting() {
        return this.autoLayouting.getSelectedIndex() == 0;
    }

    public EGraphLayout getDefaultLayout() {
        return EGraphLayout.getEnum(this.initalLayout.getSelectedIndex());
    }

    public void getDefaultLayout(EGraphLayout eGraphLayout) {
        this.initalLayout.setSelectedIndex(EGraphLayout.getOrdinal(eGraphLayout));
    }

    public void setAutoLayouting(boolean bl2) {
        this.autoLayouting.setSelectedIndex(bl2 ? 0 : 1);
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.initalLayout.setSelectedIndex(EGraphLayout.getOrdinal(this.getDefaultGraphLayout(binDiffConfig)));
        this.autoLayouting.setSelectedIndex(this.getAutoLayouting(binDiffConfig) ? 0 : 1);
    }
}

