/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.ELayoutOrientation;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;

public class HierarchicalLayoutPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 4;
    private final JComboBox<String> orientation = new JComboBox();
    private final JComboBox<String> layoutStyle = new JComboBox();
    private final JFormattedTextField minimumLayerDistance = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(3))));
    private final JFormattedTextField minimumNodeDistance = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(3))));
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public HierarchicalLayoutPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public HierarchicalLayoutPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.init(string);
    }

    private ELayoutOrientation getLayoutOrientation(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return ELayoutOrientation.getEnum(binDiffConfig.getInitialCallGraphSettings().getHierarchicalOrientation());
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return ELayoutOrientation.getEnum(binDiffConfig.getInitialFlowGraphSettings().getHierarchicalOrientation());
            }
        }
        return this.settings.getLayoutSettings().getHierarchicOrientation();
    }

    private int getMinimumLayerDistance(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getHierarchicalMinimumNodeDistance();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getHierarchicalMinimumNodeDistance();
            }
        }
        return (int)this.settings.getLayoutSettings().getMinimumHierarchicLayerDistance();
    }

    private int getMinimumNodeDistance(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getHierarchicalMinimumLayerDistance();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getHierarchicalMinimumLayerDistance();
            }
        }
        return (int)this.settings.getLayoutSettings().getMinimumHierarchicNodeDistance();
    }

    private boolean getOrthogonalEdgeRouting(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getHierarchicalOrthogonalEdgeRouting();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getHierarchicalOrthogonalEdgeRouting();
            }
        }
        return this.settings.getLayoutSettings().getHierarchicalOrthogonalEdgeRouting();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.layoutStyle.addItem("On");
        this.layoutStyle.addItem("Off");
        this.orientation.addItem("Vertical");
        this.orientation.addItem("Horizontal");
        this.setCurrentValues();
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Orthogonal Edge Routing", 275, this.layoutStyle, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Layout orientation", 275, this.orientation, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Minimum layer distance", 275, this.minimumLayerDistance, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Minimum node distance", 275, this.minimumNodeDistance, 25));
        this.add((Component)jPanel, "North");
    }

    public ELayoutOrientation getLayoutOrientation() {
        return ELayoutOrientation.getEnum(this.orientation.getSelectedIndex());
    }

    public int getMinimumLayerDistance() {
        return Integer.parseInt(this.minimumLayerDistance.getText());
    }

    public int getMinimumNodeDistance() {
        return Integer.parseInt(this.minimumNodeDistance.getText());
    }

    public boolean getOrthogonalEdgeRouting() {
        return this.layoutStyle.getSelectedIndex() == 0;
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.layoutStyle.setSelectedIndex(this.getOrthogonalEdgeRouting(binDiffConfig) ? 0 : 1);
        this.orientation.setSelectedIndex(ELayoutOrientation.getOrdinal(this.getLayoutOrientation(binDiffConfig)));
        this.minimumLayerDistance.setText(Integer.toString(this.getMinimumLayerDistance(binDiffConfig)));
        this.minimumNodeDistance.setText(Integer.toString(this.getMinimumNodeDistance(binDiffConfig)));
    }
}

