/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class EdgesPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 1;
    private final JComboBox<String> drawBends = new JComboBox();
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public EdgesPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public EdgesPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.init(string);
    }

    private boolean getDrawBends(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getDrawBends();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getDrawBends();
            }
        }
        return this.settings.getDrawBends();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.drawBends.addItem("On");
        this.drawBends.addItem("Off");
        this.setCurrentValues();
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Draw bends", 275, this.drawBends, 25));
        this.add((Component)jPanel, "North");
    }

    public boolean getDrawBends() {
        return this.drawBends.getSelectedIndex() == 0;
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.drawBends.setSelectedIndex(this.getDrawBends(binDiffConfig) ? 0 : 1);
    }
}

